/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.pdb.view;

import de.grogra.ext.pdb.model.IProtein;
import de.grogra.ext.pdb.view.Visualizer;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import java.util.HashMap;

public class BackboneVisualizer
implements Visualizer,
Command {
    private IProtein protein;
    private final float RADIUS = 0.3f;
    private final int BACKBONEATOMS = 2;
    private static HashMap colors = new HashMap();

    public BackboneVisualizer(IProtein iProtein) {
        this.protein = iProtein;
        colors.put("ALA", RGBAShader.YELLOW);
        colors.put("ARG", RGBAShader.BLUE);
        colors.put("ASN", RGBAShader.CYAN);
        colors.put("ASP", RGBAShader.RED);
        colors.put("CYS", RGBAShader.GRAY);
        colors.put("GLN", RGBAShader.GREEN);
        colors.put("GLU", RGBAShader.PINK);
        colors.put("GLY", RGBAShader.MAGENTA);
        colors.put("HIS", RGBAShader.ORANGE);
        colors.put("ILE", new RGBAShader(-8388608));
        colors.put("LEU", new RGBAShader(-8355840));
        colors.put("LYS", new RGBAShader(-8339201));
        colors.put("MET", new RGBAShader(-16744448));
        colors.put("PHE", new RGBAShader(-16777088));
        colors.put("PRO", new RGBAShader(-16744320));
        colors.put("SER", new RGBAShader(-8388480));
        colors.put("THR", new RGBAShader(-12582912));
        colors.put("TRP", new RGBAShader(-32576));
        colors.put("TYR", new RGBAShader(-8323136));
        colors.put("VAL", new RGBAShader(-16256));
        colors.put("UNK", new RGBAShader(-64));
    }

    public Node createGraph() {
        Node node = new Node();
        Node node2 = new Node();
        for (int i = 0; i < this.protein.getNumberOfSequences(); ++i) {
            Node node3 = new Node();
            for (int j = 0; j < this.protein.getNumberOfAcids(i); ++j) {
                RGBAShader rGBAShader = (RGBAShader)colors.get(this.protein.getAcidName(i, j));
                for (int k = 0; k <= 2; ++k) {
                    Cylinder cylinder = new Cylinder();
                    cylinder.setTransform((double)this.protein.getXCoord(i, j, k), (double)this.protein.getYCoord(i, j, k), (double)this.protein.getZCoord(i, j, k));
                    cylinder.setRadius(0.3f);
                    cylinder.setShader((Shader)rGBAShader);
                    if (j > 0 && k == 0) {
                        cylinder.setEndPoints((double)this.protein.getXCoord(i, j, k), (double)this.protein.getYCoord(i, j, k), (double)this.protein.getZCoord(i, j, k), (double)this.protein.getXCoord(i, j - 1, 2), (double)this.protein.getYCoord(i, j - 1, 2), (double)this.protein.getZCoord(i, j - 1, 2));
                        node3.addEdgeBitsTo((Node)cylinder, 256, null);
                        continue;
                    }
                    if (k <= 0) continue;
                    cylinder.setEndPoints((double)this.protein.getXCoord(i, j, k), (double)this.protein.getYCoord(i, j, k), (double)this.protein.getZCoord(i, j, k), (double)this.protein.getXCoord(i, j - 1, k), (double)this.protein.getYCoord(i, j - 1, k), (double)this.protein.getZCoord(i, j - 1, k));
                    node3.addEdgeBitsTo((Node)cylinder, 256, null);
                }
                node2.addEdgeBitsTo(node3, 512, null);
            }
            node.addEdgeBitsTo(node2, 512, null);
        }
        return node;
    }

    public String getCommandName() {
        return null;
    }

    public void run(Object object, Context context) {
        System.out.println("running command Backbone Modell...");
    }
}

