/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import net.sourceforge.retroweaver.runtime.java.util.FormatterClosedException;
import net.sourceforge.retroweaver.runtime.java.util.IllegalFormatException;

public class Formatter {
    private Appendable buffer;
    private Method appendMethod;
    private Locale locale;
    private boolean closed;
    private IOException ioe;

    public Formatter() {
        this(new StringBuilder(), Locale.getDefault());
    }

    public Formatter(Appendable appendable) {
        this(appendable, Locale.getDefault());
    }

    public Formatter(Locale locale) {
        this(new StringBuilder(), locale);
    }

    public Formatter(Appendable appendable, Locale locale) {
        this.buffer = appendable == null ? new StringBuilder() : appendable;
        try {
            this.appendMethod = this.buffer.getClass().getMethod("append", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        this.locale = locale;
    }

    public Locale locale() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.locale;
    }

    public Appendable out() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.buffer;
    }

    public String toString() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.buffer.toString();
    }

    public void flush() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        try {
            Method method = this.buffer.getClass().getMethod("flush", new Class[0]);
            method.invoke((Object)this.buffer, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                Method method = this.buffer.getClass().getMethod("close", new Class[0]);
                method.invoke((Object)this.buffer, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IOException ioException() {
        return this.ioe;
    }

    public Formatter format(String string, Object ... objectArray) throws IllegalFormatException, FormatterClosedException {
        return this.format(this.locale, string, objectArray);
    }

    public Formatter format(Locale locale, String string, Object ... objectArray) throws IllegalFormatException, FormatterClosedException {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        int n = 0;
        int n2 = 0;
        block7: while (true) {
            try {
                while (true) {
                    int n3;
                    if ((n3 = string.indexOf(37, n)) == -1) {
                        this.append(string.substring(n, string.length()));
                        break block7;
                    }
                    this.append(string.substring(n, n3));
                    if (n3 == string.length()) {
                        throw new IllegalFormatException();
                    }
                    char c = string.charAt(n3 + 1);
                    switch (c) {
                        case '%': {
                            this.append("%");
                            break;
                        }
                        case 's': {
                            Object object = objectArray[n2++];
                            this.append(object == null ? null : object.toString());
                            break;
                        }
                        case 'd': {
                            Object object = objectArray[n2++];
                            this.append(object.toString());
                            break;
                        }
                        default: {
                            throw new IllegalFormatException();
                        }
                    }
                    n = n3 + 2;
                }
            }
            catch (IOException iOException) {
                this.ioe = iOException;
                continue;
            }
            break;
        }
        return this;
    }

    private void append(String string) throws IOException {
        try {
            this.appendMethod.invoke((Object)this.buffer, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof IOException) {
                throw (IOException)invocationTargetException.getCause();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

