/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang.reflect;

import java.lang.reflect.Method;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AIB;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.Annotation;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.ReflectionDescriptor;

public class Method_ {
    private Method_() {
    }

    public static Object getDefaultValue(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (!clazz.isAnnotation()) {
            return null;
        }
        return AIB.getAib(clazz).getDefaultValue(method.getName());
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> clazz) {
        Class<?> clazz2 = method.getDeclaringClass();
        return AIB.getAib(clazz2).getMethodAnnotation(method.getName(), method.getParameterTypes(), method.getReturnType(), clazz);
    }

    public static Annotation[] getAnnotations(Method method) {
        return Method_.getDeclaredAnnotations(method);
    }

    public static Annotation[] getDeclaredAnnotations(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return AIB.getAib(clazz).getMethodAnnotations(method.getName(), method.getParameterTypes(), method.getReturnType());
    }

    public static boolean isAnnotationPresent(Method method, Class<? extends Annotation> clazz) {
        return Method_.getAnnotation(method, clazz) != null;
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return AIB.getAib(clazz).getMethodParameterAnnotations(method.getName(), method.getParameterTypes(), method.getReturnType());
    }

    public static boolean isBridge(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return ReflectionDescriptor.getReflectionDescriptor(clazz).testMethodAccess(method, 64);
    }

    public static boolean isVarArgs(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return ReflectionDescriptor.getReflectionDescriptor(clazz).testMethodAccess(method, 128);
    }

    public static boolean isSynthetic(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return ReflectionDescriptor.getReflectionDescriptor(clazz).testMethodAccess(method, 4096);
    }
}

