/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.lang.VoidToObjectGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectList<E>
extends AbstractList<E>
implements RandomAccess,
Cloneable,
Serializable,
ObjectConsumer<E>,
VoidToObjectGenerator<E> {
    private static final long serialVersionUID = -2672494796732927877L;
    public transient Object[] elements;
    public int size = 0;
    private static final Object[] EMPTY = new Object[0];
    public boolean useEquals = true;
    private static final Object[] OBJECT_NULL = new Object[1024];

    public ObjectList(int n) {
        this.elements = new Object[Math.max(n, 8)];
    }

    public ObjectList() {
        this(16);
    }

    public ObjectList(E[] EArray) {
        this(EArray.length);
        this.size = EArray.length;
        ObjectList.arraycopy(EArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            ObjectList objectList = (ObjectList)super.clone();
            objectList.elements = new Object[Math.max(this.size, 8)];
            ObjectList.arraycopy(this.elements, 0, objectList.elements, 0, this.size);
            return objectList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            Object[] objectArray = new Object[Math.max(n, this.elements.length * 2)];
            ObjectList.arraycopy(this.elements, 0, objectArray, 0, this.size);
            this.elements = objectArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new Object[this.size];
                ObjectList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final ObjectList<E> push(E e) {
        this.add(e);
        return this;
    }

    public final ObjectList<E> push(E e, E e2) {
        this.add(e);
        this.add(e2);
        return this;
    }

    public final ObjectList<E> push(E e, E e2, E e3) {
        this.add(e);
        this.add(e2);
        this.add(e3);
        return this;
    }

    @Override
    public boolean add(E e) {
        ++this.modCount;
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = e;
        ++this.size;
        return true;
    }

    @Override
    public void add(int n, E e) {
        ++this.modCount;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
        } else {
            this.ensureCapacity(this.size + 1);
            ObjectList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = e;
        ++this.size;
    }

    public void addIfNotContained(E e) {
        if (!this.contains(e)) {
            this.add(e);
        }
    }

    public ObjectList<E> addAll(ObjectList<? extends E> objectList) {
        return this.addAll(objectList.elements, 0, objectList.size);
    }

    public ObjectList<E> addAll(Object[] objectArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        ++this.modCount;
        this.ensureCapacity(this.size + n2);
        ObjectList.arraycopy(objectArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public E removeAt(int n) {
        ++this.modCount;
        Object object = this.elements[n];
        ObjectList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        this.elements[this.size] = null;
        return (E)object;
    }

    @Override
    public E remove(int n) {
        ++this.modCount;
        Object object = this.elements[n];
        ObjectList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        this.elements[this.size] = null;
        return (E)object;
    }

    @Override
    public boolean remove(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (object != this.elements[i] && (!this.useEquals || object == null || !object.equals(this.elements[i]))) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public E set(int n, E e) {
        Object object;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            object = this.elements[n];
            this.elements[n] = e;
            this.size = n + 1;
        } else {
            object = this.elements[n];
            this.elements[n] = e;
        }
        return (E)object;
    }

    @Override
    public E get(int n) {
        return (E)(n < this.size ? this.elements[n] : null);
    }

    public E peek(int n) {
        return (E)(n > 0 ? this.elements[this.size - n] : null);
    }

    @Override
    public boolean contains(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (object != this.elements[i] && (!this.useEquals || object == null || !object.equals(this.elements[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (object != this.elements[i] && (!this.useEquals || object == null || !object.equals(this.elements[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (object != this.elements[i] && (!this.useEquals || object == null || !object.equals(this.elements[i]))) continue;
            return i;
        }
        return -1;
    }

    public ObjectList(int n, boolean bl) {
        this(n);
        this.useEquals = bl;
    }

    @Override
    public void clear() {
        ++this.modCount;
        ObjectList.clear(this.elements, 0, this.size);
        this.size = 0;
    }

    public void addInOrder(E e, Comparator<? super E> comparator) {
        int n;
        for (n = 0; n < this.size && comparator.compare(e, this.elements[n]) > 0; ++n) {
        }
        this.add(n, e);
    }

    public void addInOrder(Comparable<? super E> comparable) {
        int n;
        for (n = this.size; n > 0 && comparable.compareTo(this.elements[n - 1]) < 0; --n) {
        }
        this.add(n, comparable);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection instanceof ObjectList) {
            if (collection.isEmpty()) {
                return false;
            }
            this.addAll(((ObjectList)collection).elements, 0, collection.size());
            return true;
        }
        return super.addAll(collection);
    }

    public static void arraycopy(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        if (n3 < 20) {
            if (objectArray2 != objectArray || n2 > n) {
                while (--n3 >= 0) {
                    objectArray2[n2 + n3] = objectArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    objectArray2[n2 + i] = objectArray[n + i];
                }
            }
        } else {
            System.arraycopy(objectArray, n, objectArray2, n2, n3);
        }
    }

    public static void clear(Object[] objectArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                objectArray[n + n2] = null;
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                ObjectList.arraycopy(OBJECT_NULL, 0, objectArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public E pop() {
        ++this.modCount;
        Object object = this.elements[--this.size];
        this.elements[this.size] = null;
        return (E)object;
    }

    public void setSize(int n) {
        ++this.modCount;
        if (n > this.size) {
            this.ensureCapacity(n);
        } else {
            ObjectList.clear(this.elements, n, this.size - n);
        }
        this.size = n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        ObjectList.arraycopy(this.elements, 0, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = objectArray.length;
        if (n > this.size) {
            objectArray[this.size] = null;
        } else if (n < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        ObjectList.arraycopy(this.elements, 0, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list instanceof RandomAccess) {
            if (this.size != list.size()) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[i] == list.get(i) || this.useEquals && this.elements[i] != null && this.elements[i].equals(list.get(i))) continue;
                return false;
            }
            return true;
        }
        ListIterator listIterator = list.listIterator();
        for (int i = 0; i < this.size; ++i) {
            if (!listIterator.hasNext()) {
                return false;
            }
            Object e = listIterator.next();
            if (e == this.elements[i] || this.useEquals && e != null && e.equals(this.elements[i])) continue;
            return false;
        }
        return !listIterator.hasNext();
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            Object object = this.elements[i];
            n = 31 * n + (object != null ? object.hashCode() : 0);
        }
        return n;
    }

    @Override
    public void consume(E e) {
        this.add(e);
    }

    @Override
    public void evaluateObject(ObjectConsumer<? super E> objectConsumer) {
        for (int i = 0; i < this.size; ++i) {
            objectConsumer.consume(this.elements[i]);
        }
    }

    public void values(ObjectConsumer<? super E> objectConsumer) {
        this.evaluateObject(objectConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new Object[this.size];
        Object[] objectArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
    }
}

