/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vfs;

import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.vfs.FileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Date;
import java.util.Map;

public abstract class FileSystemBase
extends FileSystem {
    private final URLStreamHandler handler = new URLStreamHandler(){

        protected URLConnection openConnection(URL uRL) throws IOException {
            String string = uRL.getPath();
            Object object = string.equals("/") ? FileSystemBase.this.getRoot() : (string.endsWith("/") ? FileSystemBase.this.getFile(string.substring(1, string.length() - 1)) : FileSystemBase.this.getFile(string.substring(1)));
            if (object == null) {
                throw new FileNotFoundException(uRL.toString());
            }
            return new Connection(uRL, object);
        }
    };

    public FileSystemBase(String string, String string2) {
        super(string, string2);
    }

    public URL toURL(Object object) {
        String string = this.getRoot().equals(object) ? "/" : (!this.isLeaf(object) ? '/' + this.getPath(object) + '/' : '/' + this.getPath(object));
        try {
            return new URL(this.getProtocol(), null, -1, string, this.handler);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public URLStreamHandler getURLStreamHandler() {
        return this.handler;
    }

    public Object toFile(URL uRL) {
        if (!this.getProtocol().equals(uRL.getProtocol())) {
            return null;
        }
        String string = uRL.getPath();
        if ("/".equals(string)) {
            return this.getRoot();
        }
        int n = string.length() - 1;
        return this.getFile(string.charAt(n) == '/' ? string.substring(1, n) : string.substring(1));
    }

    private final class Connection
    extends URLConnection {
        private final Object file;
        private final StringMap header;

        Connection(URL uRL, Object object) {
            super(uRL);
            this.file = object;
            String string = new Date(FileSystemBase.this.getTime(object)).toString();
            this.header = new StringMap(4).putObject("date", string).putObject("last-modified", string).putObject("content-length", String.valueOf(FileSystemBase.this.getSize(object)));
            MimeType mimeType = FileSystemBase.this.getMimeType(object);
            if (mimeType != null) {
                this.header.putObject("content-type", mimeType.getMediaType());
            }
        }

        public void connect() {
            this.connected = true;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return FileSystemBase.this.getInputStream(this.file);
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return FileSystemBase.this.getOutputStream(this.file, false);
        }

        public String getHeaderFieldKey(int n) {
            return n >= 0 && n < this.header.size() ? this.header.getKeyAt(n) : null;
        }

        public String getHeaderField(int n) {
            return n >= 0 && n < this.header.size() ? (String)this.header.getValueAt(n) : null;
        }

        public String getHeaderField(String string) {
            return (String)this.header.get(string);
        }

        public Map getHeaderFields() {
            return this.header.toMap();
        }
    }
}

