/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.I18NBundle;
import de.grogra.util.PPMReader;
import de.grogra.util.SplashScreen;
import de.grogra.util.Utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;

public class AWTSplashScreen
extends Canvas
implements SplashScreen,
Runnable {
    private Rectangle barBounds;
    private Image backgroundImage;
    private Image foregroundImage;
    private Image logoImage;
    private Graphics imageGraphics;
    private Image barLeft;
    private Image barRight;
    private Image buffer;
    private Graphics bufferGraphics;
    private Window splash = null;
    private Frame frame;
    private I18NBundle mainI18n;
    private Point textLocation;
    private Color textColor;
    private float progress = 0.0f;
    private int lastProgressPos;
    private String text = "";
    private volatile boolean dispose = false;
    private boolean versionInfo = false;

    public void init(String string, URL uRL, URL uRL2, URL uRL3, Rectangle rectangle, URL uRL4, URL uRL5, Point point, Font font, Color color, boolean bl, I18NBundle i18NBundle) {
        this.frame = new Frame();
        this.frame.setTitle(string);
        this.backgroundImage = this.toImage(uRL);
        this.foregroundImage = this.toImage(uRL2);
        this.logoImage = this.toImage(uRL3);
        this.barBounds = rectangle;
        this.barLeft = this.toImage(uRL4);
        this.barRight = this.toImage(uRL5);
        this.textLocation = point;
        this.textColor = color;
        this.versionInfo = bl;
        this.mainI18n = i18NBundle;
        this.setFont(font);
        if (this.backgroundImage != null && this.barLeft != null && this.barRight != null) {
            this.imageGraphics = this.backgroundImage.getGraphics();
            this.imageGraphics.drawImage(this.barLeft, rectangle.x, rectangle.y, null);
            this.lastProgressPos = this.barLeft.getWidth(null) - 1;
        } else {
            this.barLeft = null;
            this.barRight = null;
        }
    }

    private Image toImage(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if ("file".equals(uRL.getProtocol()) && uRL.getPath().endsWith(".ppm")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(Utils.urlToFile(uRL));
                BufferedImage bufferedImage = new PPMReader(new BufferedInputStream(fileInputStream), 1000000).read();
                ((InputStream)fileInputStream).close();
                return bufferedImage;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return new ImageIcon(uRL).getImage();
    }

    public void show() {
        this.splash = new Window(this.frame);
        this.splash.setBackground(Color.LIGHT_GRAY);
        this.splash.add((Component)this, "Center");
        this.splash.pack();
        Rectangle rectangle = this.frame.getGraphicsConfiguration().getBounds();
        this.splash.setLocation((rectangle.x + rectangle.width - this.splash.getWidth()) / 2, (rectangle.y + rectangle.height - this.splash.getHeight()) / 2);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AWTSplashScreen.this.splash.setVisible(true);
                AWTSplashScreen.this.splash.toFront();
            }
        });
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.buffer == null) {
            this.buffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.bufferGraphics = this.buffer.getGraphics();
        }
        if (this.backgroundImage != null) {
            if (this.barLeft != null) {
                int n = this.barLeft.getWidth(null);
                int n2 = Math.round(this.progress * (float)(this.barBounds.width - n - this.barRight.getWidth(null))) + n;
                while (this.lastProgressPos < n2) {
                    this.imageGraphics.drawImage(this.barRight, this.barBounds.x + ++this.lastProgressPos, this.barBounds.y, null);
                }
            }
            this.bufferGraphics.drawImage(this.backgroundImage, 0, 0, null);
            if (this.foregroundImage != null) {
                this.bufferGraphics.drawImage(this.foregroundImage, 0, 0, null);
            }
            if (this.logoImage != null) {
                this.bufferGraphics.drawImage(this.logoImage, 0, 0, null);
            }
            this.bufferGraphics.setColor(new Color(0.66f, 0.66f, 0.66f));
            this.bufferGraphics.drawString(this.mainI18n.msg("splash.text1"), this.textLocation.x - 15, this.textLocation.y - 85);
            this.bufferGraphics.drawString(this.mainI18n.msg("splash.text2"), this.textLocation.x - 15, this.textLocation.y - 70);
            this.bufferGraphics.drawString(this.mainI18n.msg("splash.text3"), this.textLocation.x - 15, this.textLocation.y - 55);
            this.bufferGraphics.setColor(this.textColor);
            this.bufferGraphics.drawString(this.text, this.textLocation.x, this.textLocation.y);
            if (this.versionInfo) {
                this.bufferGraphics.setColor(new Color(1.0f, 0.2f, 0.2f));
                this.bufferGraphics.drawString(this.mainI18n.msg("new.version.info.message"), this.textLocation.x, this.textLocation.y - 33);
            }
        } else {
            this.bufferGraphics.setColor(Color.BLACK);
            FontMetrics fontMetrics = this.bufferGraphics.getFontMetrics();
            this.bufferGraphics.drawString(this.frame.getTitle(), (this.getWidth() - fontMetrics.stringWidth(this.text)) / 2, this.getHeight() / 2);
        }
        graphics.drawImage(this.buffer, 0, 0, null);
    }

    public void setInitializationProgress(float f, String string) {
        this.text = string;
        this.progress = f;
        if (this.splash != null) {
            this.repaint();
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void toFront() {
        EventQueue.invokeLater(this);
    }

    public void close() {
        if (!this.dispose) {
            this.dispose = true;
            EventQueue.invokeLater(this);
        }
    }

    public void run() {
        if (this.splash != null) {
            if (this.dispose) {
                this.splash.dispose();
                this.splash = null;
                this.frame.dispose();
            } else {
                this.splash.toFront();
            }
        }
    }
}

