/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.reflect;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import java.util.HashMap;

public class ClassLoaderAdapter
implements TypeLoader {
    private final ClassLoader loader;
    private final HashMap types = new HashMap(32);

    public ClassLoaderAdapter(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public Class classForName(String string) throws ClassNotFoundException {
        return Class.forName(string, false, this.loader);
    }

    public synchronized Type typeForName(String string) throws ClassNotFoundException {
        Object v = this.types.get(string);
        if (v != null) {
            if (v != this) {
                return (Type)v;
            }
            throw new ClassNotFoundException(string);
        }
        try {
            ClassAdapter<?> classAdapter = ClassAdapter.wrap(Class.forName(string, false, this.loader));
            this.types.put(string, classAdapter);
            return classAdapter;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.types.put(string, this);
            throw classNotFoundException;
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

