/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.XMLPersistenceReader;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.XMLReaderBase;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GraphMLReader
extends XMLReaderBase {
    static final String GRAPHML_NAMESPACE = "http://graphml.graphdrawing.org/xmlns";
    static final int ILLEGAL_DATA = -1;
    static final int BITS = 0;
    static final int TYPE = 1;
    static final int VALUE = 2;
    HashMap keyToAttr = new HashMap();
    HashMap idToNode = new HashMap();
    ObjectList edges = new ObjectList();
    XMLPersistenceReader xmlReader;
    int data;
    Node root;
    String nodeId;
    String type;
    String value;
    String sourceId;
    String targetId;
    String bits;

    public GraphMLReader(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.NODE);
    }

    protected Object getObjectImpl() {
        return this.root;
    }

    private static int getBits(String string, Node node, Node node2) throws SAXException {
        return string != null ? Edge.parseEdgeKeys(string, node, node2) : 512;
    }

    public void startDocument() {
        this.xmlReader = new XMLPersistenceReader(new PersistenceBindings(this.getRegistry(), this.getRegistry()));
    }

    public void endDocument() throws SAXException {
        while (!this.edges.isEmpty()) {
            Object e = this.edges.pop();
            Node node = (Node)this.idToNode.get(this.edges.pop());
            Node node2 = (Node)this.idToNode.get(this.edges.pop());
            if (e instanceof Node) {
                node2.addEdgeBitsTo((Node)e, 1, null);
                ((Node)e).addEdgeBitsTo(node, 128, null);
                continue;
            }
            node2.addEdgeBitsTo(node, GraphMLReader.getBits((String)e, node2, node), null);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block4: {
            int n;
            String string4;
            block9: {
                String string5;
                String string6;
                block10: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    this.data = -1;
                                    if (!GRAPHML_NAMESPACE.equals(string)) break block4;
                                    string4 = attributes.getValue("", "id");
                                    if (!"data".equals(string2)) break block5;
                                    Object v = this.keyToAttr.get(attributes.getValue("", "key"));
                                    if (v == null) {
                                        throw new SAXException("Unknown key " + attributes.getValue("", "key"));
                                    }
                                    this.data = (Integer)v;
                                    break block4;
                                }
                                if (!"node".equals(string2)) break block6;
                                this.nodeId = string4;
                                this.type = null;
                                this.value = null;
                                break block4;
                            }
                            if (!"edge".equals(string2)) break block7;
                            this.sourceId = attributes.getValue("", "source");
                            this.targetId = attributes.getValue("", "target");
                            this.bits = null;
                            this.type = null;
                            this.value = null;
                            break block4;
                        }
                        if (!"key".equals(string2) || (string6 = attributes.getValue("", "attr.name")) == null || !"node".equals(string5 = attributes.getValue("", "for")) && !"edge".equals(string5)) break block4;
                        if (!string6.equals("type")) break block8;
                        n = 1;
                        break block9;
                    }
                    if (!string6.equals("value")) break block10;
                    n = 2;
                    break block9;
                }
                if (!"edge".equals(string5) || !string6.equals("bits")) break block4;
                n = 0;
            }
            this.keyToAttr.put(string4, n);
        }
    }

    private Node createNode() throws SAXException {
        Node node;
        if (this.type == null) {
            return null;
        }
        try {
            node = (Node)this.getRegistry().typeForName(this.type).newInstance();
        }
        catch (Exception exception) {
            throw Utils.newSAXException(exception);
        }
        if (this.value != null) {
            this.xmlReader.valueOf(node, this.value);
        }
        return node;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.data = -1;
        if (GRAPHML_NAMESPACE.equals(string)) {
            if ("node".equals(string2)) {
                Node node = this.createNode();
                if (node == null) {
                    node = new Node();
                }
                this.idToNode.put(this.nodeId, node);
                if (this.root == null) {
                    this.root = node;
                }
            } else if ("edge".equals(string2)) {
                Node node;
                Node node2 = this.createNode();
                Node node3 = (Node)this.idToNode.get(this.targetId);
                if (node3 != null && (node = (Node)this.idToNode.get(this.sourceId)) != null) {
                    if (node2 != null) {
                        node.addEdgeBitsTo(node2, 1, null);
                        node2.addEdgeBitsTo(node3, 128, null);
                    } else {
                        node.addEdgeBitsTo(node3, GraphMLReader.getBits(this.bits, node, node3), null);
                    }
                } else {
                    this.edges.push(this.sourceId).push(this.targetId).push((String)(node2 != null ? node2 : this.bits));
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2).trim();
        if (string.length() > 0) {
            switch (this.data) {
                case 0: {
                    this.bits = string;
                    break;
                }
                case 1: {
                    this.type = string;
                    break;
                }
                case 2: {
                    this.value = string;
                }
            }
        }
    }
}

