/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.OutputStreamSource;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GZipFilter
extends FilterBase
implements OutputStreamSource {
    public GZipFilter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setSystemId(filterSource.getSystemId() + ".gz");
        StringMap stringMap = new StringMap().putObject("wrapped-type", filterSource.getFlavor().getMimeType().toString());
        this.setFlavor(new IOFlavor(new MimeType(MimeType.GZIP.getMediaType(), stringMap), 2, null));
    }

    public void write(OutputStream outputStream) throws IOException {
        ((OutputStreamSource)this.source).write(new GZIPOutputStream(outputStream));
    }
}

