/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.BindingsCache;
import de.grogra.persistence.FatalPersistenceException;
import de.grogra.persistence.IndirectField;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.persistence.TransactionApplier;
import de.grogra.persistence.XAQueue;
import de.grogra.util.HierarchicalQueue;
import de.grogra.xl.util.ObjectList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Transaction
extends XAQueue {
    Thread thread;
    long id = -1L;
    private int activeCount = 0;
    private long userId = 0L;
    private int readOnlyBegin = -1;
    boolean readOnly = false;
    private boolean modified = false;
    private boolean applyXA = false;
    final TransactionApplier xaApplier;
    private final ObjectList<Object> modifiedFields = new ObjectList();
    public static final int SET_BOOLEAN = 1;
    public static final int INSERT_BOOLEAN = 2;
    public static final int REMOVE_BOOLEAN = 3;
    public static final int SET_BYTE = 4;
    public static final int INSERT_BYTE = 5;
    public static final int REMOVE_BYTE = 6;
    public static final int SET_SHORT = 7;
    public static final int INSERT_SHORT = 8;
    public static final int REMOVE_SHORT = 9;
    public static final int SET_CHAR = 10;
    public static final int INSERT_CHAR = 11;
    public static final int REMOVE_CHAR = 12;
    public static final int SET_INT = 13;
    public static final int INSERT_INT = 14;
    public static final int REMOVE_INT = 15;
    public static final int SET_LONG = 16;
    public static final int INSERT_LONG = 17;
    public static final int REMOVE_LONG = 18;
    public static final int SET_FLOAT = 19;
    public static final int INSERT_FLOAT = 20;
    public static final int REMOVE_FLOAT = 21;
    public static final int SET_DOUBLE = 22;
    public static final int INSERT_DOUBLE = 23;
    public static final int REMOVE_DOUBLE = 24;
    public static final int SET_OBJECT = 25;
    public static final int INSERT_OBJECT = 26;
    public static final int REMOVE_OBJECT = 27;
    public static final int UNDO_TRANSACTION = 28;
    public static final int MAKE_PERSISTENT = 29;
    public static final int MAKE_TRANSIENT = 30;
    public static final int READ_DATA = 31;
    public static final int MIN_UNUSED_ITEM = 32;
    private boolean writePrepared;
    private PersistenceCapable preparedPC = null;
    private PersistenceField preparedField = null;
    private int[] preparedIndices = null;
    private int[][] preparedIndicesPool = new int[16][];
    private final ObjectList refs = new ObjectList();

    protected Data createData() {
        return new Data(false, this.getKey(), this.manager.getConnection().getLocalCache());
    }

    protected boolean isLoggingSuppressed() {
        return false;
    }

    public void logSetBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, boolean bl, boolean bl2) {
        this.prepareLogSetBoolean(persistenceCapable, persistenceField, nArray, bl);
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeBoolean(bl2);
    }

    public void prepareLogSetBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, boolean bl) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(1);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeBoolean(bl);
    }

    public void logInsertBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, boolean bl) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(2);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeBoolean(bl);
    }

    public void logRemoveBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, boolean bl) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(3);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeBoolean(bl);
    }

    public void logSetByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by, byte by2) {
        this.prepareLogSetByte(persistenceCapable, persistenceField, nArray, by);
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeByte(by2);
    }

    public void prepareLogSetByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(4);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void logInsertByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(5);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void logRemoveByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(6);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void logSetShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s, short s2) {
        this.prepareLogSetShort(persistenceCapable, persistenceField, nArray, s);
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeShort(s2);
    }

    public void prepareLogSetShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(7);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void logInsertShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(8);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void logRemoveShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(9);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void logSetChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c, char c2) {
        this.prepareLogSetChar(persistenceCapable, persistenceField, nArray, c);
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeChar(c2);
    }

    public void prepareLogSetChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(10);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void logInsertChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(11);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void logRemoveChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(12);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void logSetInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n, int n2) {
        this.prepareLogSetInt(persistenceCapable, persistenceField, nArray, n);
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeInt(n2);
    }

    public void prepareLogSetInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(13);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void logInsertInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(14);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void logRemoveInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(15);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void logSetLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l, long l2) {
        this.prepareLogSetLong(persistenceCapable, persistenceField, nArray, l);
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeLong(l2);
    }

    public void prepareLogSetLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(16);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void logInsertLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(17);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void logRemoveLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(18);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void logSetFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, float f, float f2) {
        this.prepareLogSetFloat(persistenceCapable, persistenceField, nArray, f);
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeFloat(f2);
    }

    public void prepareLogSetFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, float f) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(19);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeFloat(f);
    }

    public void logInsertFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, float f) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(20);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeFloat(f);
    }

    public void logRemoveFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, float f) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(21);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeFloat(f);
    }

    public void logSetDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, double d, double d2) {
        this.prepareLogSetDouble(persistenceCapable, persistenceField, nArray, d);
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeDouble(d2);
    }

    public void prepareLogSetDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, double d) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(22);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeDouble(d);
    }

    public void logInsertDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, double d) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(23);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeDouble(d);
    }

    public void logRemoveDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, double d) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(24);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeDouble(d);
    }

    public void logSetObject(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Object object, Object object2) {
        this.prepareLogSetObject(persistenceCapable, persistenceField, nArray, object);
        if (this.isLoggingSuppressed()) {
            return;
        }
        try {
            persistenceField.writeObject(object2, this);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
    }

    public void prepareLogSetObject(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Object object) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(25);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        try {
            persistenceField.writeObject(object, this);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
    }

    public void logInsertObject(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Object object) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(26);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        try {
            persistenceField.writeObject(object, this);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
    }

    public void logRemoveObject(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Object object) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(27);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        try {
            persistenceField.writeObject(object, this);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
    }

    public void logUndo(Key key) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(28);
        this.writeShort(key.getManagerId());
        this.writeLong(key.getXAId());
    }

    public void logMakePersistent(PersistenceCapable persistenceCapable) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(29);
        this.writeLong(persistenceCapable.getId());
        this.writeType(persistenceCapable.getManageableType());
    }

    public void logMakeTransient(PersistenceCapable persistenceCapable) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(30);
        this.writeLong(persistenceCapable.getId());
        this.writeType(persistenceCapable.getManageableType());
    }

    public void logReadData(PersistenceCapable persistenceCapable, boolean bl) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(31);
        this.writeLong(persistenceCapable.getId());
        this.writeBoolean(bl);
        boolean bl2 = this.beginManaged(persistenceCapable.getManageableType(), true);
        try {
            persistenceCapable.getManageableType().write(persistenceCapable, this, bl2);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
        this.endManaged(persistenceCapable, true);
    }

    protected Transaction(PersistenceManager persistenceManager, Thread thread) {
        super(persistenceManager, true);
        this.thread = thread;
        this.xaApplier = persistenceManager.createXAApplier();
        this.xaApplier.transaction = this;
        this.setItemSize(1, 2, -1, 1, 0, 0, 0);
        this.setItemSize(4, 2, -1, 1, 0, 0, 0);
        this.setItemSize(7, 4, -1, 1, 0, 0, 0);
        this.setItemSize(10, 4, -1, 1, 0, 0, 0);
        this.setItemSize(13, 0, -1, 1, 0, 0, 0);
        this.setItemSize(16, 0, -1, 3, 0, 0, 0);
        this.setItemSize(19, 0, -1, 1, 2, 0, 0);
        this.setItemSize(22, 0, -1, 1, 0, 2, 0);
        this.setItemSize(25, -1, -1, -1, -1, -1, 0);
        this.setItemSize(2, 1, -1, 1, 0, 0, 0);
        this.setItemSize(5, 1, -1, 1, 0, 0, 0);
        this.setItemSize(8, 2, -1, 1, 0, 0, 0);
        this.setItemSize(11, 2, -1, 1, 0, 0, 0);
        this.setItemSize(14, 0, -1, 1, 0, 0, 0);
        this.setItemSize(17, 0, -1, 2, 0, 0, 0);
        this.setItemSize(20, 0, -1, 1, 1, 0, 0);
        this.setItemSize(23, 0, -1, 1, 0, 1, 0);
        this.setItemSize(26, -1, -1, -1, -1, -1, 0);
        this.setItemSize(3, 1, -1, 1, 0, 0, 0);
        this.setItemSize(6, 1, -1, 1, 0, 0, 0);
        this.setItemSize(9, 2, -1, 1, 0, 0, 0);
        this.setItemSize(12, 2, -1, 1, 0, 0, 0);
        this.setItemSize(15, 0, -1, 1, 0, 0, 0);
        this.setItemSize(18, 0, -1, 2, 0, 0, 0);
        this.setItemSize(21, 0, -1, 1, 1, 0, 0);
        this.setItemSize(24, 0, -1, 1, 0, 1, 0);
        this.setItemSize(27, -1, -1, -1, -1, -1, 0);
        this.setItemSize(28, 2, 0, 1, 0, 0, 0);
        this.setItemSize(29, 0, 1, 1, 0, 0, 0);
        this.setItemSize(30, 0, 1, 1, 0, 0, 0);
        this.setItemSize(31, -1, -1, -1, -1, -1, 0);
    }

    public final void setReadOnly() {
        assert (this.activeCount == 0);
        this.readOnlyBegin = -1;
        this.readOnly = true;
    }

    public final long getUserId() {
        return this.userId;
    }

    public final void setUserId(long l) {
        this.userId = l;
    }

    public abstract Reader createReader();

    protected void setModified() {
        if (this.activeCount == 0) {
            throw new IllegalStateException("Transaction not active");
        }
        if (this.readOnly) {
            throw new IllegalStateException("Transaction is read-only");
        }
        this.modified = true;
    }

    public boolean hasModified() {
        return this.modified;
    }

    public void begin(boolean bl) {
        if (this.manager.checkLock && !this.manager.isLocked(!bl)) {
            throw new IllegalStateException(this.manager + " is not locked");
        }
        if (bl && !this.readOnly) {
            this.readOnly = true;
            this.readOnlyBegin = this.activeCount;
        }
        if (this.activeCount++ == 0) {
            this.modified = false;
            this.manager.beginTransaction(this);
        }
        if (!this.readOnly) {
            this.beginLevel();
        }
    }

    public void commit() {
        boolean bl;
        boolean bl2 = bl = !this.readOnly;
        if (this.activeCount == 1) {
            this.manager.prepareCompletion(this, bl);
        }
        if (bl) {
            this.endLevel();
        }
        if (--this.activeCount == this.readOnlyBegin) {
            this.readOnly = false;
            this.readOnlyBegin = -1;
        }
        if (this.activeCount == 0) {
            this.manager.completeTransaction(this, bl);
            this.clear();
        }
    }

    public void rollback() {
        try {
            if (!this.readOnly) {
                if (this.hasItemsInCurrentLevel()) {
                    Reader reader = this.createReader();
                    reader.moveToCurrent();
                    this.beginApply();
                    reader.supplyInverse(this.xaApplier);
                }
                this.discardLevel();
            }
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
        finally {
            if (--this.activeCount == 0) {
                this.manager.completeTransaction(this, false);
                this.clear();
            }
            if (this.activeCount == this.readOnlyBegin) {
                this.readOnly = false;
                this.readOnlyBegin = -1;
            }
            this.endApply();
        }
    }

    public final void commitAll() {
        while (this.activeCount > 0) {
            this.commit();
        }
    }

    public final void rollbackAll() {
        while (this.activeCount > 0) {
            this.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void undo(Data data) throws IOException {
        Data data2 = (Data)this.getData();
        Reader reader = this.createReader();
        try {
            this.beginApply();
            this.restore(data);
            reader.supplyInverse(this.xaApplier);
        }
        finally {
            this.restore(data2);
            this.endApply();
        }
        this.logUndo(data.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.commitAll();
        Object object = this.manager.xaLock;
        synchronized (object) {
            this.remove(this.manager.transactions);
        }
    }

    public boolean isActive() {
        return this.activeCount > 0;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public final long getId() {
        return this.id;
    }

    public final Key getKey() {
        return new Key(this.manager.getId(), this.id, this.userId);
    }

    public static boolean isApplying(Transaction transaction) {
        return transaction != null && transaction.applyXA;
    }

    public static boolean isNotApplying(Transaction transaction) {
        return transaction != null && !transaction.applyXA;
    }

    public void beginApply() {
        this.applyXA = true;
    }

    public void endApply() {
        this.applyXA = false;
    }

    final Transaction[] add(Transaction[] transactionArray) {
        int n = transactionArray.length;
        for (int i = 0; i < n - 1; ++i) {
            if (transactionArray[i] != null) continue;
            transactionArray[i] = this;
            return transactionArray;
        }
        Transaction[] transactionArray2 = new Transaction[n * 2];
        System.arraycopy(transactionArray, 0, transactionArray2, 0, n);
        transactionArray2[n - 1] = this;
        return transactionArray2;
    }

    final void remove(Transaction[] transactionArray) {
        int n = transactionArray.length;
        for (int i = 0; i < n; ++i) {
            if (transactionArray[i] != this) continue;
            System.arraycopy(transactionArray, i + 1, transactionArray, i, n - i - 1);
            return;
        }
    }

    public void restore(HierarchicalQueue.Data data) {
        this.id = ((Data)data).getKey().getXAId();
        this.cache = ((Data)data).cache;
        super.restore(data);
    }

    public void prepareSetBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetBoolean(persistenceCapable, persistenceField, nArray, persistenceField.getBoolean(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void prepareSetByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetByte(persistenceCapable, persistenceField, nArray, persistenceField.getByte(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void prepareSetShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetShort(persistenceCapable, persistenceField, nArray, persistenceField.getShort(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void prepareSetChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetChar(persistenceCapable, persistenceField, nArray, persistenceField.getChar(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void prepareSetInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetInt(persistenceCapable, persistenceField, nArray, persistenceField.getInt(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void prepareSetLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetLong(persistenceCapable, persistenceField, nArray, persistenceField.getLong(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void prepareSetFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetFloat(persistenceCapable, persistenceField, nArray, persistenceField.getFloat(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void prepareSetDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetDouble(persistenceCapable, persistenceField, nArray, persistenceField.getDouble(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void prepareSetObject(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray) {
        int n;
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null && !this.applyXA) {
            this.writePrepared = true;
            this.prepareLogSetObject(persistenceCapable, persistenceField, nArray, persistenceField.getObject(persistenceCapable, nArray));
        } else {
            this.writePrepared = false;
        }
        this.preparedPC = persistenceCapable;
        this.preparedField = persistenceField;
        if (nArray == null || (n = nArray.length) == 0) {
            this.preparedIndices = null;
        } else {
            int[] nArray2;
            Object object = this.preparedIndicesPool;
            if (n >= ((int[][])object).length) {
                int[][] nArrayArray = new int[n + 1][];
                object = nArrayArray;
                this.preparedIndicesPool = nArrayArray;
            }
            if ((nArray2 = object[n]) == null) {
                object[n] = new int[n];
                nArray2 = object[n];
            }
            while (--n >= 0) {
                nArray2[n] = nArray[n];
            }
            this.preparedIndices = nArray2;
        }
    }

    public void finishSet() {
        if (this.writePrepared && !this.isLoggingSuppressed()) {
            switch (this.preparedField.typeId) {
                case 2: {
                    this.writeBoolean(this.preparedField.getBoolean(this.preparedPC, this.preparedIndices));
                    break;
                }
                case 3: {
                    this.writeByte(this.preparedField.getByte(this.preparedPC, this.preparedIndices));
                    break;
                }
                case 4: {
                    this.writeShort(this.preparedField.getShort(this.preparedPC, this.preparedIndices));
                    break;
                }
                case 5: {
                    this.writeChar(this.preparedField.getChar(this.preparedPC, this.preparedIndices));
                    break;
                }
                case 6: {
                    this.writeInt(this.preparedField.getInt(this.preparedPC, this.preparedIndices));
                    break;
                }
                case 7: {
                    this.writeLong(this.preparedField.getLong(this.preparedPC, this.preparedIndices));
                    break;
                }
                case 8: {
                    this.writeFloat(this.preparedField.getFloat(this.preparedPC, this.preparedIndices));
                    break;
                }
                case 9: {
                    this.writeDouble(this.preparedField.getDouble(this.preparedPC, this.preparedIndices));
                    break;
                }
                case 0: {
                    try {
                        this.preparedField.writeObject(this.preparedField.getObject(this.preparedPC, this.preparedIndices), this);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new FatalPersistenceException(iOException);
                    }
                }
            }
        }
        this.preparedPC.fieldModified(this.preparedField, this.preparedIndices, this);
        this.preparedPC = null;
        this.preparedField = null;
    }

    public void finishSet(XAQueue.Reader reader) {
        switch (this.preparedField.typeId) {
            case 2: {
                boolean bl = this.preparedField.readAndSetBoolean(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                this.writeBoolean(bl);
                break;
            }
            case 3: {
                byte by = this.preparedField.readAndSetByte(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                this.writeByte(by);
                break;
            }
            case 4: {
                short s = this.preparedField.readAndSetShort(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                this.writeShort(s);
                break;
            }
            case 5: {
                char c = this.preparedField.readAndSetChar(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                this.writeChar(c);
                break;
            }
            case 6: {
                int n = this.preparedField.readAndSetInt(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                this.writeInt(n);
                break;
            }
            case 7: {
                long l = this.preparedField.readAndSetLong(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                this.writeLong(l);
                break;
            }
            case 8: {
                float f = this.preparedField.readAndSetFloat(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                this.writeFloat(f);
                break;
            }
            case 9: {
                double d = this.preparedField.readAndSetDouble(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                this.writeDouble(d);
                break;
            }
            case 0: {
                Object object = this.preparedField.readAndSetObject(this.preparedPC, this.preparedIndices, reader);
                if (!this.writePrepared || this.isLoggingSuppressed()) break;
                try {
                    this.preparedField.writeObject(object, this);
                    break;
                }
                catch (IOException iOException) {
                    throw new FatalPersistenceException(iOException);
                }
            }
        }
        this.preparedPC.fieldModified(this.preparedField, this.preparedIndices, this);
        this.preparedPC = null;
        this.preparedField = null;
    }

    public Transaction makeActive() {
        if (!this.isActive()) {
            this.begin(false);
        }
        return this;
    }

    public void fireSharedObjectModified(Shareable shareable) {
        int n = this.refs.size();
        shareable.appendReferencesTo(this.refs);
        while (this.refs.size() > n) {
            ((SharedObjectReference)this.refs.pop()).sharedObjectModified(shareable, this);
        }
    }

    public void markModified(Object object, PersistenceField persistenceField, int[] nArray) {
        this.modifiedFields.push(object, persistenceField, nArray);
    }

    public void unmarkModified() {
        this.modifiedFields.setSize(this.modifiedFields.size() - 3);
    }

    public boolean isModified(Object object, PersistenceField persistenceField, int[] nArray) {
        for (int i = this.modifiedFields.size() - 3; i >= 0; i -= 3) {
            if (object != this.modifiedFields.get(i) || !persistenceField.overlaps(nArray, (PersistenceField)this.modifiedFields.get(i + 1), (int[])this.modifiedFields.get(i + 2))) continue;
            return true;
        }
        return false;
    }

    public class Reader
    extends XAQueue.Reader {
        protected final IndirectField indirectField;

        public Reader() {
            super(Transaction.this);
            this.indirectField = new IndirectField();
        }

        public Transaction getTransaction() {
            return Transaction.this;
        }

        public final boolean skipAndReadBoolean() throws IOException {
            this.skipBoolean();
            return this.readBoolean();
        }

        public final byte skipAndReadByte() throws IOException {
            this.skipByte();
            return this.readByte();
        }

        public final short skipAndReadShort() throws IOException {
            this.skipShort();
            return this.readShort();
        }

        public final char skipAndReadChar() throws IOException {
            this.skipChar();
            return this.readChar();
        }

        public final int skipAndReadInt() throws IOException {
            this.skipInt();
            return this.readInt();
        }

        public final long skipAndReadLong() throws IOException {
            this.skipLong();
            return this.readLong();
        }

        public final float skipAndReadFloat() throws IOException {
            this.skipFloat();
            return this.readFloat();
        }

        public final double skipAndReadDouble() throws IOException {
            this.skipDouble();
            return this.readDouble();
        }

        protected void supply(int n, Consumer consumer) throws IOException {
            switch (n & 0xFFF) {
                case 0: {
                    this.enter(false);
                    this.supplyImpl(consumer);
                    this.leave();
                    break;
                }
                case 1: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipBoolean();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 4: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipByte();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 7: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipShort();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 10: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipChar();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 13: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipInt();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 16: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipLong();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 19: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipFloat();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 22: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipDouble();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 25: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, nArray, this, false);
                        break;
                    }
                    this.skipObject();
                    consumer.setField(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 11: 
                case 14: 
                case 17: 
                case 20: 
                case 23: 
                case 26: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    consumer.insertComponent(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 12: 
                case 15: 
                case 18: 
                case 21: 
                case 24: 
                case 27: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    consumer.removeComponent(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 28: {
                    Data data = (Data)Transaction.this.getData();
                    this.pushCursor();
                    Transaction.this.restore(Transaction.this.manager.getTransactionData(Key.read(this)));
                    this.supplyInverse(this.resetCursor(), consumer);
                    Transaction.this.restore(data);
                    this.popCursor();
                    break;
                }
                case 29: {
                    consumer.makePersistent(this.readLong(), this.readType());
                    break;
                }
                case 30: {
                    consumer.makeTransient(Transaction.this.manager.getObject(this.readLong()), this.readType());
                    break;
                }
                case 31: {
                    long l = this.readLong();
                    if (this.readBoolean()) break;
                    consumer.readData(Transaction.this.manager.getObject(l), this);
                }
            }
        }

        protected void supplyInverse(int n, Consumer consumer) throws IOException {
            switch (n & 0xFFF) {
                case 0: {
                    this.enter(true);
                    this.supplyInverseImpl(consumer);
                    this.leave();
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    if (consumer instanceof ExtendedConsumer) {
                        ((ExtendedConsumer)consumer).setField(persistenceCapable, this.indirectField, this.indirectField.read(persistenceCapable, this), this, true);
                        break;
                    }
                    consumer.setField(persistenceCapable, this.indirectField, this.indirectField.read(persistenceCapable, this), this);
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 11: 
                case 14: 
                case 17: 
                case 20: 
                case 23: 
                case 26: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    consumer.removeComponent(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 12: 
                case 15: 
                case 18: 
                case 21: 
                case 24: 
                case 27: {
                    PersistenceCapable persistenceCapable = Transaction.this.manager.getObject(this.readLong());
                    int[] nArray = this.indirectField.read(persistenceCapable, this);
                    consumer.insertComponent(persistenceCapable, this.indirectField, nArray, this);
                    break;
                }
                case 28: {
                    Data data = (Data)Transaction.this.getData();
                    this.pushCursor();
                    Transaction.this.restore(Transaction.this.manager.getTransactionData(Key.read(this)));
                    this.supply(this.resetCursor(), consumer);
                    Transaction.this.restore(data);
                    this.popCursor();
                    break;
                }
                case 29: {
                    consumer.makeTransient(Transaction.this.manager.getObject(this.readLong()), this.readType());
                    break;
                }
                case 30: {
                    consumer.makePersistent(this.readLong(), this.readType());
                    break;
                }
                case 31: {
                    long l = this.readLong();
                    if (!this.readBoolean()) break;
                    consumer.readData(Transaction.this.manager.getObject(l), this);
                }
            }
        }

        private void supplyImpl(Consumer consumer) throws IOException {
            int n = this.readItem();
            while (n >= 0) {
                this.supply(n, consumer);
                n = this.next();
            }
        }

        private void supplyInverseImpl(Consumer consumer) throws IOException {
            int n = this.readItem();
            while (n >= 0) {
                this.supplyInverse(n, consumer);
                n = this.previous();
            }
        }

        public final void supply(Consumer consumer) throws IOException {
            consumer.begin();
            this.supplyImpl(consumer);
            consumer.end();
        }

        public final void supplyInverse(Consumer consumer) throws IOException {
            consumer.begin();
            this.supplyInverseImpl(consumer);
            consumer.end();
        }
    }

    public static interface ExtendedConsumer
    extends Consumer {
        public void setField(PersistenceCapable var1, PersistenceField var2, int[] var3, Reader var4, boolean var5);
    }

    public static interface Consumer {
        public void setField(PersistenceCapable var1, PersistenceField var2, int[] var3, Reader var4);

        public void insertComponent(PersistenceCapable var1, PersistenceField var2, int[] var3, Reader var4);

        public void removeComponent(PersistenceCapable var1, PersistenceField var2, int[] var3, Reader var4);

        public void makePersistent(long var1, ManageableType var3);

        public void makeTransient(PersistenceCapable var1, ManageableType var2);

        public void readData(PersistenceCapable var1, Reader var2);

        public void begin();

        public void end();

        public static class Multicaster
        implements Consumer {
            private ObjectList consumers = new ObjectList(10, false);
            private volatile boolean dirty = true;
            private ObjectList consumersCopy = new ObjectList(10);

            public synchronized void addConsumer(Object object) {
                this.consumers.addIfNotContained(object);
                this.dirty = true;
            }

            public synchronized void removeConsumer(Object object) {
                this.consumers.remove(object);
                this.dirty = true;
            }

            public synchronized void removeAllConsumers() {
                this.consumers.clear();
                this.dirty = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected ObjectList getConsumers() {
                if (this.dirty) {
                    this.consumersCopy.clear();
                    Multicaster multicaster = this;
                    synchronized (multicaster) {
                        this.consumersCopy.addAll(this.consumers);
                        this.dirty = false;
                    }
                }
                return this.consumersCopy;
            }

            public void setField(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Reader reader) {
                ObjectList objectList = this.getConsumers();
                int n = objectList.size();
                for (int i = 0; i < n; ++i) {
                    Object e = objectList.get(i);
                    if (!(e instanceof Consumer)) continue;
                    reader.pushCursor();
                    ((Consumer)e).setField(persistenceCapable, persistenceField, nArray, reader);
                    reader.popCursor();
                }
            }

            public void insertComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Reader reader) {
                ObjectList objectList = this.getConsumers();
                int n = objectList.size();
                for (int i = 0; i < n; ++i) {
                    Object e = objectList.get(i);
                    if (!(e instanceof Consumer)) continue;
                    reader.pushCursor();
                    ((Consumer)e).insertComponent(persistenceCapable, persistenceField, nArray, reader);
                    reader.popCursor();
                }
            }

            public void removeComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Reader reader) {
                ObjectList objectList = this.getConsumers();
                int n = objectList.size();
                for (int i = 0; i < n; ++i) {
                    Object e = objectList.get(i);
                    if (!(e instanceof Consumer)) continue;
                    reader.pushCursor();
                    ((Consumer)e).removeComponent(persistenceCapable, persistenceField, nArray, reader);
                    reader.popCursor();
                }
            }

            public void makePersistent(long l, ManageableType manageableType) {
                ObjectList objectList = this.getConsumers();
                int n = objectList.size();
                for (int i = 0; i < n; ++i) {
                    Object e = objectList.get(i);
                    if (!(e instanceof Consumer)) continue;
                    ((Consumer)e).makePersistent(l, manageableType);
                }
            }

            public void makeTransient(PersistenceCapable persistenceCapable, ManageableType manageableType) {
                ObjectList objectList = this.getConsumers();
                int n = objectList.size();
                for (int i = 0; i < n; ++i) {
                    Object e = objectList.get(i);
                    if (!(e instanceof Consumer)) continue;
                    ((Consumer)e).makeTransient(persistenceCapable, manageableType);
                }
            }

            public void readData(PersistenceCapable persistenceCapable, Reader reader) {
                ObjectList objectList = this.getConsumers();
                int n = objectList.size();
                for (int i = 0; i < n; ++i) {
                    Object e = objectList.get(i);
                    if (!(e instanceof Consumer)) continue;
                    reader.pushCursor();
                    ((Consumer)e).readData(persistenceCapable, reader);
                    reader.popCursor();
                }
            }

            public void begin() {
                ObjectList objectList = this.getConsumers();
                int n = objectList.size();
                for (int i = 0; i < n; ++i) {
                    Object e = this.consumers.get(i);
                    if (!(e instanceof Consumer)) continue;
                    ((Consumer)e).begin();
                }
            }

            public void end() {
                ObjectList objectList = this.getConsumers();
                int n = objectList.size();
                for (int i = 0; i < n; ++i) {
                    Object e = this.consumers.get(i);
                    if (!(e instanceof Consumer)) continue;
                    ((Consumer)e).end();
                }
            }
        }

        public static class Adapter
        implements Consumer {
            public void setField(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Reader reader) {
            }

            public void insertComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Reader reader) {
            }

            public void removeComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Reader reader) {
            }

            public void makePersistent(long l, ManageableType manageableType) {
            }

            public void makeTransient(PersistenceCapable persistenceCapable, ManageableType manageableType) {
            }

            public void readData(PersistenceCapable persistenceCapable, Reader reader) {
            }

            public void begin() {
            }

            public void end() {
            }
        }
    }

    public static final class Data
    extends XAQueue.Data {
        final Key key;
        final BindingsCache cache;

        public Data(boolean bl, Key key, BindingsCache bindingsCache) {
            super(bl);
            this.key = key;
            this.cache = bindingsCache;
        }

        public Key getKey() {
            return this.key;
        }

        public boolean hasUserId(PersistenceManager persistenceManager, long l) {
            return this.key.hasUserId(persistenceManager, l);
        }

        public long getUserId() {
            return this.key.getUserId();
        }
    }

    public static final class Key {
        private final short mid;
        private final long xid;
        private final long userId;

        Key(short s, long l, long l2) {
            this.mid = s;
            this.xid = l;
            this.userId = l2;
        }

        Key(short s, long l) {
            this(s, l, 0L);
        }

        public boolean equals(short s, long l) {
            return this.mid == s && this.xid == l;
        }

        public boolean equals(Object object) {
            return object instanceof Key && ((Key)object).mid == this.mid && ((Key)object).xid == this.xid;
        }

        public int hashCode() {
            return this.mid ^ (int)this.xid;
        }

        public boolean hasUserId(PersistenceManager persistenceManager, long l) {
            return this.mid == persistenceManager.getId() && this.userId == l;
        }

        public short getManagerId() {
            return this.mid;
        }

        public long getUserId() {
            return this.userId;
        }

        public long getXAId() {
            return this.xid;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.mid);
            dataOutput.writeLong(this.xid);
        }

        public static Key read(DataInput dataInput) throws IOException {
            return new Key(dataInput.readShort(), dataInput.readLong());
        }

        public String toString() {
            return "Transaction.Key[manager=" + this.mid + ", xa=" + this.xid + ", user=" + this.userId + ']';
        }
    }
}

