/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.FatalPersistenceException;
import de.grogra.persistence.LogStore;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceConnection;
import de.grogra.persistence.PersistenceException;
import de.grogra.persistence.PersistenceInputStream;
import de.grogra.persistence.PersistenceOutputStream;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.TransactionApplier;
import de.grogra.persistence.UserPersistenceException;
import de.grogra.persistence.XAListener;
import de.grogra.util.HierarchicalQueue;
import de.grogra.util.LockableImpl;
import de.grogra.util.ThreadContext;
import de.grogra.xl.util.IntHashMap;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceManager
extends LockableImpl {
    private LogStore sentLog = new LogStore(true);
    private LogStore localLog = new LogStore(false);
    private LogStore log = new LogStore(false);
    private long xaStamp = -1L;
    private volatile int modificationStamp = 0;
    private ObjectList<PendingEnd> pendingEnds = new ObjectList();
    private static final int RUNNING = 0;
    private static final int WAITING_FOR_XA_END_0 = 1;
    private static final int WAITING_FOR_XA_END = 2;
    private static final int WAITING_FOR_DEREGISTER = 3;
    private static final int CLOSED = 4;
    private transient int state = 0;
    private int pendingChecked = 0;
    private LogStore.Entry pendingSentLogEntry = null;
    private boolean fetchNewSentLogEntry = true;
    private final IntHashMap<Transaction.Reader> readers = new IntHashMap();
    private Runnable xaNotifier;
    final short id;
    private long nextId;
    Transaction[] transactions = new Transaction[32];
    final Object xaLock = new Object();
    long nextXAId = 0L;
    final PersistenceConnection connection;
    int activeTransactions = 0;
    final boolean checkLock;
    private final ObjectList<XAListener> listeners = new ObjectList(10, false);
    protected final Object makeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(int n, long l, Transaction.Data data) {
        ObjectList<PendingEnd> objectList = this.pendingEnds;
        synchronized (objectList) {
            this.pendingEnds.add(new PendingEnd(n, l, data));
            this.pendingEnds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingEnds(Transaction transaction) {
        assert (Thread.holdsLock(this.pendingEnds));
        if (this.fetchNewSentLogEntry) {
            this.pendingSentLogEntry = this.sentLog.getFirstEntry();
            if (this.pendingSentLogEntry != null) {
                this.fetchNewSentLogEntry = false;
            }
        }
        if (!this.pendingEnds.isEmpty()) {
            Object object;
            Object object2;
            if (this.pendingSentLogEntry != null) {
                while (this.pendingChecked < this.pendingEnds.size()) {
                    object2 = this.pendingEnds.get(this.pendingChecked++);
                    switch (((PendingEnd)object2).type) {
                        case 1: 
                        case 2: {
                            object = this.pendingSentLogEntry.getKey();
                            if (!((Transaction.Key)object).equals(((PendingEnd)object2).xa.key)) {
                                throw new FatalPersistenceException("Unexpected order of commitment");
                            }
                            this.pendingSentLogEntry = this.pendingSentLogEntry.getNext();
                        }
                    }
                }
            }
            if (this.activeTransactions == 0 && this.pendingSentLogEntry == null) {
                object2 = ThreadContext.current();
                try {
                    int n;
                    transaction.beginApply();
                    object = this.readers.get(((ThreadContext)object2).getId());
                    if (object == null) {
                        object = this.createTransaction(((ThreadContext)object2).getThread()).createReader();
                        this.readers.put(((ThreadContext)object2).getId(), (Transaction.Reader)object);
                    }
                    Transaction transaction2 = ((Transaction.Reader)object).getTransaction();
                    PendingEnd pendingEnd = null;
                    for (n = this.pendingEnds.size() - 1; n >= 0; --n) {
                        pendingEnd = this.pendingEnds.get(n);
                        if (pendingEnd.type != 1) continue;
                        transaction2.restore(pendingEnd.xa);
                        ((HierarchicalQueue.Reader)object).resetCursor();
                        ((Transaction.Reader)object).supplyInverse(transaction.xaApplier);
                        this.transactionApplied(pendingEnd.xa, true, transaction);
                    }
                    block14: for (n = 0; n < this.pendingEnds.size(); ++n) {
                        pendingEnd = this.pendingEnds.get(n);
                        switch (pendingEnd.type) {
                            case 2: {
                                this.localLog.add(pendingEnd.xa.key, pendingEnd.xa);
                                this.log.add(pendingEnd.xa.key, pendingEnd.xa);
                                continue block14;
                            }
                            case 0: {
                                transaction2.restore(pendingEnd.xa);
                                ((HierarchicalQueue.Reader)object).resetCursor();
                                ((Transaction.Reader)object).supply(transaction.xaApplier);
                                this.transactionApplied(pendingEnd.xa, false, transaction);
                                this.log.add(pendingEnd.xa.key, pendingEnd.xa);
                            }
                        }
                    }
                    this.xaStamp = pendingEnd.stamp;
                    this.pendingChecked = 0;
                    this.fetchNewSentLogEntry = true;
                    this.pendingSentLogEntry = null;
                    this.sentLog.clear();
                    this.pendingEnds.clear();
                    this.pendingEnds.notifyAll();
                }
                catch (IOException iOException) {
                    this.exceptionThrown(iOException);
                }
                finally {
                    transaction.endApply();
                }
            }
        }
    }

    public PersistenceManager(PersistenceConnection persistenceConnection, String string, boolean bl) {
        this.connection = persistenceConnection;
        this.checkLock = bl;
        this.id = persistenceConnection.registerManager(this, string);
        this.nextId = (long)this.id << 48;
    }

    public void initNonlocalTransactionNotifier(Runnable runnable) {
        this.xaNotifier = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ObjectList<PendingEnd> objectList = this.xaLock;
        synchronized (objectList) {
            this.state = 1;
        }
        objectList = this.pendingEnds;
        synchronized (objectList) {
            this.state = 2;
            while (this.activeTransactions > 0) {
                try {
                    this.pendingEnds.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.state = 3;
        }
        this.connection.deregisterManager(this);
        objectList = this.pendingEnds;
        synchronized (objectList) {
            this.state = 4;
            this.pendingEnds.notifyAll();
        }
    }

    void exceptionThrown(Throwable throwable) {
        throwable.printStackTrace();
    }

    protected abstract TransactionApplier createXAApplier();

    protected abstract Transaction createTransaction(Thread var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getTransactions(List<? super Transaction> list) {
        list.clear();
        int n = 0;
        Object object = this.xaLock;
        synchronized (object) {
            Transaction transaction;
            while ((transaction = this.transactions[n++]) != null) {
                list.add(transaction);
            }
        }
    }

    public final Transaction getActiveTransaction() {
        Transaction transaction = this.getTransaction(true);
        if (!transaction.isActive()) {
            transaction.begin(false);
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Transaction getTransaction(boolean bl) {
        Thread thread = Thread.currentThread();
        int n = 0;
        Object object = this.xaLock;
        synchronized (object) {
            Transaction transaction;
            while ((transaction = this.transactions[n++]) != null) {
                if (transaction.thread != thread) continue;
                return transaction;
            }
            if (bl) {
                if (this.state != 0) {
                    throw new PersistenceException("Already closing");
                }
                transaction = this.createTransaction(thread);
                this.transactions = transaction.add(this.transactions);
                return transaction;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginTransaction(Transaction transaction) {
        ObjectList<PendingEnd> objectList = this.pendingEnds;
        synchronized (objectList) {
            long l;
            this.processPendingEnds(transaction);
            while (!this.pendingEnds.isEmpty()) {
                try {
                    this.pendingEnds.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.processPendingEnds(transaction);
            }
            if (this.state >= 2) {
                throw new PersistenceException("Already closing");
            }
            ++this.activeTransactions;
            if (transaction.readOnly) {
                l = 0L;
            } else {
                long l2 = this.nextXAId;
                l = l2;
                this.nextXAId = l2 + 1L;
            }
            transaction.id = l;
        }
    }

    protected void prepareCompletion(Transaction transaction, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeTransaction(Transaction transaction, boolean bl) {
        Transaction.Data data = null;
        ObjectList<PendingEnd> objectList = this.pendingEnds;
        synchronized (objectList) {
            --this.activeTransactions;
            if (bl && transaction.hasModified()) {
                data = (Transaction.Data)transaction.cloneData();
                this.sentLog.add(data.key, data);
                this.connection.commit(data, this.xaStamp);
            }
            this.processPendingEnds(transaction);
            this.pendingEnds.notifyAll();
        }
        if (data != null) {
            this.transactionApplied(data, false, transaction);
        }
    }

    public final void transactionCommitted(Transaction.Data data, long l) {
        this.enqueue(0, l, data);
        if (this.xaNotifier != null) {
            this.xaNotifier.run();
        }
    }

    public final void localTransactionCommitted(Transaction.Key key, long l) {
        this.enqueue(2, l, this.sentLog.get(key));
    }

    public final void localTransactionRolledBack(Transaction.Key key, long l) {
        this.enqueue(1, l, this.sentLog.get(key));
    }

    public final Transaction.Data getTransactionData(Transaction.Key key) {
        return this.log.get(key);
    }

    public final LogStore getLog() {
        return this.log;
    }

    public final PersistenceConnection getConnection() {
        return this.connection;
    }

    public final PersistenceBindings getBindings() {
        return this.connection.getBindings();
    }

    public final short getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addXAListener(XAListener xAListener) {
        ObjectList<XAListener> objectList = this.listeners;
        synchronized (objectList) {
            this.listeners.addIfNotContained(xAListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeXAListener(XAListener xAListener) {
        ObjectList<XAListener> objectList = this.listeners;
        synchronized (objectList) {
            this.listeners.remove(xAListener);
        }
    }

    public int getStamp() {
        return this.modificationStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transactionApplied(Transaction.Data data, boolean bl, Transaction transaction) {
        int n;
        ++this.modificationStamp;
        XAListener xAListener = null;
        XAListener xAListener2 = null;
        XAListener xAListener3 = null;
        XAListener xAListener4 = null;
        XAListener[] xAListenerArray = null;
        ObjectList<XAListener> objectList = this.listeners;
        synchronized (objectList) {
            n = this.listeners.size();
            Object[] objectArray = this.listeners.elements;
            switch (n) {
                default: {
                    xAListenerArray = new XAListener[n - 4];
                    System.arraycopy(objectArray, 4, xAListenerArray, 0, n - 4);
                }
                case 4: {
                    xAListener4 = (XAListener)objectArray[3];
                }
                case 3: {
                    xAListener3 = (XAListener)objectArray[2];
                }
                case 2: {
                    xAListener2 = (XAListener)objectArray[1];
                }
                case 1: {
                    xAListener = (XAListener)objectArray[0];
                }
                case 0: 
            }
        }
        if (xAListener != null) {
            xAListener.transactionApplied(data, bl);
            if (xAListener2 != null) {
                xAListener2.transactionApplied(data, bl);
                if (xAListener3 != null) {
                    xAListener3.transactionApplied(data, bl);
                    if (xAListener4 != null) {
                        xAListener4.transactionApplied(data, bl);
                        if (xAListenerArray != null) {
                            for (int i = 0; i < n - 4; ++i) {
                                xAListenerArray[i].transactionApplied(data, bl);
                            }
                        }
                    }
                }
            }
        }
    }

    public final void makePersistent(Object object, Transaction transaction) {
        block6: {
            block7: {
                block5: {
                    if (!(object instanceof PersistenceCapable)) break block5;
                    this.makePersistent((PersistenceCapable)object, -1L, transaction);
                    break block6;
                }
                if (!(object instanceof Object[])) break block7;
                Object[] objectArray = (Object[])object;
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    this.makePersistent(objectArray[i], transaction);
                }
                break block6;
            }
            if (!(object instanceof List)) break block6;
            List list = (List)object;
            if (object instanceof RandomAccess) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    this.makePersistent(list.get(i), transaction);
                }
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.makePersistent(iterator.next(), transaction);
                }
            }
        }
    }

    public abstract long prepareId(PersistenceCapable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void makePersistent(PersistenceCapable persistenceCapable, long l, Transaction transaction) {
        PersistenceManager persistenceManager = persistenceCapable.getPersistenceManager();
        if (persistenceManager != null) {
            if (persistenceManager != this) {
                throw new UserPersistenceException("The persistence manager has already been set to another manager");
            }
        } else {
            Object object = this.makeLock;
            synchronized (object) {
                this.makePersistentImpl(persistenceCapable, l, transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void makeTransient(PersistenceCapable persistenceCapable, Transaction transaction) {
        if (persistenceCapable.getPersistenceManager() != this) {
            throw new UserPersistenceException("The persistence manager has not been set to this persistence manager for " + persistenceCapable);
        }
        Object object = this.makeLock;
        synchronized (object) {
            this.makeTransientImpl(persistenceCapable, transaction);
        }
    }

    protected final long nextId() {
        return this.nextId++;
    }

    protected final void idUsed(long l) {
        if ((int)(l >>> 48) == this.id && this.nextId <= l) {
            this.nextId = l + 1L;
        }
    }

    protected abstract void makePersistentImpl(PersistenceCapable var1, long var2, Transaction var4);

    protected abstract void makeTransientImpl(PersistenceCapable var1, Transaction var2);

    public abstract PersistenceCapable getObject(long var1);

    public abstract void writeExtent(PersistenceOutputStream var1) throws IOException;

    public abstract void readExtent(PersistenceInputStream var1) throws IOException;

    public abstract int allocateBitMark(boolean var1);

    public abstract void disposeBitMark(int var1, boolean var2);

    public abstract int allocateObjectMark(boolean var1);

    public abstract void disposeObjectMark(int var1, boolean var2);

    public boolean undo(Transaction transaction) throws IOException {
        LogStore.Entry entry = this.log.getLastEntry();
        if (entry == null) {
            return false;
        }
        Transaction.Data data = this.getTransactionData(entry.getKey());
        if (data == null) {
            return false;
        }
        transaction.undo(data);
        return true;
    }

    private static final class PendingEnd {
        static final int COMMIT = 0;
        static final int ROLLBACK_LOCAL = 1;
        static final int COMMIT_LOCAL = 2;
        final int type;
        final long stamp;
        final Transaction.Data xa;

        PendingEnd(int n, long l, Transaction.Data data) {
            this.type = n;
            this.stamp = l;
            this.xa = data;
        }
    }
}

