/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.Transaction;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Hashtable;

public final class LogStore {
    private final boolean keepAll;
    private int maxBytes = (int)Math.min(3.3554432E7, (double)Runtime.getRuntime().maxMemory() * 0.05);
    private int maxSoftBytes = 2 * this.maxBytes;
    private final Hashtable<Transaction.Key, Entry> map = new Hashtable();
    private volatile Entry first = null;
    private volatile Entry last = null;
    private Entry firstStrong = null;
    private ReferenceQueue queue = new ReferenceQueue();

    public LogStore(boolean bl) {
        this.keepAll = bl;
    }

    private void addImpl(Transaction.Key key, Transaction.Data data) {
        Entry entry = new Entry(key, data, this.queue, this.last);
        if (this.first == null) {
            this.first = entry;
            this.firstStrong = entry;
        }
        this.last = entry;
        if (this.map.put(key, entry) != null) {
            throw new AssertionError();
        }
    }

    private void updateRefs() {
        if (!this.keepAll) {
            Entry entry;
            Entry entry2;
            Object object = this.firstStrong;
            while (true) {
                long l = ((Entry)object).getByteSizeUpTo(this.last);
                if (object == this.last || l < (long)this.maxBytes) {
                    while (this.firstStrong != object) {
                        this.firstStrong.strongRef = null;
                        this.firstStrong = this.firstStrong.getNext();
                    }
                    break;
                }
                object = ((Entry)object).getNext();
            }
            while ((object = (DataRef)this.queue.poll()) != null) {
                Entry entry3 = this.map.get(((DataRef)object).key);
                if (entry3 == null) continue;
                this.first = entry3.getNext();
                this.first.previous = null;
                while (entry3 != null) {
                    this.map.remove(entry3.key);
                    entry2 = entry3.getPrevious();
                    entry3.clear();
                    entry3 = entry2;
                }
            }
            if (this.firstStrong != null && (entry = this.firstStrong.getPrevious()) != null) {
                entry2 = this.first;
                while (true) {
                    long l = entry2.getByteSizeUpTo(entry);
                    if (entry2 == entry || l < (long)this.maxSoftBytes) {
                        while (this.first != entry2) {
                            this.map.remove(this.first.key);
                            Entry entry4 = this.first.getNext();
                            this.first.clear();
                            this.first = entry4;
                        }
                        this.first.previous = null;
                        break;
                    }
                    entry2 = entry2.getNext();
                }
            }
        }
    }

    public void add(Transaction.Key key, Transaction.Data data) {
        this.addImpl(key, data);
        this.updateRefs();
    }

    public void removeLast(int n) {
        while (--n >= 0 && this.last != null) {
            if (this.last == this.first) {
                this.clear();
                return;
            }
            this.map.remove(this.last.getKey());
            this.last = this.last.previous;
            this.last.next = null;
        }
    }

    public Transaction.Data get(Transaction.Key key) {
        Entry entry = this.map.get(key);
        return entry == null ? null : entry.getData();
    }

    public Entry getFirstEntry() {
        if (this.keepAll) {
            return this.first;
        }
        throw new IllegalStateException("getFirstEntry() invoked, keepAll == false");
    }

    public Entry getLastEntry() {
        return this.last;
    }

    public void clear() {
        Entry entry = this.first;
        while (entry != null) {
            Entry entry2 = entry.getNext();
            entry.clear();
            entry = entry2;
        }
        this.map.clear();
        this.first = null;
        this.firstStrong = null;
        this.last = null;
    }

    public static final class Entry {
        Transaction.Key key;
        DataRef softRef;
        Transaction.Data strongRef;
        Entry next = null;
        Entry previous = null;
        private final long accumulatedSize;
        private final int id;
        private final int size;

        Entry(Transaction.Key key, Transaction.Data data, ReferenceQueue referenceQueue, Entry entry) {
            this.key = key;
            this.softRef = new DataRef(data, referenceQueue);
            this.strongRef = data;
            this.size = data.getUsedMemoryForPrimitives() + 400;
            if (entry != null) {
                entry.next = this;
                this.previous = entry;
                this.id = entry.id + 1;
                this.accumulatedSize = entry.accumulatedSize + (long)this.size;
            } else {
                this.id = 0;
                this.accumulatedSize = this.size;
            }
        }

        long getByteSizeUpTo(Entry entry) {
            return (long)this.size + entry.accumulatedSize - this.accumulatedSize;
        }

        int getEntryCountUpTo(Entry entry) {
            return 1 + entry.id - this.id;
        }

        public Entry getPrevious() {
            return this.previous;
        }

        public Entry getNext() {
            return this.next;
        }

        public Transaction.Key getKey() {
            return this.key;
        }

        public Transaction.Data getData() {
            return (Transaction.Data)this.softRef.get();
        }

        void clear() {
            this.key = null;
            this.softRef.clear();
            this.softRef = null;
            this.strongRef = null;
            this.next = null;
            this.previous = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DataRef
    extends SoftReference<Transaction.Data> {
        final Transaction.Key key;

        DataRef(Transaction.Data data, ReferenceQueue referenceQueue) {
            super(data, referenceQueue);
            this.key = data.getKey();
        }
    }
}

