/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.impl;

import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.Transaction;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import java.io.PrintStream;

public class GraphTransaction
extends Transaction {
    public static final int ADD_EDGE_BITS = 32;
    public static final int REMOVE_EDGE_BITS = 33;
    public static final int MIN_UNUSED_ITEM = 34;
    final ObjectList<Node> madePersistent = new ObjectList();
    final ObjectList<Node> madeTransient = new ObjectList();
    final ObjectList<Node> extentIndexChanged = new ObjectList();

    public GraphTransaction(GraphManager graphManager, Thread thread) {
        super((PersistenceManager)graphManager, thread);
        this.setItemSize(32, 0, 2, 2, 0, 0, 0);
        this.setItemSize(33, 0, 2, 2, 0, 0, 0);
    }

    protected boolean isLoggingSuppressed() {
        return ((GraphManager)this.manager).loggingSuppressed;
    }

    public void logAddEdgeBits(Node node, Node node2, int n, int n2) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(32);
        this.writeLong(node.id);
        this.writeLong(node2.id);
        this.writeInt(n);
        this.writeInt(n2);
    }

    public void logRemoveEdgeBits(Node node, Node node2, int n, int n2) {
        this.setModified();
        if (this.isLoggingSuppressed()) {
            return;
        }
        this.writeItem(33);
        this.writeLong(node.id);
        this.writeLong(node2.id);
        this.writeInt(n);
        this.writeInt(n2);
    }

    public Transaction.Reader createReader() {
        return new Reader();
    }

    public class Reader
    extends Transaction.Reader {
        Reader() {
            super(GraphTransaction.this);
        }

        protected void supply(int n, Transaction.Consumer consumer) throws IOException {
            switch (n & 0xFFF) {
                case 32: {
                    if (consumer instanceof Consumer) {
                        ((Consumer)((Object)consumer)).addEdgeBits((Node)GraphTransaction.this.manager.getObject(this.readLong()), (Node)GraphTransaction.this.manager.getObject(this.readLong()), this.readInt());
                        break;
                    }
                    this.readLong();
                    this.readLong();
                    this.readInt();
                    break;
                }
                case 33: {
                    if (consumer instanceof Consumer) {
                        ((Consumer)((Object)consumer)).removeEdgeBits((Node)GraphTransaction.this.manager.getObject(this.readLong()), (Node)GraphTransaction.this.manager.getObject(this.readLong()), this.readInt());
                        break;
                    }
                    this.readLong();
                    this.readLong();
                    this.readInt();
                    break;
                }
                default: {
                    super.supply(n, consumer);
                }
            }
        }

        protected void supplyInverse(int n, Transaction.Consumer consumer) throws IOException {
            switch (n & 0xFFF) {
                case 32: {
                    ((Consumer)((Object)consumer)).removeEdgeBits((Node)GraphTransaction.this.manager.getObject(this.readLong()), (Node)GraphTransaction.this.manager.getObject(this.readLong()), this.readInt());
                    break;
                }
                case 33: {
                    ((Consumer)((Object)consumer)).addEdgeBits((Node)GraphTransaction.this.manager.getObject(this.readLong()), (Node)GraphTransaction.this.manager.getObject(this.readLong()), this.readInt());
                    break;
                }
                default: {
                    super.supplyInverse(n, consumer);
                }
            }
        }
    }

    public static class Dump
    implements Transaction.Consumer,
    Consumer {
        protected PrintStream out;

        public Dump(PrintStream printStream) {
            this.out = printStream;
        }

        public void setField(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
            this.out.print(persistenceCapable);
            this.out.print('.');
            this.out.print(persistenceField.getName());
            if (nArray != null && nArray.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.out.print('[');
                    this.out.print(nArray[i]);
                    this.out.print(']');
                }
            }
            this.out.print(" = ");
            try {
                switch (persistenceField.getType().getTypeId()) {
                    case 2: {
                        this.out.println(reader.readBoolean());
                        break;
                    }
                    case 3: {
                        this.out.println(reader.readByte());
                        break;
                    }
                    case 4: {
                        this.out.println(reader.readShort());
                        break;
                    }
                    case 5: {
                        this.out.println(reader.readChar());
                        break;
                    }
                    case 6: {
                        this.out.println(reader.readInt());
                        break;
                    }
                    case 7: {
                        this.out.println(reader.readLong());
                        break;
                    }
                    case 8: {
                        this.out.println(reader.readFloat());
                        break;
                    }
                    case 9: {
                        this.out.println(reader.readDouble());
                        break;
                    }
                    case 0: {
                        this.out.println(ManageableType.read(persistenceField.getLastField(), reader));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.out);
            }
        }

        public void insertComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
            this.out.print(persistenceCapable);
        }

        public void removeComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
            this.out.print(persistenceCapable);
        }

        public void makePersistent(long l, ManageableType manageableType) {
            this.out.print("makePersitent, id = ");
            this.out.println(l);
        }

        public void makeTransient(PersistenceCapable persistenceCapable, ManageableType manageableType) {
            this.out.print("makeTransient (");
            this.out.print(persistenceCapable);
            this.out.print("), id = ");
            this.out.println(persistenceCapable.getId());
        }

        public void readData(PersistenceCapable persistenceCapable, Transaction.Reader reader) {
            this.out.print("readData (");
            this.out.print(persistenceCapable);
            this.out.print("), id = ");
            this.out.println(persistenceCapable.getId());
        }

        public void begin() {
            this.out.println("begin");
        }

        public void end() {
            this.out.println("end");
        }

        public void addEdgeBits(Node node, Node node2, int n) {
            this.out.print("addEdgeBits (");
            this.out.print(node);
            this.out.print(" -");
            this.out.print(Integer.toHexString(n));
            this.out.print("-> ");
            this.out.print(node2);
            this.out.println(')');
        }

        public void removeEdgeBits(Node node, Node node2, int n) {
            this.out.print("removeEdgeBits (");
            this.out.print(node);
            this.out.print(" -");
            this.out.print(Integer.toHexString(n));
            this.out.print("-> ");
            this.out.print(node2);
            this.out.println(')');
        }
    }

    public static interface Consumer {
        public void addEdgeBits(Node var1, Node var2, int var3);

        public void removeEdgeBits(Node var1, Node var2, int var3);

        public static class Multicaster
        extends Transaction.Consumer.Multicaster
        implements Consumer {
            public void addEdgeBits(Node node, Node node2, int n) {
                ObjectList objectList = this.getConsumers();
                int n2 = objectList.size();
                for (int i = 0; i < n2; ++i) {
                    Object e = objectList.get(i);
                    if (!(e instanceof Consumer)) continue;
                    ((Consumer)e).addEdgeBits(node, node2, n);
                }
            }

            public void removeEdgeBits(Node node, Node node2, int n) {
                ObjectList objectList = this.getConsumers();
                int n2 = objectList.size();
                for (int i = 0; i < n2; ++i) {
                    Object e = objectList.get(i);
                    if (!(e instanceof Consumer)) continue;
                    ((Consumer)e).removeEdgeBits(node, node2, n);
                }
            }
        }

        public static class Adapter
        extends Transaction.Consumer.Adapter
        implements Consumer {
            public void addEdgeBits(Node node, Node node2, int n) {
            }

            public void removeEdgeBits(Node node, Node node2, int n) {
            }
        }
    }
}

