/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.GraphState;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WeakListenerDelegate
extends WeakReference<Object>
implements AttributeChangeListener,
EdgeChangeListener,
ChangeBoundaryListener {
    public WeakListenerDelegate(Object object) {
        super(object);
    }

    @Override
    public void attributeChanged(AttributeChangeEvent attributeChangeEvent) {
        AttributeChangeListener attributeChangeListener = (AttributeChangeListener)this.get();
        if (attributeChangeListener != null) {
            attributeChangeListener.attributeChanged(attributeChangeEvent);
        } else {
            attributeChangeEvent.getGraphState().getGraph().removeAttributeChangeListener(this);
        }
    }

    @Override
    public void edgeChanged(Object object, Object object2, Object object3, GraphState graphState) {
        EdgeChangeListener edgeChangeListener = (EdgeChangeListener)this.get();
        if (edgeChangeListener != null) {
            edgeChangeListener.edgeChanged(object, object2, object3, graphState);
        } else {
            graphState.getGraph().removeEdgeChangeListener(this);
        }
    }

    @Override
    public void beginChange(GraphState graphState) {
        ChangeBoundaryListener changeBoundaryListener = (ChangeBoundaryListener)this.get();
        if (changeBoundaryListener != null) {
            changeBoundaryListener.beginChange(graphState);
        } else {
            graphState.getGraph().removeChangeBoundaryListener(this);
        }
    }

    @Override
    public void endChange(GraphState graphState) {
        ChangeBoundaryListener changeBoundaryListener = (ChangeBoundaryListener)this.get();
        if (changeBoundaryListener != null) {
            changeBoundaryListener.endChange(graphState);
        } else {
            graphState.getGraph().removeChangeBoundaryListener(this);
        }
    }

    @Override
    public int getPriority() {
        ChangeBoundaryListener changeBoundaryListener = (ChangeBoundaryListener)this.get();
        return changeBoundaryListener != null ? changeBoundaryListener.getPriority() : 5;
    }
}

