/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.GraphState;
import de.grogra.graph.LongAttribute;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectMap;
import de.grogra.reflect.Type;
import de.grogra.xl.util.ObjectList;

public abstract class LongTreeAttribute
extends LongAttribute {
    public LongTreeAttribute(Type type) {
        super(type);
    }

    public LongTreeAttribute() {
    }

    protected ObjectAttribute getParentAttribute(GraphState graphState) {
        return graphState.getGraph().getParentAttribute();
    }

    synchronized AttributeState getAttrState(GraphState graphState) {
        AttributeState attributeState = (AttributeState)this.getAttributeState(graphState);
        if (attributeState == null) {
            attributeState = new AttributeState(graphState);
            this.setAttributeState(graphState, attributeState);
        }
        return attributeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getDerived(Object object, boolean bl, GraphState graphState) {
        int n = graphState.getInstancingPathIndex();
        if (n > 0) {
            Object object2 = graphState.getInstancingTreeAttribute(this, n);
            if (graphState.wasTreeAttributeValid()) {
                return ((long[])object2)[0];
            }
            graphState.moveToPreviousInstance();
            Object object3 = graphState.getInstancingPath().getObject(n - 1);
            long l = this.getDerived(object3, !bl, graphState);
            graphState.moveToNextInstance();
            l = this.derive(object, bl, l, graphState);
            if (object2 == null) {
                object2 = new long[]{l};
            } else {
                ((long[])object2)[0] = l;
            }
            graphState.setInstancingTreeAttribute(this, n, object2);
            return l;
        }
        AttributeState attributeState = this.getAttrState(graphState);
        ObjectList objectList = graphState.treeAttributeStack;
        int n2 = objectList.size;
        try {
            AttributeState attributeState2 = attributeState;
            synchronized (attributeState2) {
                long l;
                Listener listener;
                while (true) {
                    if ((listener = attributeState.listeners.getObject(object, bl)) == null) {
                        listener = new Listener();
                        attributeState.listeners.putObject(object, bl, listener);
                        graphState.getGraph().addAttributeChangeListener(object, bl, listener);
                    }
                    if (listener.obj != null) {
                        l = listener.value;
                        break;
                    }
                    listener.obj = object;
                    listener.objIsNode = bl;
                    objectList.push(listener);
                    object = this.getParentAttribute(graphState).getDerived(object, bl, null, graphState);
                    boolean bl2 = bl = !bl;
                    if (object == null) {
                        l = this.getInitialValue(graphState);
                        assert (listener.parent == null);
                        break;
                    }
                    if (listener.parent == object) continue;
                    assert (listener.parent == null);
                    listener.parent = object;
                    graphState.getGraph().addAttributeChangeListener(object, bl, listener);
                }
                while (objectList.size > n2) {
                    listener = (Listener)objectList.pop();
                    listener.value = l = this.derive(listener.obj, listener.objIsNode, l, graphState);
                }
                long l2 = l;
                return l2;
            }
        }
        finally {
            objectList.setSize(n2);
        }
    }

    protected abstract long derive(Object var1, boolean var2, long var3, GraphState var5);

    protected abstract long getInitialValue(GraphState var1);

    public boolean isDerived() {
        return true;
    }

    public abstract boolean dependsOn(Attribute[] var1);

    public long getParentValue(Object object, boolean bl, GraphState graphState) {
        int n = graphState.getInstancingPathIndex();
        if (n > 0) {
            graphState.moveToPreviousInstance();
            long l = this.getDerived(graphState.getInstancingPath().getObject(n - 1), !bl, graphState);
            graphState.moveToNextInstance();
            return l;
        }
        object = this.getParentAttribute(graphState).getDerived(object, bl, null, graphState);
        return object == null ? this.getInitialValue(graphState) : this.getDerived(object, !bl, graphState);
    }

    final class Listener
    implements AttributeChangeListener {
        Object parent;
        Object obj;
        boolean objIsNode;
        long value;

        Listener() {
        }

        LongTreeAttribute getAttribute() {
            return LongTreeAttribute.this;
        }

        public void attributeChanged(AttributeChangeEvent attributeChangeEvent) {
            if (this.obj == null) {
                if (this.parent != null && (attributeChangeEvent.object != this.parent || attributeChangeEvent.node == this.objIsNode) && LongTreeAttribute.this.getParentAttribute(attributeChangeEvent.state).isContained(attributeChangeEvent.dependent)) {
                    attributeChangeEvent.state.getGraph().removeAttributeChangeListener(this.parent, !this.objIsNode, this);
                    this.parent = null;
                }
            } else {
                if (this.obj == attributeChangeEvent.object && this.objIsNode == attributeChangeEvent.node) {
                    if (LongTreeAttribute.this.getParentAttribute(attributeChangeEvent.state).isContained(attributeChangeEvent.dependent)) {
                        assert (this.parent != null);
                        attributeChangeEvent.state.getGraph().removeAttributeChangeListener(this.parent, !this.objIsNode, this);
                        this.parent = null;
                    } else if (!LongTreeAttribute.this.dependsOn(attributeChangeEvent.dependent)) {
                        return;
                    }
                } else if (!LongTreeAttribute.this.isContained(attributeChangeEvent.dependent)) {
                    return;
                }
                Object object = this.obj;
                this.obj = null;
                LongTreeAttribute.this.getAttrState(attributeChangeEvent.state).fire(attributeChangeEvent.state, object, this);
            }
        }
    }

    static final class AttributeState {
        final ObjectMap<Listener> listeners;
        private boolean queueEvents = false;
        private ObjectList<Object> pendingEvents = new ObjectList();
        private ObjectList<Object> pendingEvents2 = new ObjectList();

        AttributeState(GraphState graphState) {
            this.listeners = graphState.getGraph().createObjectMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fire(GraphState graphState, Object object, Listener listener) {
            this.pendingEvents.push(listener).push(object);
            if (!this.queueEvents) {
                this.queueEvents = true;
                try {
                    while (!this.pendingEvents.isEmpty()) {
                        ObjectList<Object> objectList = this.pendingEvents;
                        this.pendingEvents = this.pendingEvents2;
                        this.pendingEvents2 = objectList;
                        for (int i = 0; i < objectList.size; i += 2) {
                            listener = (Listener)objectList.get(i);
                            graphState.fireAttributeChanged(objectList.get(i + 1), listener.objIsNode, listener.getAttribute(), null, null);
                        }
                        objectList.clear();
                    }
                }
                finally {
                    this.queueEvents = false;
                    this.pendingEvents.clear();
                    this.pendingEvents2.clear();
                }
            }
        }
    }
}

