/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.util;

import java.lang.reflect.Array;
import java.util.Random;

public class Utility {
    private static final Random rnd = new Random();

    private Utility() {
    }

    public static Object expand(Object src, int increase, boolean bottom) {
        int size = Array.getLength(src);
        Object dest = Array.newInstance(src.getClass().getComponentType(), size + increase);
        System.arraycopy(src, 0, dest, bottom ? 0 : increase, size);
        return dest;
    }

    public static Object expand(Object src, int increase) {
        return Utility.expand(src, increase, true);
    }

    public static Object expand(Object src, int increase, boolean bottom, Class type) {
        if (src == null) {
            return Array.newInstance(type, 1);
        }
        return Utility.expand(src, increase, bottom);
    }

    public static Object cut(Object src, int position) {
        int size = Array.getLength(src);
        if (size == 1) {
            return Array.newInstance(src.getClass().getComponentType(), 0);
        }
        int numMoved = size - position - 1;
        if (numMoved > 0) {
            System.arraycopy(src, position + 1, src, position, numMoved);
        }
        Object dest = Array.newInstance(src.getClass().getComponentType(), --size);
        System.arraycopy(src, 0, dest, 0, size);
        return dest;
    }

    public static void mixElements(Object src) {
        int size = Array.getLength(src);
        for (int i = 0; i < size; ++i) {
            int tempPos = Utility.getRandom(i, size - 1);
            Object tempVal = Array.get(src, tempPos);
            Array.set(src, tempPos, Array.get(src, i));
            Array.set(src, i, tempVal);
        }
    }

    public static Random getRandomObject() {
        return rnd;
    }

    public static int getRandom(int lowerBound, int upperBound) {
        return lowerBound + rnd.nextInt(upperBound - lowerBound + 1);
    }

    public static String[] compactStrings(String[] s) {
        String[] result = new String[s.length];
        int offset = 0;
        for (int i = 0; i < s.length; ++i) {
            offset += s[i].length();
        }
        char[] allchars = new char[offset];
        offset = 0;
        for (int i = 0; i < s.length; ++i) {
            s[i].getChars(0, s[i].length(), allchars, offset);
            offset += s[i].length();
        }
        String allstrings = new String(allchars);
        offset = 0;
        for (int i = 0; i < s.length; ++i) {
            result[i] = allstrings.substring(offset, offset += s[i].length());
        }
        return result;
    }
}

