/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.font;

import com.golden.gamedev.object.GameFont;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class BitmapFont
implements GameFont {
    private BufferedImage[] imagefont;
    private int w;
    private int h;
    protected int[] charIndex = new int[256];

    public BitmapFont(BufferedImage[] imagefont, String letterSequence) {
        this.imagefont = imagefont;
        this.w = imagefont[0].getWidth();
        this.h = imagefont[0].getHeight();
        for (int i = 0; i < this.charIndex.length; ++i) {
            this.charIndex[i] = -1;
        }
        int totalLetter = letterSequence.length();
        for (int i = 0; i < totalLetter; ++i) {
            this.charIndex[letterSequence.charAt((int)i)] = i;
        }
    }

    public BitmapFont(BufferedImage[] imagefont) {
        this(imagefont, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~");
    }

    public int drawString(Graphics2D g, String s, int x, int y) {
        int len = s.length();
        int index = 0;
        for (int i = 0; i < len; ++i) {
            char letter = s.charAt(i);
            index = this.charIndex[letter];
            if (index != -1) {
                try {
                    g.drawImage((Image)this.imagefont[index], x, y, null);
                    x += this.getWidth(letter);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(this + "\nunable to draw letter '" + s.charAt(i) + "'[" + (i + 1) + "] in " + "\"" + s + "\"! charIndex = " + index + "\n" + "caused by : " + e);
                }
            }
            throw new RuntimeException(this + "\nunable to draw letter [" + s.charAt(i) + "] (" + (i + 1) + ") in " + "[" + s + "] text! ");
        }
        return x;
    }

    public int drawString(Graphics2D g, String s, int alignment, int x, int y, int width) {
        if (alignment == 1) {
            return this.drawString(g, s, x, y);
        }
        if (alignment == 3) {
            return this.drawString(g, s, x + width / 2 - this.getWidth(s) / 2, y);
        }
        if (alignment == 2) {
            return this.drawString(g, s, x + width - this.getWidth(s), y);
        }
        if (alignment == 4) {
            int mod = width - this.getWidth(s);
            if (mod <= 0) {
                return this.drawString(g, s, x, y);
            }
            int len = s.length();
            int space = 0;
            int curpos = 0;
            int endpos = 0;
            while (curpos < len) {
                if (s.charAt(curpos++) != ' ') continue;
                ++space;
            }
            if (space > 0) {
                mod += this.w * space;
                space = mod / space;
            }
            endpos = 0;
            curpos = 0;
            while (curpos < len) {
                endpos = s.indexOf(32, curpos);
                if (endpos == -1) {
                    endpos = len;
                }
                String st = s.substring(curpos, endpos);
                this.drawString(g, st, x, y);
                x += this.getWidth(st) + space;
                curpos = endpos + 1;
            }
            return x;
        }
        return 0;
    }

    public int drawText(Graphics2D g, String text, int alignment, int x, int y, int width, int vspace, int firstIndent) {
        boolean firstLine = true;
        int len = text.length();
        int posx = firstIndent;
        int endpos = 0;
        int startpos = 0;
        int curpos = 0;
        while (curpos < len) {
            char curChr = text.charAt(curpos++);
            posx += this.getWidth(curChr);
            if (curChr - 32 == 0) {
                endpos = curpos - 1;
            }
            if (posx < width) continue;
            if (firstLine) {
                this.drawString(g, text.substring(startpos, endpos), alignment, alignment == 2 ? x : x + firstIndent, y, width - firstIndent);
                firstLine = false;
            } else {
                this.drawString(g, text.substring(startpos, endpos), alignment, x, y, width);
            }
            y += this.getHeight() + vspace;
            posx = 0;
            startpos = curpos = endpos + 1;
        }
        if (firstLine) {
            this.drawString(g, text.substring(startpos, curpos), alignment, alignment == 2 ? x : x + firstIndent, y, width - firstIndent);
        } else if (posx != 0) {
            this.drawString(g, text.substring(startpos, curpos), alignment, x, y, width);
        }
        return y + this.getHeight();
    }

    public BufferedImage[] getImageFont() {
        return this.imagefont;
    }

    public void setImageFont(BufferedImage[] imagefont, String letterSequence) {
        this.imagefont = imagefont;
        this.w = imagefont[0].getWidth();
        this.h = imagefont[0].getHeight();
        for (int i = 0; i < this.charIndex.length; ++i) {
            this.charIndex[i] = -1;
        }
        int totalLetter = letterSequence.length();
        for (int i = 0; i < totalLetter; ++i) {
            this.charIndex[letterSequence.charAt((int)i)] = i;
        }
    }

    public int getWidth(char c) {
        return this.w;
    }

    public int getWidth(String st) {
        return st.length() * this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public String toString() {
        return super.toString() + " " + "[totalChar=" + this.imagefont.length + ", width=" + this.w + ", height=" + this.h + "]";
    }

    public boolean isAvailable(char c) {
        try {
            return this.charIndex[c] != -1;
        }
        catch (Exception e) {
            return false;
        }
    }
}

