/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.collision.CollisionShape;

public class CollisionRect
implements CollisionShape {
    public double x = 0.0;
    public double y = 0.0;
    public int width = 0;
    public int height = 0;
    private int x1;
    private int x2;

    public void grow(int h, int v) {
        if (h >= 0) {
            this.width += h;
        } else {
            this.x += (double)h;
            this.width -= h;
        }
        if (v >= 0) {
            this.height += v;
        } else {
            this.y += (double)v;
            this.height -= v;
        }
    }

    public void shrink(int h, int v) {
        if (h >= 0) {
            this.width -= h;
        } else {
            this.x -= (double)h;
            this.width += h;
        }
        if (v >= 0) {
            this.height -= v;
        } else {
            this.y -= (double)v;
            this.height += v;
        }
    }

    public boolean intersects(CollisionShape shape) {
        return this.x + (double)this.width > shape.getX() && this.x < shape.getX() + (double)shape.getWidth() && this.y + (double)this.height > shape.getY() && this.y < shape.getY() + (double)shape.getHeight();
    }

    public void setBounds(double x1, double y1, int w1, int h1) {
        this.x = x1;
        this.y = y1;
        this.width = w1;
        this.height = h1;
    }

    public void setBounds(CollisionShape shape) {
        this.setBounds(shape.getX(), shape.getY(), shape.getWidth(), shape.getHeight());
    }

    public void setLocation(double x1, double y1) {
        this.x = x1;
        this.y = y1;
    }

    public void move(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return super.toString() + " " + "[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

