/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.Timer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class AnimatedSprite
extends Sprite {
    private static final long serialVersionUID = -3921494149259881742L;
    private transient BufferedImage[] image;
    private int frame;
    private int startFrame;
    private int finishFrame;
    private boolean animate;
    private boolean loopAnim;
    private Timer animationTimer;

    public AnimatedSprite(BufferedImage[] image, double x, double y) {
        super(x, y);
        if (image != null) {
            this.image = image;
            this.width = image[0].getWidth();
            this.height = image[0].getHeight();
            this.startFrame = 0;
            this.frame = 0;
            this.finishFrame = image.length - 1;
        }
        this.animationTimer = new Timer(60);
    }

    public AnimatedSprite(BufferedImage[] image) {
        this(image, 0.0, 0.0);
    }

    public AnimatedSprite(double x, double y) {
        this((BufferedImage[])null, x, y);
    }

    public AnimatedSprite() {
        this(0.0, 0.0);
    }

    public void setImages(BufferedImage[] image) {
        if (this.image == image) {
            return;
        }
        this.image = null;
        this.frame = 0;
        this.startFrame = 0;
        this.animationTimer.refresh();
        if (image == null || image[0] == null) {
            this.finishFrame = 0;
            this.height = 0;
            this.width = 0;
        } else {
            this.image = image;
            this.width = image[0].getWidth();
            this.height = image[0].getHeight();
            this.finishFrame = image.length - 1;
        }
    }

    public void setImage(BufferedImage image) {
        throw new RuntimeException("Animated Sprite need an array of images, use setImages(BufferedImage[]) instead!");
    }

    public BufferedImage[] getImages() {
        return this.image;
    }

    public BufferedImage getImage(int i) {
        return this.image[i];
    }

    public BufferedImage getImage() {
        return this.image[this.frame];
    }

    public void setFrame(int i) {
        this.frame = i + this.startFrame;
        if (this.frame > this.finishFrame) {
            this.frame = this.startFrame;
        } else if (this.frame < this.startFrame) {
            this.frame = this.finishFrame;
        }
    }

    public int getFrame() {
        return this.frame;
    }

    public void setAnimationFrame(int start, int finish) {
        if (start == this.startFrame && finish == this.finishFrame) {
            return;
        }
        this.animationTimer.refresh();
        this.startFrame = start;
        this.finishFrame = finish;
        this.frame = this.startFrame;
    }

    public int getStartAnimationFrame() {
        return this.startFrame;
    }

    public int getFinishAnimationFrame() {
        return this.finishFrame;
    }

    public void update(long elapsedTime) {
        super.update(elapsedTime);
        if (this.animate && this.animationTimer.action(elapsedTime)) {
            this.updateAnimation();
        }
    }

    protected void updateAnimation() {
        if (++this.frame > this.finishFrame) {
            this.frame = this.startFrame;
            if (!this.loopAnim) {
                this.animate = false;
            }
        }
    }

    public void render(Graphics2D g, int xs, int ys) {
        g.drawImage((Image)this.image[this.frame], xs, ys, null);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean b) {
        this.animate = b;
    }

    public boolean isLoopAnim() {
        return this.loopAnim;
    }

    public void setLoopAnim(boolean b) {
        this.loopAnim = b;
    }

    public void setAnimationTimer(Timer t) {
        this.animationTimer = t;
    }

    public Timer getAnimationTimer() {
        return this.animationTimer;
    }
}

