/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.timer;

public class FPSCounter {
    private long lastCount;
    private int currentFPS;
    private int frameCount;

    public void refresh() {
        this.frameCount = 0;
        this.lastCount = System.currentTimeMillis();
    }

    public void calculateFPS() {
        ++this.frameCount;
        if (System.currentTimeMillis() - this.lastCount > 1000L) {
            this.lastCount = System.currentTimeMillis();
            this.currentFPS = this.frameCount;
            this.frameCount = 0;
        }
    }

    public int getCurrentFPS() {
        return this.currentFPS;
    }
}

