/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.LavaSpots;
import Objects.BasicEnemy;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.util.Utility;

public class LavaBall
extends AnimatedSprite
implements BasicEnemy {
    Mario game;
    double gravity = -10.0;
    private int timer;
    int showRippleAt = 416;
    int delay = 10;

    public LavaBall(double x, double y, Mario g) {
        super(x, 448.0);
        this.game = g;
        this.setImages(this.game.bsLoader.getStoredImages("LavaBall"));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationTimer(new Timer(150));
    }

    public void update(long elapsedTime) {
        if (this.getY() > 500.0) {
            this.Jump();
        } else {
            this.moveY(this.gravity);
        }
        if (this.gravity > 0.0) {
            this.setAnimationFrame(3, 5);
        } else {
            this.setAnimationFrame(0, 2);
        }
        if (this.gravity < 0.0 && this.getY() < 320.0 && this.delay < 0) {
            this.ThrowLavaSpots();
        }
        if (this.gravity < 10.0) {
            this.gravity += 0.4;
        }
        if (this.delay > -10) {
            --this.delay;
        }
        super.update(elapsedTime);
    }

    private void ThrowLavaSpots() {
        this.delay = Utility.getRandom(1, 2) * 5;
        this.game.AnimationGroup.add(new LavaSpots(this.getX() + (double)(Utility.getRandom(0, 1) * 20), this.getY() + 48.0, this.game.bsLoader.getStoredImages("LavaSpots")));
    }

    private void Jump() {
        --this.timer;
        if (this.timer < 0) {
            this.timer = Utility.getRandom(2, 7) * 20;
            this.setY(500.0);
            this.gravity = Utility.getRandom(-17, -14);
        }
    }

    public void CollidedWithBrick_GoToLeft() {
    }

    public void CollidedWithBrick_GoToRight() {
    }

    public int getType() {
        return this.getID();
    }

    public void MarioJumpedOnEnemy() {
    }

    public void KilledByFireBall() {
    }

    public void bounce() {
    }

    public void setYloc(double d1) {
    }

    public void CollidedWithShell() {
    }

    public void CollidedWithMovingShell() {
    }

    public void OtherEnemyTouchedFromRight() {
    }

    public void OtherEnemyTouchedFromLeft() {
    }

    public void CollidedWithMarioFromTOLeft() {
    }

    public void CollidedWithMarioTORight() {
    }

    public void EnemyJumperOnMario() {
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

