/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.DirectFalling;
import Objects.BasicEnemy;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.sprite.VolatileSprite;
import com.golden.gamedev.util.ImageUtil;
import com.golden.gamedev.util.Utility;
import java.awt.image.BufferedImage;
import java.util.Random;

public class FishyGround
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    double Gravity = -10.0;
    public int XSpeed = 0;

    public FishyGround(int x, int y, BufferedImage[] Enemy_Image, Mario g) {
        this.setLocation(x, y);
        this.setImages(Enemy_Image);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.game = g;
        this.setID(100);
    }

    public FishyGround(Mario g) {
        this.game = g;
        this.setLocation(this.game.player.getX(), 512.0);
        Random r = new Random();
        if (r.nextBoolean()) {
            this.PositiveX = true;
            this.XSpeed = Utility.getRandom(1, 3);
            this.setImages(ImageUtil.flipHorizontal(this.game.bsLoader.getStoredImages("FishRed")));
        } else {
            this.PositiveX = false;
            this.XSpeed = Utility.getRandom(-3, -1);
            this.setImages(this.game.bsLoader.getStoredImages("FishRed"));
        }
        if (this.XSpeed < 0) {
            this.moveX(Utility.getRandom(128, 256));
        } else {
            this.moveX(Utility.getRandom(-256, -128));
        }
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
    }

    public void update(long l) {
        if (this.Gravity < 10.0) {
            this.Gravity += 0.1;
        }
        this.moveY(this.Gravity);
        this.moveX(this.XSpeed + this.game.player.speed / 20);
        if (this.getY() > 576.0 || this.getScreenX() < -32.0 || this.getScreenX() > 640.0) {
            this.setActive(false);
        }
        super.update(l);
    }

    public void MarioJumpedOnEnemy() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        }
        this.game.player.Jump(-8);
        this.game.AnimationGroup.add(new DirectFalling(this.getImage(), this.getX(), this.getY()));
        this.setActive(false);
    }

    public void KilledByFireBall() {
        this.game.AnimationGroup.add(new DirectFalling(this.getX(), this.getY(), this.getImage()));
        this.setActive(false);
    }

    public void bounce() {
    }

    public void setYloc(double d1) {
    }

    public void CollidedWithShell() {
    }

    public int getType() {
        return this.getID();
    }

    public void CollidedWithMovingShell() {
        this.game.AnimationGroup.add(new DirectFalling(this.getX(), this.getY(), this.getImage()));
        this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
        this.setActive(false);
    }

    public void CollidedWithBrick_GoToLeft() {
    }

    public void CollidedWithBrick_GoToRight() {
    }

    public void OtherEnemyTouchedFromRight() {
    }

    public void OtherEnemyTouchedFromLeft() {
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new DirectFalling(this.getX(), this.getY(), this.getImage()));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new DirectFalling(this.getX(), this.getY(), this.getImage()));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.game.AnimationGroup.add(new DirectFalling(this.getX(), this.getY(), this.getImage()));
            this.game.AnimationGroup.add(new VolatileSprite(this.game.bsLoader.getStoredImages("Twink"), this.getX(), this.getY()));
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

