/*
 * Decompiled with CFR 0.152.
 */
package AmitsMusicPlayer;

import AmitsMusicPlayer.AudioFilesInterface;
import AmitsMusicPlayer.SimpleMusicFile;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SimpleSoundFileWithMultipleClips
implements LineListener,
AudioFilesInterface {
    protected final String AudioFileName;
    private final Clip[] audioClip;

    SimpleSoundFileWithMultipleClips(String AudioFileName, int number_of_clips) {
        this.AudioFileName = AudioFileName;
        this.audioClip = new Clip[number_of_clips];
    }

    public void intitalize() {
        System.out.println("Loading Sound file \"" + this.AudioFileName + "\"");
        try {
            for (int i = 0; i < this.audioClip.length; ++i) {
                URL audioFile = this.getClass().getResource(this.AudioFileName);
                AudioInputStream audioStream = AudioSystem.getAudioInputStream(audioFile);
                AudioFormat format = audioStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                this.audioClip[i] = (Clip)AudioSystem.getLine(info);
                this.audioClip[i].open(audioStream);
            }
        }
        catch (LineUnavailableException ex) {
            Logger.getLogger(SimpleMusicFile.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("sound file not found \"" + this.AudioFileName + "\"");
        }
        catch (UnsupportedAudioFileException ex) {
            Logger.getLogger(SimpleMusicFile.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("sound file not found \"" + this.AudioFileName + "\"");
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleMusicFile.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("sound file not found \"" + this.AudioFileName + "\"");
        }
    }

    public void update(LineEvent event) {
        if (LineEvent.Type.START == event.getType() || LineEvent.Type.STOP == event.getType()) {
            // empty if block
        }
    }

    public void play() {
        for (int i = 0; !(i >= this.audioClip.length || this.audioClip[i].isRunning() && this.audioClip[i].getFramePosition() < 300); ++i) {
            if (this.audioClip[i].isRunning()) continue;
            this.audioClip[i].setFramePosition(0);
            this.audioClip[i].start();
            break;
        }
    }

    public void stop() {
    }
}

