/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.Executer;
import xnap.cmdl.ParameterException;
import xnap.cmdl.SyntaxException;
import xnap.net.ITransferContainer;
import xnap.net.IUpload;
import xnap.net.IUploadContainer;
import xnap.net.IUser;
import xnap.net.SimpleUpload;
import xnap.util.TransferQueue;

public class UploadQueue
extends TransferQueue
implements PropertyChangeListener {
    private static UploadQueue singleton = new UploadQueue();
    static /* synthetic */ Class class$xnap$util$DownloadQueue;

    public static UploadQueue getInstance() {
        return singleton;
    }

    public boolean add(IUpload iUpload) {
        return this.add(new SimpleUpload(iUpload));
    }

    public boolean add(IUploadContainer iUploadContainer) {
        if (!this.isQueued(iUploadContainer) && !this.isRunning(iUploadContainer)) {
            this.logger.debug("add " + iUploadContainer);
            super.add(iUploadContainer);
            if (this.check(iUploadContainer)) {
                return this.enqueue(iUploadContainer, this.isPreferred(iUploadContainer));
            }
        }
        return false;
    }

    public boolean canStart(ITransferContainer iTransferContainer) {
        if (prefs.getLimitUploadsPerUser()) {
            IUser iUser = iTransferContainer.getUser();
            if (iUser.getMaxUploads() == -1) {
                boolean bl = false;
                if (iUser.getLocalUploadCount() < prefs.getMaxUploadsPerUser() || prefs.getMaxUploadsPerUser() == 0) {
                    bl = true;
                }
                return bl;
            }
            boolean bl = false;
            if (iUser.getLocalUploadCount() < iUser.getMaxUploads()) {
                bl = true;
            }
            return bl;
        }
        return true;
    }

    public boolean check(IUploadContainer iUploadContainer) {
        if (iUploadContainer.getUser().getMaxUploads() == 0) {
            iUploadContainer.reject(XNap.tr("User blocked"));
            return false;
        }
        return true;
    }

    public int getLocalQueuePos(IUpload iUpload) {
        return super.getLocalQueuePos(new SimpleUpload(iUpload));
    }

    public boolean isPreferred(IUploadContainer iUploadContainer) {
        boolean bl = false;
        if (iUploadContainer.getUser().getMaxUploads() == Integer.MAX_VALUE && (!prefs.getLimitUploadsPerUser() || iUploadContainer.getUser().getLocalUploadCount() < prefs.getMaxUploadsPerUser()) || iUploadContainer.getUser().getLocalDownloadCount() > iUploadContainer.getUser().getLocalUploadCount()) {
            bl = true;
        }
        return bl;
    }

    public boolean isRunning(IUpload iUpload) {
        return super.isRunning(new SimpleUpload(iUpload));
    }

    public void startUpload(IUploadContainer iUploadContainer) {
        this.startTransfer(iUploadContainer);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateLimit();
    }

    protected void updateLimit() {
        int n = 0;
        if (prefs.getLimitUploads()) {
            n = prefs.getMaxUploads();
        }
        this.setMaxTransfers(n);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private UploadQueue() {
        super("UploadQueue");
        Class clazz = class$xnap$util$DownloadQueue;
        if (clazz == null) {
            clazz = class$xnap$util$DownloadQueue = UploadQueue.class$("[Lxnap.util.DownloadQueue;", false);
        }
        this.logger = Logger.getLogger(clazz);
        prefs.addPropertyChangeListener("limitUploads", this);
        prefs.addPropertyChangeListener("maxUploads", this);
        prefs.addPropertyChangeListener("limitUploadsPerUser", this);
        prefs.addPropertyChangeListener("maxUploadsPerUser", this);
        this.updateLimit();
        Executer.addCommand(new ListUlsCmd());
        Executer.addCommand(new AbortUlCmd());
    }

    protected class ListUlsCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            UploadQueue.this.print();
            return true;
        }

        public ListUlsCmd() {
            this.putValue("cmd", new String[]{"listuploads", "lul", "pup"});
            this.putValue("shortHelp", "Shows the upload queue.");
        }
    }

    protected class AbortUlCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) throws SyntaxException, ParameterException {
            if (UploadQueue.this.lastTransfers == null) {
                UploadQueue.this.lastTransfers = UploadQueue.this.getTransfers();
            }
            int n = this.getInt(stringArray, 0, UploadQueue.this.lastTransfers.length - 1);
            UploadQueue.this.abort(UploadQueue.this.lastTransfers[n]);
            return true;
        }

        public AbortUlCmd() {
            this.putValue("cmd", new String[]{"abortupload", "aul"});
            this.putValue("parameter", "id");
            this.putValue("shortHelp", "Aborts an upload.");
        }
    }
}

