/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import gnu.getopt.Getopt;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.Console;
import xnap.cmdl.Executer;
import xnap.net.AutoDownload;
import xnap.net.IBrowse;
import xnap.net.ISearch;
import xnap.net.SearchResultContainer;
import xnap.plugin.PluginManager;
import xnap.util.Browser;
import xnap.util.DownloadQueue;
import xnap.util.EventVector;
import xnap.util.Formatter;
import xnap.util.ISearchContainer;
import xnap.util.NumberParser;
import xnap.util.Preferences;
import xnap.util.SearchFilter;
import xnap.util.Searcher;
import xnap.util.event.SearchManagerListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SearchManager
extends EventVector {
    private static SearchManager singleton = new SearchManager();
    private static Console console = Console.getInstance();
    private SearchResultContainer[] lastResults;
    private ISearchContainer lastSearch;
    private SearchManagerListener listener;
    private int readyCount;
    private boolean resumed;

    public static synchronized SearchManager getInstance() {
        return singleton;
    }

    public void browse(IBrowse iBrowse) {
        Browser browser = new Browser(iBrowse);
        super.add(browser);
    }

    public ISearchContainer[] getSearches() {
        ISearchContainer[] iSearchContainerArray = new ISearchContainer[super.size()];
        System.arraycopy(super.toArray(), 0, iSearchContainerArray, 0, iSearchContainerArray.length);
        return iSearchContainerArray;
    }

    public synchronized void resumeDownloads() {
        if (!this.resumed && Preferences.getInstance().getAutoResumeDownloads()) {
            DownloadQueue.getInstance().resumeAll();
            this.resumed = true;
        }
    }

    public synchronized void readyToSearch(boolean bl) {
        this.readyCount += bl ? 1 : -1;
        this.notifyListener();
    }

    private final synchronized void notifyListener() {
        if (this.listener != null) {
            boolean bl = false;
            if (this.readyCount > 0) {
                bl = true;
            }
            this.listener.readyToSearch(bl);
        }
    }

    public void remove(ISearchContainer iSearchContainer) {
        super.remove(iSearchContainer);
    }

    public void search(SearchFilter searchFilter) {
        ISearch[] iSearchArray = PluginManager.getInstance().search(searchFilter, 2);
        Searcher searcher = new Searcher(iSearchArray, searchFilter);
        super.add(searcher);
    }

    public synchronized void setListener(SearchManagerListener searchManagerListener) {
        this.listener = searchManagerListener;
        this.notifyListener();
    }

    protected int getResultIndex(String[] stringArray) {
        int n;
        if (stringArray.length != 2) {
            return -1;
        }
        if (this.lastResults == null) {
            console.println("Please list results first.");
            return -2;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (n < 0 || n > this.lastResults.length - 1) {
            console.println("Wrong search result id.");
            return -2;
        }
        return n;
    }

    private final /* synthetic */ void this() {
        this.listener = null;
        this.readyCount = 0;
        this.resumed = false;
    }

    public SearchManager() {
        this.this();
        Executer.addCommand(new ListSearchesCmd());
        Executer.addCommand(new ListResultsCmd());
        Executer.addCommand(new SearchCmd());
        Executer.addCommand(new DownloadCmd());
    }

    protected class ListSearchesCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            ISearchContainer[] iSearchContainerArray = SearchManager.this.getSearches();
            String[] stringArray2 = new String[iSearchContainerArray.length];
            int n = 0;
            while (n < iSearchContainerArray.length) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n);
                stringBuffer.append("|");
                stringBuffer.append(iSearchContainerArray[n].toString());
                stringBuffer.append("|");
                stringBuffer.append(iSearchContainerArray[n].getCollector().getResults().length);
                stringBuffer.append(" results");
                stringBuffer.append("|");
                stringBuffer.append(iSearchContainerArray[n].getStatus());
                stringArray2[n] = stringBuffer.toString();
                ++n;
            }
            n = 0;
            int n2 = 2;
            int[] nArray = new int[]{n2, n, n2, n};
            console.println(Formatter.formatTable(stringArray2, nArray));
            return true;
        }

        public ListSearchesCmd() {
            this.putValue("cmd", new String[]{"listsearches", "ls"});
            this.putValue("shortHelp", "Prints a list of running or finished searches.");
        }
    }

    protected class ListResultsCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            if (stringArray.length != 2) {
                return false;
            }
            SearchManager.this.lastSearch = (ISearchContainer)SearchManager.this.get(Integer.parseInt(stringArray[1]));
            if (SearchManager.this.lastSearch == null) {
                console.println("Wrong search id.");
                return true;
            }
            SearchManager.this.lastResults = SearchManager.this.lastSearch.getCollector().getGroupedResults();
            String[] stringArray2 = new String[SearchManager.this.lastResults.length];
            int n = 0;
            while (n < SearchManager.this.lastResults.length) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n);
                stringBuffer.append("|" + SearchManager.this.lastResults[n].getShortFilename());
                stringBuffer.append("|" + SearchManager.this.lastResults[n].getUsername());
                stringArray2[n] = stringBuffer.toString();
                ++n;
            }
            n = 0;
            int n2 = 2;
            int[] nArray = new int[]{n2, n, n};
            console.println(Formatter.formatTable(stringArray2, nArray));
            return true;
        }

        public ListResultsCmd() {
            this.putValue("cmd", new String[]{"listresults", "lr"});
            this.putValue("parameter", "id");
            this.putValue("shortHelp", "Prints a list of searches.");
        }
    }

    protected class DownloadCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            int n = SearchManager.this.getResultIndex(stringArray);
            if (n >= 0) {
                AutoDownload autoDownload = new AutoDownload(SearchManager.this.lastResults[n].getSearchResults(), new SearchFilter());
                DownloadQueue.getInstance().add(autoDownload);
            } else if (n == -1) {
                return false;
            }
            return true;
        }

        public DownloadCmd() {
            this.putValue("cmd", new String[]{"download", "d"});
            this.putValue("parameter", "id");
            this.putValue("shortHelp", "Download a search result.");
        }
    }

    protected class SearchCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            SearchFilter searchFilter = new SearchFilter();
            System.arraycopy(stringArray, 1, stringArray, 0, stringArray.length - 1);
            Getopt getopt = new Getopt("xnap search", stringArray, "b:s:");
            getopt.setOpterr(false);
            try {
                int n;
                while ((n = getopt.getopt()) != -1) {
                    switch (n) {
                        case 98: {
                            NumberParser numberParser = new NumberParser(getopt.getOptarg(), 1);
                            searchFilter.setBitrateCompare(numberParser.getCompare());
                            searchFilter.setBitrate(numberParser.getValue());
                            break;
                        }
                        case 115: {
                            NumberParser numberParser = new NumberParser(getopt.getOptarg(), 1);
                            searchFilter.setFilesizeCompare(numberParser.getCompare());
                            searchFilter.setFilesize(numberParser.getValue());
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = getopt.getOptind();
            while (n < stringArray.length - 1) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(" ");
                ++n;
            }
            String string = stringBuffer.toString().trim();
            if (string.length() == 0) {
                return false;
            }
            searchFilter.setSearchText(string);
            SearchManager.this.search(searchFilter);
            return true;
        }

        public SearchCmd() {
            this.putValue("cmd", new String[]{"search"});
            this.putValue("parameter", "[-b [>|<|=]bitrate] [-s [>|<|=]size] query");
            this.putValue("shortHelp", "Search.");
        }
    }
}

