/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.client;

import java.util.StringTokenizer;
import xnap.plugin.nap.net.ServerVersion;
import xnap.plugin.nap.net.msg.client.ClientMessage;
import xnap.util.SearchFilter;

public class SearchRequestMessage
extends ClientMessage {
    public static final int TYPE = 200;

    public static String compareString(String string, int n, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" \"");
        switch (n) {
            case 1: {
                stringBuffer.append("AT LEAST");
                break;
            }
            case 3: {
                stringBuffer.append("EQUAL TO");
                break;
            }
            case 2: {
                stringBuffer.append("AT BEST");
                break;
            }
            default: {
                return "";
            }
        }
        stringBuffer.append("\" \"");
        stringBuffer.append(l);
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public static String mediaString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" TYPE ");
        switch (n) {
            case 1: {
                stringBuffer.append("audio");
                stringBuffer.append(" TYPE mp3 ");
                break;
            }
            case 2: {
                stringBuffer.append("video");
                break;
            }
            case 3: {
                stringBuffer.append("image");
                break;
            }
            case 4: {
                stringBuffer.append("application");
                break;
            }
            case 5: {
                stringBuffer.append("text");
                break;
            }
            default: {
                return "";
            }
        }
        return stringBuffer.toString();
    }

    public static String getSearchText(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("-")) {
                if (!bl) continue;
                stringBuffer.append(string2);
                stringBuffer.append(" ");
                continue;
            }
            if (bl) continue;
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.insert(0, bl ? " FILENAME EXCLUDES \"" : " FILENAME CONTAINS \"");
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public SearchRequestMessage(SearchFilter searchFilter, int n) {
        super(200);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SearchRequestMessage.getSearchText(searchFilter.getSearchText(), false));
        stringBuffer.append(" MAX_RESULTS ");
        stringBuffer.append(n);
        if (searchFilter.getMediaType() == 0 || searchFilter.getMediaType() == 1) {
            stringBuffer.append(SearchRequestMessage.compareString("BITRATE", searchFilter.getBitrateCompare(), searchFilter.getBitrate()));
        }
        this.data = stringBuffer.toString().trim();
        stringBuffer.append(SearchRequestMessage.mediaString(searchFilter.getMediaType()));
        stringBuffer.append(SearchRequestMessage.getSearchText(searchFilter.getSearchText(), true));
        stringBuffer.append(SearchRequestMessage.compareString("SIZE", searchFilter.getFilesizeCompare(), searchFilter.getFilesize()));
        this.add(ServerVersion.OPENNAP044, stringBuffer.toString().trim());
        this.add(ServerVersion.SLAVANAP1, stringBuffer.toString().trim());
        this.add(ServerVersion.SLAVANAP2, stringBuffer.toString().trim());
    }
}

