/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.net.AbstractRunnable;
import xnap.net.IChannel;
import xnap.net.IChatServer;
import xnap.net.IUser;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.Browse;
import xnap.plugin.nap.net.NapListener;
import xnap.plugin.nap.net.Packet;
import xnap.plugin.nap.net.Search;
import xnap.plugin.nap.net.SearchResult;
import xnap.plugin.nap.net.SearchResultCache;
import xnap.plugin.nap.net.ServerVersion;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.MessageStrings;
import xnap.plugin.nap.net.msg.client.ClientMessage;
import xnap.plugin.nap.net.msg.client.ListChannelsMessage;
import xnap.plugin.nap.net.msg.client.NickCheckMessage;
import xnap.plugin.nap.net.msg.server.BrowseResponseMessage;
import xnap.plugin.nap.net.msg.server.EndBrowseMessage;
import xnap.plugin.nap.net.msg.server.EndSearchMessage;
import xnap.plugin.nap.net.msg.server.ErrorMessage;
import xnap.plugin.nap.net.msg.server.InvalidMessageException;
import xnap.plugin.nap.net.msg.server.InvalidNickMessage;
import xnap.plugin.nap.net.msg.server.LoginAckMessage;
import xnap.plugin.nap.net.msg.server.LoginErrorMessage;
import xnap.plugin.nap.net.msg.server.MessageFactory;
import xnap.plugin.nap.net.msg.server.NickAlreadyRegisteredMessage;
import xnap.plugin.nap.net.msg.server.NickNotRegisteredMessage;
import xnap.plugin.nap.net.msg.server.SearchResponseMessage;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.net.msg.server.ServerStatsMessage;
import xnap.plugin.nap.util.Channel;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.ChatManager;
import xnap.util.Preferences;
import xnap.util.PriorityQueue;
import xnap.util.Range;
import xnap.util.prefs.StringValidator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Server
extends AbstractRunnable
implements IChatServer,
Runnable {
    public static final int SOCKET_TIMEOUT = 1000;
    public static final int MAX_RETRY_ON_CONNECTION_REFUSED = 3;
    public static final int STATUS_NOT_CONNECTED = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_CONNECTED = 2;
    public static final int STATUS_LOGIN_FAILED = 4;
    public static final int STATUS_FAILED = 5;
    public static final int STATUS_ERROR = 6;
    public static final int STATUS_NEW_STATS = 7;
    public static final String[] STATUS_MSGS = new String[]{"", Plugin.tr("connecting") + "...", Plugin.tr("connected"), Plugin.tr("login failed"), Plugin.tr("failed"), Plugin.tr("connected"), Plugin.tr("error")};
    protected static Logger logger;
    protected static Preferences prefs;
    private String remoteHost;
    private int remotePort;
    private String remoteIP;
    private String network;
    private int userCount;
    private String username;
    private String password;
    private String email;
    private boolean newUser;
    private int fileCount;
    private int fileSize;
    private int ping;
    private boolean temporay;
    private boolean redirector;
    private String redirectedHost;
    private int redirectedPort;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private long lastLogin;
    private NapListener listener;
    protected Search currentSearch;
    protected Browse currentBrowse;
    protected String lastError;
    private PriorityQueue searchQueue;
    private LinkedList browseQueue;
    private SearchResultCache searchCache;
    private long lastSearch;
    protected Hashtable users;
    protected int searchCount;
    protected Hashtable channels;
    protected ServerVersion version;
    protected Range shared;
    private int maxPacketsPerTick;
    private long tickLength;
    private long writeTickPacketCount;
    private long writeTickStart;
    static /* synthetic */ Class class$xnap$plugin$nap$net$Server;

    public boolean isConnected() {
        boolean bl = false;
        if (this.status == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isLoginCustomized() {
        boolean bl = false;
        if (this.username != null || this.password != null || this.email != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isReady() {
        boolean bl = false;
        if (this.status == 1 || this.status == 2) {
            bl = true;
        }
        return bl;
    }

    protected String getStatusMsg(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(STATUS_MSGS[n]);
        if (n == 2) {
            if (this.getLocalPort() == 0) {
                stringBuffer.append(" (firewalled)");
            }
            stringBuffer.append(" [");
            stringBuffer.append(this.searchCount);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public IChannel create(String string) {
        Channel channel = new Channel(this, string, "", 0);
        this.channels.put(string, channel);
        return channel;
    }

    public boolean equals(Object object) {
        if (object instanceof Server) {
            Server server = (Server)object;
            boolean bl = false;
            if (this.getHost().equalsIgnoreCase(server.getHost()) && this.getPort() == server.getPort()) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public Channel getChannel(String string) {
        Channel channel = (Channel)this.channels.get(string);
        if (channel == null) {
            channel = new Channel(this, string, "", 0);
            this.channels.put(string, channel);
        }
        return channel;
    }

    public IChannel[] getChannels() {
        Object[] objectArray = this.channels.values().toArray();
        IChannel[] iChannelArray = new IChannel[objectArray.length];
        System.arraycopy(objectArray, 0, iChannelArray, 0, iChannelArray.length);
        return iChannelArray;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getEmail() {
        return this.email != null ? this.email : prefs.getEmail();
    }

    public void setEmail(String string) {
        if (string != null) {
            try {
                StringValidator.EMAIL.validate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        this.email = string;
    }

    public String getHost() {
        return this.remoteHost;
    }

    public void setHost(String string) {
        this.remoteHost = string;
    }

    public void setIP(String string) {
        this.remoteIP = string;
    }

    public String getIP() {
        return this.remoteIP;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public NapListener getListener() {
        return this.listener;
    }

    public void setListener(NapListener napListener) {
        this.listener = napListener;
    }

    public int getLocalPort() {
        int n = 0;
        if (this.listener != null) {
            n = this.listener.getPort();
        }
        return n;
    }

    public String getName() {
        String string = this.getNetwork();
        if (string.length() > 0) {
            return string;
        }
        return this.getHost();
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String string) {
        this.network = string;
    }

    public String getPassword() {
        return this.password != null ? this.password : prefs.getPassword();
    }

    public void setPassword(String string) {
        if (string != null) {
            try {
                StringValidator.REGULAR_STRING.validate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        this.password = string;
    }

    public int getPort() {
        return this.remotePort;
    }

    public void setPort(int n) {
        this.remotePort = n;
    }

    public String getRedirectedHost() {
        return this.redirectedHost;
    }

    public int getRedirectedPort() {
        return this.redirectedPort;
    }

    public Range getShared() {
        return (Range)this.shared.clone();
    }

    public void setShared(Range range) {
        this.shared = (Range)range.clone();
    }

    public boolean isTemporary() {
        return this.temporay;
    }

    public boolean isRedirector() {
        return this.redirector;
    }

    public void setTemporary(boolean bl) {
        this.temporay = bl;
    }

    public User getUser(String string) {
        User user = (User)this.users.get(string);
        if (user == null) {
            user = new User(string, this);
            this.users.put(string, user);
        }
        return user;
    }

    public IUser getUser() {
        return this.getUser(this.getUsername());
    }

    public int getUserCount() {
        return this.userCount;
    }

    public String getUsername() {
        return this.username != null ? this.username : prefs.getUsername();
    }

    public void setUsername(String string) {
        if (string != null) {
            try {
                StringValidator.REGULAR_STRING.validate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        this.username = string;
    }

    public ServerVersion getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = new ServerVersion(string);
    }

    public void setRedirectedHost(String string) {
        this.redirectedHost = string;
    }

    public void setRedirectedPort(int n) {
        this.redirectedPort = n;
    }

    public void setRedirector(boolean bl) {
        this.redirector = bl;
    }

    public void login(boolean bl) {
        if (!this.canStart()) {
            return;
        }
        this.lastLogin = System.currentTimeMillis();
        this.setStatus(1);
        this.newUser = bl;
        this.runner = new Thread((Runnable)this, "OpenNapServer " + this.getHost());
        this.runner.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fetchHost(String var1_1, int var2_2) throws IOException {
        var3_3 = null;
        var4_4 = null;
        try {
            var3_3 = new Socket(var1_1, var2_2);
            var4_4 = new BufferedInputStream(var3_3.getInputStream());
            var9_5 = new byte[1024];
            var10_6 = var4_4.read(var9_5, 0, 1024);
            if (var10_6 <= 0 || (var12_8 = new StringTokenizer(var11_7 = new String(var9_5, 0, var10_6 - 1), ":")).countTokens() != 2) ** GOTO lbl-1000
            try {
                this.setRedirectedHost(var12_8.nextToken());
                this.setRedirectedPort(Integer.parseInt(var12_8.nextToken()));
                var7_9 = true;
            }
            catch (NumberFormatException var13_16) {
                ** GOTO lbl-1000
            }
            var6_10 = null;
        }
        catch (Throwable var5_17) {
            var6_11 = null;
            try {
                if (var4_4 != null) {
                    var4_4.close();
                }
                if (var3_3 == null) throw var5_17;
                var3_3.close();
                throw var5_17;
            }
            catch (IOException var8_14) {
                // empty catch block
            }
            throw var5_17;
        }
        try {}
        catch (IOException var8_13) {
            // empty catch block
            return var7_9;
        }
        if (var4_4 != null) {
            var4_4.close();
        }
        if (var3_3 == null) return var7_9;
        var3_3.close();
        return var7_9;
lbl-1000:
        // 2 sources

        {
            var6_12 = null;
        }
        try {}
        catch (IOException var8_15) {
            return false;
        }
        if (var4_4 != null) {
            var4_4.close();
        }
        if (var3_3 == null) return false;
        var3_3.close();
        return false;
    }

    public void logout() {
        this.die(0);
    }

    public void messageReceived(String string, String string2, String string3) {
        Channel channel = (Channel)this.channels.get(string);
        if (channel != null) {
            channel.messageReceived(this.getUser(string2), string3);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getHost());
            stringBuffer.append(" (");
            stringBuffer.append(string);
            stringBuffer.append(") : ");
            stringBuffer.append(string3);
            ChatManager.getInstance().globalMessageReceived(stringBuffer.toString());
        }
    }

    public synchronized void addBrowse(Browse browse) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("server disconnected");
        }
        this.browseQueue.add(browse);
        this.allowBrowse();
    }

    public synchronized void addSearch(Search search) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("server disconnected");
        }
        if (this.currentSearch != null && this.currentSearch.equals(search)) {
            Iterator iterator = this.currentSearch.getResults().iterator();
            while (iterator.hasNext()) {
                search.add((SearchResult)iterator.next());
            }
            this.currentSearch.addPeer(search);
        } else {
            int n = this.searchQueue.indexOf(search);
            if (n != -1) {
                ((Search)this.searchQueue.get(n)).addPeer(search);
            } else if (!this.useSearchCache(search)) {
                this.searchQueue.add(search, search.getPriority());
                this.allowSearch();
            }
        }
    }

    public void waitUntilReadyToSend() {
        long l = this.tickLength - (System.currentTimeMillis() - this.writeTickStart);
        if (l <= 0L) {
            this.writeTickStart = System.currentTimeMillis();
            this.writeTickPacketCount = 0L;
        } else if (this.writeTickPacketCount >= (long)this.maxPacketsPerTick) {
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void removeBrowse(Browse browse) {
        this.browseQueue.remove(browse);
    }

    public synchronized void removeSearch(Search search) {
        this.searchQueue.remove(search);
    }

    public void send(ClientMessage clientMessage) throws IOException {
        this.sendPacket(new Packet(clientMessage.getType(), clientMessage.getData(this.version)));
    }

    public void updateChannels() throws IOException {
        MessageHandler.send(this, new ListChannelsMessage());
    }

    private final ServerMessage getNextMessage() {
        Packet packet = null;
        while (!this.die) {
            try {
                packet = this.recvPacket();
                return MessageFactory.create(this, packet.id, packet.data);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                logger.error(this.getHost() + ':' + this.getPort() + " getNextMessage: " + iOException.getMessage());
                logger.debug(this.getHost() + ':' + this.getPort() + " getNextMessage ", iOException);
                if (this.getStatus() == 1) {
                    this.die(4, this.lastError);
                    continue;
                }
                this.die(5, this.lastError);
            }
            catch (InvalidMessageException invalidMessageException) {
                logger.error(this.getHost() + ':' + this.getPort() + " getNextMessage: " + packet, invalidMessageException);
            }
        }
        return null;
    }

    private final byte[] read(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                int n3 = this.in.read(byArray, n2, n - n2);
                if (n3 == -1) {
                    throw new IOException("Connection closed");
                }
                n2 += n3;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!this.die) continue;
                throw interruptedIOException;
            }
        }
        return byArray;
    }

    private final Packet recvPacket() throws IOException {
        String string = "";
        byte[] byArray = this.read(4);
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = (char)-1 & (n2 << 8 | n);
        n = 0xFF & byArray[2];
        n2 = 0xFF & byArray[3];
        int n4 = (char)-1 & (n2 << 8 | n);
        if (n3 > 0) {
            string = new String(this.read(n3));
        }
        logger.debug("< " + this.getHost() + ':' + this.getPort() + ' ' + MessageFactory.getMessageName(n4) + '(' + n4 + ") " + string);
        return new Packet(n4, string);
    }

    private final void sendPacket(Packet packet) throws IOException {
        logger.debug("> " + this.getHost() + ':' + this.getPort() + ' ' + MessageStrings.getMessageName(packet.id) + '(' + packet.id + ") " + packet.data);
        try {
            int n = packet.data.getBytes().length;
            byte[] byArray = new byte[4 + n];
            short s = (short)packet.id;
            short s2 = (short)n;
            byArray[0] = (byte)s2;
            byArray[1] = (byte)(s2 >> 8);
            byArray[2] = (byte)s;
            byArray[3] = (byte)(s >> 8);
            System.arraycopy(packet.data.getBytes(), 0, byArray, 4, n);
            this.out.write(byArray);
            this.out.flush();
            ++this.writeTickPacketCount;
        }
        catch (NullPointerException nullPointerException) {
            logger.debug(this.getHost() + ':' + this.getPort() + " sendPacket " + packet, nullPointerException);
            if (this.getStatus() == 1) {
                this.die(4, nullPointerException.getMessage());
            } else {
                this.die(5, nullPointerException.getMessage());
            }
            throw new IOException("Internal error");
        }
        catch (IOException iOException) {
            logger.debug(this.getHost() + ':' + this.getPort() + " sendPacket " + packet, iOException);
            if (this.getStatus() == 1) {
                this.die(4, iOException.getMessage());
            } else {
                this.die(5, iOException.getMessage());
            }
            throw iOException;
        }
    }

    private final void connect(String string, String string2, int n) throws IOException {
        this.socket = null;
        if (string != null) {
            try {
                this.socket = new Socket(string, n);
            }
            catch (IOException iOException) {
                this.setIP(null);
            }
        }
        if (this.socket == null) {
            int n2 = 0;
            while (n2 < 3 && this.socket == null) {
                try {
                    this.socket = new Socket(string2, n);
                }
                catch (ConnectException connectException) {
                    if (n2 == 2) {
                        throw connectException;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        this.socket.setSoTimeout(1000);
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.out = this.socket.getOutputStream();
        this.setStatus(1, XNap.tr("logging in") + "...");
        try {
            if (this.newUser) {
                this.send(new NickCheckMessage(this.getUsername()));
            } else {
                MessageHandler.login(this, false);
            }
        }
        catch (IOException iOException) {
            this.die(4, XNap.tr("login failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block59: {
            Thread.currentThread().setPriority(1);
            this.die = false;
            this.currentBrowse = null;
            this.currentSearch = null;
            this.searchCount = 0;
            this.lastError = null;
            this.searchCache.clear();
            this.users.clear();
            try {
                if (this.isRedirector()) {
                    if (this.fetchHost(this.getHost(), this.getPort())) {
                        this.connect(null, this.getRedirectedHost(), this.getRedirectedPort());
                        break block59;
                    } else {
                        this.die(5, "invalid response");
                    }
                    break block59;
                }
                this.connect(this.remoteIP, this.getHost(), this.getPort());
            }
            catch (ConnectException var1_1) {
                this.die(5, XNap.tr("connection refused"));
            }
            catch (UnknownHostException var1_2) {
                this.die(6, XNap.tr("unknown host"));
            }
            catch (IOException var1_3) {
                this.die(6, XNap.tr("error: {0}", var1_3.getLocalizedMessage()));
            }
        }
        while (!this.die) {
            var1_4 = this.getNextMessage();
            if (this.die) break;
            if (var1_4 instanceof NickNotRegisteredMessage) {
                if (this.getStatus() == 1) {
                    try {
                        MessageHandler.login(this, true);
                    }
                    catch (IOException var2_7) {
                        this.setStatus(4, var2_7.getMessage());
                    }
                }
            } else if (var1_4 instanceof NickAlreadyRegisteredMessage) {
                this.die(4, Plugin.tr("nick already registered"));
            } else if (var1_4 instanceof InvalidNickMessage) {
                this.die(4, Plugin.tr("invalid nick"));
            } else if (var1_4 instanceof LoginAckMessage) {
                if (this.getStatus() == 1) {
                    this.setStatus(2);
                }
            } else if (var1_4 instanceof LoginErrorMessage) {
                this.die(4, ((LoginErrorMessage)var1_4).message);
            } else if (var1_4 instanceof BrowseResponseMessage) {
                if (this.currentBrowse != null) {
                    this.currentBrowse.add((BrowseResponseMessage)var1_4);
                }
            } else if (var1_4 instanceof EndBrowseMessage) {
                if (this.currentBrowse != null) {
                    this.currentBrowse.finished();
                    this.currentBrowse = null;
                    this.updateStatus();
                }
            } else if (var1_4 instanceof SearchResponseMessage) {
                if (this.currentSearch != null) {
                    this.currentSearch.add((SearchResponseMessage)var1_4);
                }
            } else if (var1_4 instanceof EndSearchMessage) {
                if (this.currentSearch != null) {
                    var2_6 = this;
                    synchronized (var2_6) {
                        this.currentSearch.finished();
                        if (this.currentSearch.getPriority() == 1) {
                            this.searchCache.put(this.currentSearch.getRequest(), this.currentSearch.getResults());
                        }
                        this.currentSearch = null;
                        // MONITOREXIT @DISABLED, blocks:[34, 2, 8, 41, 42, 44, 46, 48, 17, 50, 52, 54, 56] lbl78 : MonitorExitStatement: MONITOREXIT : var2_6
                        this.updateStatus();
                    }
                }
            } else if (var1_4 instanceof ServerStatsMessage) {
                var2_6 = (ServerStatsMessage)var1_4;
                this.userCount = var2_6.userCount;
                this.fileCount = var2_6.fileCount;
                this.fileSize = var2_6.fileSize;
                this.fireStatusChange(this.status, 7);
            } else if (var1_4 instanceof ErrorMessage) {
                this.lastError = ((ErrorMessage)var1_4).message;
                if (this.lastError.startsWith("You have been killed by server") || this.lastError.startsWith("You were killed by server")) {
                    this.setStatus(6, this.lastError);
                }
            }
            MessageHandler.handle((ServerMessage)var1_4);
            this.allowSearch();
            this.allowBrowse();
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException var1_5) {}
        var1_4 = this;
        synchronized (var1_4) {
            if (this.currentBrowse != null) {
                this.currentBrowse.failed(Plugin.tr("Server disconnected"));
            }
            var3_8 = this.browseQueue.iterator();
            while (true) {
                if (!var3_8.hasNext()) {
                    this.browseQueue.clear();
                    break;
                }
                ((Browse)var3_8.next()).failed(Plugin.tr("Server disconnected"));
            }
        }
        var1_4 = this;
        synchronized (var1_4) {
            if (this.currentSearch != null) {
                this.currentSearch.failed(Plugin.tr("Server disconnected"));
            }
            var3_8 = this.searchQueue.toArray();
            var4_9 = 0;
            if (true) ** GOTO lbl133
            do {
                ((Search)var3_8[var4_9]).failed(Plugin.tr("Server disconnected"));
                ++var4_9;
lbl133:
                // 2 sources

            } while (var4_9 < ((Object[])var3_8).length);
            this.searchQueue.clear();
        }
        var3_8 = this.channels.values().iterator();
        while (var3_8.hasNext()) {
            ((IChannel)var3_8.next()).close();
        }
        Server.logger.debug(this.toString() + " has died");
        this.died();
    }

    private final void updateStatus() {
        if (this.status == 2) {
            StringBuffer stringBuffer = new StringBuffer(this.getStatusMsg(this.status));
            if (this.currentSearch != null) {
                stringBuffer.append(", searching");
            }
            if (this.searchQueue.size() > 0) {
                stringBuffer.append(", ");
                stringBuffer.append(this.searchQueue.size());
                stringBuffer.append(" searches pending");
            }
            if (this.currentBrowse != null) {
                stringBuffer.append(", browsing");
            }
            this.setStatus(this.status, stringBuffer.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHost());
        stringBuffer.append(":");
        stringBuffer.append(this.getPort());
        String string = this.getNetwork();
        if (string != null && !string.equals("")) {
            stringBuffer.append(" (");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private final synchronized void allowBrowse() {
        if (this.currentBrowse != null || this.browseQueue.size() == 0) {
            return;
        }
        this.currentBrowse = (Browse)this.browseQueue.removeFirst();
        this.currentBrowse.start();
        this.updateStatus();
    }

    private final synchronized void allowSearch() {
        if (this.currentSearch != null || this.searchQueue.size() == 0) {
            return;
        }
        Search search = (Search)this.searchQueue.peek();
        if (this.useSearchCache(search)) {
            this.searchQueue.pop();
            return;
        }
        this.searchQueue.pop();
        this.currentSearch = search;
        this.lastSearch = System.currentTimeMillis();
        ++this.searchCount;
        this.currentSearch.start();
        this.updateStatus();
    }

    private final synchronized boolean useSearchCache(Search search) {
        if (search.getPriority() < 2) {
            this.searchCache.purge();
            LinkedList linkedList = this.searchCache.get(search.getRequest());
            if (linkedList != null) {
                logger.debug("nap server: reuse of searchresults");
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    SearchResult searchResult = (SearchResult)iterator.next();
                    search.add(searchResult);
                }
                search.close();
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.remoteIP = null;
        this.userCount = -1;
        this.username = null;
        this.password = null;
        this.email = null;
        this.fileCount = -1;
        this.fileSize = -1;
        this.ping = -1;
        this.temporay = false;
        this.redirector = false;
        this.lastLogin = 0L;
        this.listener = null;
        this.currentSearch = null;
        this.currentBrowse = null;
        this.searchQueue = new PriorityQueue();
        this.browseQueue = new LinkedList();
        this.searchCache = new SearchResultCache();
        this.lastSearch = 0L;
        this.users = new Hashtable();
        this.searchCount = 0;
        this.channels = new Hashtable();
        this.version = ServerVersion.UNKNOWN;
        this.maxPacketsPerTick = NapPreferences.getInstance().getMaxPacketsPerTick();
        this.tickLength = NapPreferences.getInstance().getTickLength();
        this.writeTickPacketCount = 0L;
        this.writeTickStart = 0L;
    }

    public Server(String string, String string2, int n, String string3, int n2, int n3, int n4) {
        this.this();
        this.status = 0;
        this.remoteHost = string;
        this.remoteIP = string2;
        this.remotePort = n;
        this.network = string3;
        this.userCount = n4;
        this.fileCount = n2;
        this.fileSize = n3;
    }

    public Server(String string, int n, String string2) {
        this(string, null, n, string2, -1, -1, -1);
    }

    public Server(String string, int n) {
        this(string, n, "");
    }

    public Server() {
        this("", 8888);
    }

    static {
        Class clazz = class$xnap$plugin$nap$net$Server;
        if (clazz == null) {
            clazz = class$xnap$plugin$nap$net$Server = Server.class$("[Lxnap.plugin.nap.net.Server;", false);
        }
        logger = Logger.getLogger(clazz);
        prefs = Preferences.getInstance();
    }
}

