/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.gui.table;

import java.util.ArrayList;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.LinkSpeedCellRenderer;
import xnap.gui.table.NumberCellRenderer;
import xnap.gui.table.TimeCellRenderer;
import xnap.net.IUser;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.server.MessageListener;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.net.msg.server.WhoisResponseMessage;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.LinkSpeed;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WhoisTableModel
extends AbstractDynamicTableModel
implements MessageListener {
    public static final int NAME = 0;
    public static final int SERVER = 1;
    public static final int FILE_COUNT = 2;
    public static final int LINK_SPEED = 3;
    public static final int LEVEL = 4;
    public static final int STATUS = 5;
    public static final int DOWNLOAD_COUNT = 6;
    public static final int UPLOAD_COUNT = 7;
    public static final int CLIENT_INFO = 8;
    public static final int LAST_SEEN = 9;
    public static final int CONNECT_DURATION = 10;
    protected Column[] columns;
    private ArrayList rows;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;

    public void add(User user) {
        int n = this.rows.indexOf(new MyUser(user));
        if (n == -1) {
            this.rows.add(user);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        } else {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void clear() {
        int n = this.rows.size() - 1;
        this.rows.clear();
        this.fireTableRowsDeleted(0, n);
    }

    public User get(int n) {
        return (User)this.rows.get(this.mapToIndex(n));
    }

    public Object get(int n, int n2) {
        if (n >= this.rows.size()) {
            return null;
        }
        User user = (User)this.rows.get(n);
        if (user == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return user.getName();
            }
            case 1: {
                return user.getServer().getHost() + ':' + user.getServer().getPort();
            }
            case 2: {
                return new Integer(user.getFileCount());
            }
            case 3: {
                return new LinkSpeed(user.getLinkSpeed()).toString();
            }
            case 4: {
                return user.getLevel();
            }
            case 5: {
                return IUser.STATUS_MSGS[user.getStatus()];
            }
            case 6: {
                return new Integer(user.getDownloadCount());
            }
            case 7: {
                return new Integer(user.getUploadCount());
            }
            case 8: {
                return user.getClientInfo();
            }
            case 9: {
                long l = user.getLastSeen();
                return new Long(l > 0L ? l : (long)-1);
            }
            case 10: {
                return new Integer(user.getConnectDuration());
            }
        }
        return "";
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String getTableName() {
        return XNap.tr("Whois Table");
    }

    public void messageReceived(ServerMessage serverMessage) {
        WhoisResponseMessage whoisResponseMessage = (WhoisResponseMessage)serverMessage;
        this.add(whoisResponseMessage.getServer().getUser(whoisResponseMessage.nick));
    }

    public void reload() {
        this.fireTableDataChanged();
    }

    public void remove(User user) {
        int n = this.rows.indexOf(user);
        if (n != -1) {
            this.rows.remove(user);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void set(Object object, int n, int n2) {
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Column[] columnArray = new Column[11];
        String string = Plugin.tr("User");
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = WhoisTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[0] = new Column(string, clazz);
        String string2 = Plugin.tr("Server");
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = WhoisTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[1] = new Column(string2, clazz2);
        String string3 = Plugin.tr("File Count");
        Class clazz3 = class$java$lang$Integer;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Integer = WhoisTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[2] = new Column(string3, clazz3, new NumberCellRenderer());
        String string4 = Plugin.tr("Link Speed");
        Class clazz4 = class$java$lang$String;
        if (clazz4 == null) {
            clazz4 = class$java$lang$String = WhoisTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[3] = new Column(string4, clazz4, new LinkSpeedCellRenderer());
        String string5 = Plugin.tr("Level");
        Class clazz5 = class$java$lang$String;
        if (clazz5 == null) {
            clazz5 = class$java$lang$String = WhoisTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[4] = new Column(string5, clazz5);
        String string6 = Plugin.tr("Status");
        Class clazz6 = class$java$lang$String;
        if (clazz6 == null) {
            clazz6 = class$java$lang$String = WhoisTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[5] = new Column(string6, clazz6);
        String string7 = Plugin.tr("Downloads");
        Class clazz7 = class$java$lang$Integer;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Integer = WhoisTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[6] = new Column(string7, clazz7, new NumberCellRenderer());
        String string8 = Plugin.tr("Upload");
        Class clazz8 = class$java$lang$Integer;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Integer = WhoisTableModel.class$("[Ljava.lang.Integer;", false);
        }
        columnArray[7] = new Column(string8, clazz8, new NumberCellRenderer());
        String string9 = Plugin.tr("Client");
        Class clazz9 = class$java$lang$String;
        if (clazz9 == null) {
            clazz9 = class$java$lang$String = WhoisTableModel.class$("[Ljava.lang.String;", false);
        }
        columnArray[8] = new Column(string9, clazz9);
        String string10 = Plugin.tr("Last Seen");
        Class clazz10 = class$java$lang$Long;
        if (clazz10 == null) {
            clazz10 = class$java$lang$Long = WhoisTableModel.class$("[Ljava.lang.Long;", false);
        }
        columnArray[9] = new Column(string10, clazz10, new TimeCellRenderer());
        String string11 = Plugin.tr("Online");
        Class clazz11 = class$java$lang$Long;
        if (clazz11 == null) {
            clazz11 = class$java$lang$Long = WhoisTableModel.class$("[Ljava.lang.Long;", false);
        }
        columnArray[10] = new Column(string11, clazz11, new TimeCellRenderer());
        this.columns = columnArray;
        this.rows = new ArrayList();
    }

    public WhoisTableModel() {
        super("whois", NapPreferences.getInstance());
        this.this();
        this.setColumns(this.columns);
        MessageHandler.subscribe(604, this);
    }

    class MyUser
    extends User {
        public boolean equals(Object object) {
            if (object != null && object instanceof User) {
                User user = (User)object;
                boolean bl = false;
                if (this.getName().equals(user.getName()) && this.getServer().equals(user.getServer())) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public MyUser(User user) {
            super(user.getName(), user.getServer());
        }
    }
}

