/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.tree;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import xnap.gui.tree.AbstractTreeModel;
import xnap.gui.tree.FileNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileTreeModel
extends AbstractTreeModel
implements Comparator {
    private Vector subRoots;
    private Hashtable subChildren;
    private File cachedDir;
    private boolean cacheSorted;
    private File[] cache;
    private boolean filterDotFiles;
    private boolean showFiles;

    public int compare(Object object, Object object2) {
        return object.toString().toLowerCase().compareTo(object2.toString().toLowerCase());
    }

    public boolean isLeaf(Object object) {
        return false;
    }

    public int getChildCount(Object object) {
        if (object instanceof File && ((File)object).canRead()) {
            return this.getSubDirs((File)object, false).length;
        }
        if (object instanceof String) {
            if (object.equals(this.root)) {
                return this.subRoots.size();
            }
            return ((Vector)this.subChildren.get(object)).size();
        }
        return 0;
    }

    public Object getChild(Object object, int n) {
        if (object instanceof File) {
            File[] fileArray = this.getSubDirs((File)object, true);
            if (fileArray == null || n >= fileArray.length) {
                return null;
            }
            return new FileNode(fileArray[n]);
        }
        if (object instanceof String) {
            if (object.equals(this.root) && n < this.subRoots.size()) {
                return this.subRoots.get(n);
            }
            Vector vector = (Vector)this.subChildren.get(object);
            if (n < vector.size()) {
                return vector.elementAt(n);
            }
            return null;
        }
        return null;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof File) {
            File[] fileArray = this.getSubDirs((File)object, true);
            if (fileArray == null) {
                return -1;
            }
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n] == object2) {
                    return n;
                }
                ++n;
            }
        } else if (object instanceof String) {
            if (object.equals(this.root)) {
                return this.subRoots.indexOf(object2);
            }
            return ((Vector)this.subChildren.get(object)).indexOf(object2);
        }
        return -1;
    }

    private final File[] getSubDirs(File file, boolean bl) {
        if (file == this.cachedDir && this.cacheSorted == bl) {
            return this.cache;
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        if (fileArray != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (!(!fileArray[n2].isDirectory() || this.filterDotFiles && fileArray[n2].getName().startsWith("."))) {
                    fileArray[n] = fileArray[n2];
                    ++n;
                }
                ++n2;
            }
        }
        this.cache = new File[n];
        if (n > 0) {
            System.arraycopy(fileArray, 0, this.cache, 0, n);
            if (bl) {
                Arrays.sort(this.cache, this);
            }
        }
        this.cachedDir = file;
        this.cacheSorted = bl;
        return this.cache;
    }

    public void addSubRoot(String string) {
        if (this.subRoots.contains(string)) {
            return;
        }
        this.subRoots.add(string);
        this.subChildren.put(string, new Vector());
        Object[] objectArray = new Object[]{this.root};
        int[] nArray = new int[]{this.subRoots.size() - 1};
        Object[] objectArray2 = new Object[]{string};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, objectArray, nArray, objectArray2));
    }

    public void addSubRoot(File file) {
        if (this.subRoots.contains(file)) {
            return;
        }
        this.subRoots.add(file);
        Object[] objectArray = new Object[]{this.root};
        int[] nArray = new int[]{this.subRoots.size() - 1};
        Object[] objectArray2 = new Object[]{file};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, objectArray, nArray, objectArray2));
    }

    public void removeSubRoots() {
        int n = 0;
        while (n < this.subRoots.size()) {
            this.subChildren.remove(this.subRoots.get(n));
            ++n;
        }
        this.subRoots.clear();
        Object[] objectArray = new Object[]{this.root};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, objectArray));
    }

    public void removeChildrenOfSubRoot(String string) {
        if (!this.subRoots.contains(string)) {
            return;
        }
        Vector vector = (Vector)this.subChildren.get(string);
        vector.removeAllElements();
        Object[] objectArray = new Object[]{this.root, string};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, objectArray));
    }

    public void addChildOfSubRoot(File file, String string) {
        this.addChildOfSubRoot(file, string, null);
    }

    public void addChildOfSubRoot(File file, String string, String string2) {
        this.addSubRoot(string);
        Vector vector = (Vector)this.subChildren.get(string);
        FileNode fileNode = new FileNode(file, true, string2);
        if (vector.contains(fileNode)) {
            return;
        }
        vector.add(fileNode);
        Object[] objectArray = new Object[]{this.root, string};
        int[] nArray = new int[]{vector.size() - 1};
        Object[] objectArray2 = new Object[]{file};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, objectArray, nArray, objectArray2));
    }

    public void removeChildOfSubRoot(File file, String string) {
        FileNode fileNode;
        if (!this.subRoots.contains(string)) {
            return;
        }
        Vector vector = (Vector)this.subChildren.get(string);
        int n = vector.indexOf(fileNode = new FileNode(file, true));
        if (n == -1) {
            return;
        }
        vector.remove(n);
        Object[] objectArray = new Object[]{this.root, string};
        int[] nArray = new int[]{n};
        Object[] objectArray2 = new Object[]{fileNode};
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, objectArray, nArray, objectArray2));
    }

    private final /* synthetic */ void this() {
        this.subChildren = new Hashtable();
        this.filterDotFiles = true;
        this.showFiles = false;
    }

    public FileTreeModel(String string, File[] fileArray) {
        super(string);
        this.this();
        if (fileArray != null) {
            this.subRoots = new Vector(fileArray.length);
            int n = 0;
            while (n < fileArray.length) {
                this.addSubRoot(fileArray[n]);
                ++n;
            }
        } else {
            this.subRoots = new Vector();
        }
    }

    public FileTreeModel(String string) {
        this(string, null);
    }
}

