/*
 * Decompiled with CFR 0.152.
 */
package xnap.cmdl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import xnap.cmdl.Completer;
import xnap.cmdl.ConsoleWriter;
import xnap.cmdl.IConsole;
import xnap.util.FileHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Console {
    private static Console singleton = new Console();
    private boolean prompting;
    private StringBuffer outputQueue;
    private IConsole handler;

    public static Console getInstance() {
        return singleton;
    }

    public void add(Process process) {
        this.add(process.getInputStream());
        this.add(process.getErrorStream());
    }

    public void add(InputStream inputStream) {
        Thread thread = new Thread((Runnable)new ConsoleWriter(inputStream), "ConsoleWriter");
        thread.start();
    }

    public void setConsole(IConsole iConsole) {
        this.handler = iConsole;
    }

    public boolean isEchoing() {
        boolean bl = false;
        if (this.handler != null) {
            bl = this.handler.isEchoing();
        }
        return bl;
    }

    public String readln(String string) {
        if (this.handler == null) {
            return null;
        }
        this.printQueue();
        this.prompting = true;
        String string2 = this.handler.readLine(string);
        this.prompting = false;
        return string2;
    }

    public void printFile(String string) {
        InputStream inputStream = FileHelper.getResourceAsStream(string);
        if (inputStream == null) {
            this.println("File " + string + " not found");
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (bufferedReader.ready()) {
                this.outputQueue.append(bufferedReader.readLine() + '\n');
            }
            this.printQueue();
        }
        catch (IOException iOException) {
            this.println("error: " + iOException.getMessage());
        }
    }

    private final void printQueue() {
        this.println(null);
    }

    public void println(String string) {
        if (this.handler == null) {
            return;
        }
        if (string != null) {
            this.outputQueue.append(string + '\n');
        }
        if (!this.prompting) {
            this.handler.printLine(this.outputQueue.toString());
            this.outputQueue.setLength(0);
        }
    }

    public Completer getCompleter() {
        return this.handler != null ? this.handler.getCompleter() : null;
    }

    private final /* synthetic */ void this() {
        this.prompting = false;
        this.outputQueue = new StringBuffer();
        this.handler = null;
    }

    private Console() {
        this.this();
    }
}

