/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fsp.fsplib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.sf.fsp.fsplib.FSPpacket;
import net.sf.fsp.fsplib.FSPprotection;
import net.sf.fsp.fsplib.FSPsession;
import net.sf.fsp.fsplib.FSPstat;
import net.sf.fsp.fsplib.FSPversion;

public class FSPutil {
    public static void download(FSPsession session, String filename, OutputStream os, long start_from, long byteswanted) throws IOException {
        FSPpacket pkt;
        byte[] fname = FSPutil.stringToASCIIZ(filename);
        do {
            pkt = session.interact((byte)66, start_from, fname, 0, fname.length, null, 0, 0);
            pkt.expect((byte)66);
            if (pkt.bb_len == 0) {
                return;
            }
            if ((long)pkt.bb_len > byteswanted && byteswanted >= 0L) {
                pkt.bb_len = (short)byteswanted;
            }
            os.write(pkt.buf, 0, pkt.bb_len);
            start_from += (long)pkt.bb_len;
        } while ((byteswanted -= (long)pkt.bb_len) != 0L);
    }

    public static void upload(FSPsession session, String filename, InputStream is, long timestamp) throws IOException {
        FSPpacket pkt;
        int br;
        byte[] buf = new byte[1024];
        byte[] fname = FSPutil.stringToASCIIZ(filename);
        long pos = 0L;
        boolean first = true;
        while ((br = is.read(buf)) > 0 || first) {
            first = false;
            pkt = session.interact((byte)67, pos, buf, 0, br, null, 0, 0);
            pkt.expect((byte)67);
            pos += (long)br;
        }
        buf = timestamp != 0L ? new byte[]{(byte)((timestamp /= 1000L) >>> 24 & 0xFFL), (byte)(timestamp >>> 16 & 0xFFL), (byte)(timestamp >>> 8 & 0xFFL), (byte)(timestamp & 0xFFL)} : new byte[]{};
        pkt = session.interact((byte)68, buf.length, fname, 0, fname.length, buf, 0, buf.length);
        pkt.expect((byte)68);
    }

    public static FSPstat stat(FSPsession session, String path) throws IOException {
        byte[] fname = FSPutil.stringToASCIIZ(path);
        FSPpacket pkt = session.interact((byte)77, 0L, fname, 0, fname.length, null, 0, 0);
        pkt.expect((byte)77);
        if (pkt.buf[8] == 0) {
            return null;
        }
        FSPstat stat = new FSPstat();
        stat.name = path;
        stat.lastmod = (pkt.buf[0] << 8 | pkt.buf[1] & 0xFF) << 16;
        stat.lastmod |= (long)((pkt.buf[2] & 0xFF) << 8 | pkt.buf[3] & 0xFF);
        stat.lastmod &= 0xFFFFFFFFL;
        stat.lastmod *= 1000L;
        stat.length = (pkt.buf[4] << 8 | pkt.buf[5] & 0xFF) << 16;
        stat.length |= (long)((pkt.buf[6] & 0xFF) << 8 | pkt.buf[7] & 0xFF);
        stat.length &= 0xFFFFFFFFL;
        stat.type = pkt.buf[8];
        return stat;
    }

    public static boolean statSupported(FSPsession session) throws IOException {
        byte[] fname = FSPutil.stringToASCIIZ("/");
        FSPpacket pkt = session.interact((byte)77, 0L, fname, 0, fname.length, null, 0, 0);
        return pkt.cmd == 77;
    }

    public static byte[] stringToASCIIZ(String filename) {
        if (filename == null) {
            return new byte[1];
        }
        byte[] fname = new byte[filename.length() + 1];
        System.arraycopy(filename.getBytes(), 0, fname, 0, filename.length());
        fname[fname.length - 1] = 0;
        return fname;
    }

    public static String[] list(FSPsession session, String directory) throws IOException {
        int i;
        byte[] fname = FSPutil.stringToASCIIZ(directory);
        Vector<String> dirlist = new Vector<String>(20);
        int pos = 0;
        block4: while (true) {
            FSPpacket pkt = session.interact((byte)65, pos, fname, 0, fname.length, null, 0, 0);
            pkt.expect((byte)65);
            if (pkt.bb_len == 0) break;
            pos += pkt.bb_len;
            i = 0;
            block5: while (true) {
                if (i >= pkt.bb_len - 9) continue block4;
                switch (pkt.buf[i + 8]) {
                    case 42: {
                        continue block4;
                    }
                    case 0: {
                        break block4;
                    }
                    default: {
                        int j = i += 9;
                        while (pkt.buf[j] != 0) {
                            ++j;
                        }
                        dirlist.addElement(new String(pkt.buf, i, j - i));
                        i = j + 1;
                        while (true) {
                            if ((i & 3) <= 0) continue block5;
                            ++i;
                        }
                    }
                }
                break;
            }
            break;
        }
        String[] list = new String[dirlist.size()];
        for (i = 0; i < dirlist.size(); ++i) {
            list[i] = (String)dirlist.elementAt(i);
        }
        return list;
    }

    public static FSPstat[] statlist(FSPsession session, String directory) throws IOException {
        int i;
        byte[] fname = FSPutil.stringToASCIIZ(directory);
        Vector<FSPstat> dirlist = new Vector<FSPstat>(20);
        int pos = 0;
        block4: while (true) {
            FSPpacket pkt = session.interact((byte)65, pos, fname, 0, fname.length, null, 0, 0);
            pkt.expect((byte)65);
            if (pkt.bb_len == 0) break;
            pos += pkt.bb_len;
            i = 0;
            block5: while (true) {
                if (i >= pkt.bb_len - 9) continue block4;
                switch (pkt.buf[i + 8]) {
                    case 42: {
                        continue block4;
                    }
                    case 0: {
                        break block4;
                    }
                    default: {
                        FSPstat stat = new FSPstat();
                        stat.lastmod = (pkt.buf[i] << 8 | pkt.buf[i + 1] & 0xFF) << 16;
                        stat.lastmod |= (long)((pkt.buf[i += 2] & 0xFF) << 8 | pkt.buf[i + 1] & 0xFF);
                        stat.lastmod &= 0xFFFFFFFFL;
                        stat.lastmod *= 1000L;
                        stat.length = (pkt.buf[i += 2] << 8 | pkt.buf[i + 1] & 0xFF) << 16;
                        stat.length |= (long)((pkt.buf[i += 2] & 0xFF) << 8 | pkt.buf[i + 1] & 0xFF);
                        i += 2;
                        stat.type = pkt.buf[i++];
                        int j = i;
                        while (pkt.buf[j] != 0) {
                            ++j;
                        }
                        stat.name = new String(pkt.buf, i, j - i);
                        dirlist.addElement(stat);
                        i = j + 1;
                        while (true) {
                            if ((i & 3) <= 0) continue block5;
                            ++i;
                        }
                    }
                }
                break;
            }
            break;
        }
        FSPstat[] list = new FSPstat[dirlist.size()];
        for (i = 0; i < dirlist.size(); ++i) {
            list[i] = (FSPstat)dirlist.elementAt(i);
        }
        return list;
    }

    public static FSPversion version(FSPsession session) throws IOException {
        FSPpacket pkt = session.interact((byte)16, 0L, null, 0, 0, null, 0, 0);
        pkt.expect((byte)16);
        FSPversion ver = new FSPversion(pkt);
        return ver;
    }

    public static boolean canUpload(FSPsession session, String filename) throws IOException {
        int n = filename.lastIndexOf(47);
        String dirname = n < 1 ? "/" : filename.substring(0, n);
        byte[] buf = FSPutil.stringToASCIIZ(dirname);
        FSPpacket pkt = session.interact((byte)71, 0L, buf, 0, buf.length, null, 0, 0);
        pkt.expect((byte)71);
        FSPprotection pro = new FSPprotection(pkt);
        if (pro.owner) {
            return true;
        }
        if (!pro.add) {
            return false;
        }
        return pro.delete || FSPutil.stat(session, filename) == null;
    }
}

