/*
 * Decompiled with CFR 0.152.
 */
package napkin.dev;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnQuadLineGenerator;
import napkin.DrawnShapeGenerator;
import napkin.NapkinConstants;
import napkin.NapkinUtil;
import napkin.RandomValue;
import napkin.RandomValueSource;
import napkin.dev.BoxTest;
import napkin.dev.CheckBoxTest;
import napkin.dev.CubicTest;
import napkin.dev.QuadTest;
import napkin.dev.RandomValueSpinner;

public class GeneratorTest
extends NapkinUtil
implements NapkinConstants {
    private static final double MARK_SIZE = 3.0;
    private static final int STD_LENGTH = 100;
    static final int SPACE = 50;
    static final int MIN_HEIGHT = 200;
    private static final Rectangle2D mark = new Rectangle2D.Double();
    static final DecimalFormat DECIMAL = new DecimalFormat("#0.09");
    private static Drawer currentDrawer;
    private static JCheckBox showControlPoints;
    private static JButton randomize;
    private static final Drawer[] drawers;
    static final RandomValueSource ZERO;
    static final ChangeListener REPAINT;
    static final ChangeListener NEWPOINTS;
    static final ActionListener REPAINT_ACTION;
    protected final RandomValue width = new RandomValue(1.0);
    protected final RandomValueSpinner widthSpin = new RandomValueSpinner("w", this.width, 0.0, 3.0, 20);

    public static void main(String[] args) {
        final JTabbedPane tabs = new JTabbedPane();
        for (int i = 0; i < drawers.length; ++i) {
            Drawer drawer = drawers[i];
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)drawer.getControls(), "Center");
            panel.add((Component)drawer.getDrawing(), "West");
            tabs.addTab(drawer.getName(), panel);
        }
        currentDrawer = drawers[0];
        tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                currentDrawer = drawers[tabs.getSelectedIndex()];
            }
        });
        tabs.setSelectedIndex(0);
        JFrame top = new JFrame("Drawing Test");
        top.getContentPane().add((Component)tabs, "Center");
        top.getContentPane().add((Component)GeneratorTest.displayControls(), "South");
        top.pack();
        top.show();
    }

    private static JPanel displayControls() {
        showControlPoints = new JCheckBox("Show control points", false);
        randomize = new JButton("Randomize");
        randomize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (currentDrawer != null) {
                    RandomValueSource[] sources = currentDrawer.getSpinners();
                    for (int i = 0; i < sources.length; ++i) {
                        sources[i].randomize();
                    }
                    currentDrawer.rebuild();
                }
            }
        });
        randomize.addChangeListener(REPAINT);
        JPanel displayControls = GeneratorTest.controlSet("Display", showControlPoints, randomize);
        return displayControls;
    }

    static JPanel controlSet(String label, JComponent v1) {
        return GeneratorTest.controlSet(label, new JComponent[]{v1});
    }

    static JPanel controlSet(String label, JComponent v1, JComponent v2) {
        return GeneratorTest.controlSet(label, new JComponent[]{v1, v2});
    }

    static JPanel controlSet(String label, JComponent v1, JComponent v2, JComponent v3) {
        return GeneratorTest.controlSet(label, new JComponent[]{v1, v2, v3});
    }

    private static JPanel controlSet(String label, JComponent[] cs) {
        JPanel controls = new JPanel();
        controls.setBorder(new TitledBorder(label));
        controls.setLayout(new BoxLayout(controls, 0));
        for (int i = 0; i < cs.length; ++i) {
            JComponent c = cs[i];
            if (c == null) continue;
            controls.add(c);
            if (!(c instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)c;
            button.addChangeListener(REPAINT);
        }
        return controls;
    }

    public static Graphics2D lineGraphics(Graphics2D orig, float w) {
        return NapkinUtil.lineGraphics(orig, w);
    }

    static Graphics2D markGraphics(Graphics2D orig) {
        if (!showControlPoints.isSelected()) {
            return null;
        }
        Graphics2D markG = (Graphics2D)orig.create();
        markG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        markG.setColor(Color.blue);
        markG.setStroke(new BasicStroke(0.25f));
        return markG;
    }

    static void mark(Graphics2D g, RandomValueSource vx, RandomValueSource vy, boolean left) {
        if (g == null) {
            return;
        }
        double d = 1.5;
        double x = NapkinUtil.leftRight(vx.get(), left);
        double y = vy.get();
        mark.setRect(x - d, y - d, 3.0, 3.0);
        g.setColor(Color.blue);
        g.fill(mark);
        double xMid = NapkinUtil.leftRight(vx.getMid(), left);
        double xRange = vx.getRange();
        double yMid = vy.getMid();
        double yRange = vy.getRange();
        mark.setRect(xMid - xRange, yMid - yRange, xRange * 2.0, yRange * 2.0);
        g.setColor(Color.red);
        g.draw(mark);
    }

    static void mark(Graphics2D g, RandomValueSource vx, RandomValueSource vy, RandomValueSource vw, RandomValueSource vh) {
        if (g == null) {
            return;
        }
        g.draw(new Rectangle2D.Double(vx.getMid() - vx.getRange(), vy.getMid() - vy.getRange(), vw.getMid() + vw.getRange(), vh.getMid() + vh.getRange()));
        g.draw(new Rectangle2D.Double(vx.getMid() + vx.getRange(), vy.getMid() + vy.getRange(), vw.getMid() - vw.getRange(), vh.getMid() - vh.getRange()));
    }

    static {
        ZERO = new RandomValue(0.0);
        REPAINT = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (currentDrawer != null) {
                    currentDrawer.getDrawing().repaint();
                }
            }
        };
        NEWPOINTS = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (currentDrawer != null) {
                    currentDrawer.rebuild();
                    REPAINT.stateChanged(null);
                }
            }
        };
        REPAINT_ACTION = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                REPAINT.stateChanged(null);
            }
        };
        CubicTest cubic = new CubicTest();
        QuadTest quad = new QuadTest();
        BoxTest box = new BoxTest((DrawnCubicLineGenerator)cubic.getGenerator(), (DrawnQuadLineGenerator)quad.getGenerator());
        CheckBoxTest checkBox = new CheckBoxTest();
        drawers = new Drawer[]{cubic, quad, box, checkBox};
    }

    static interface Drawer {
        public JComponent getDrawing();

        public JComponent getControls();

        public DrawnShapeGenerator getGenerator();

        public RandomValueSource[] getSpinners();

        public String getName();

        public void rebuild();
    }
}

