/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicViewportUI;
import napkin.NapkinConstants;
import napkin.NapkinUtil;

public class NapkinViewportUI
extends BasicViewportUI
implements NapkinConstants {
    private int revertScrollMode;
    private static final NapkinViewportUI napkinViewportUI = new NapkinViewportUI();
    private JViewport viewport;

    public static ComponentUI createUI(JComponent c) {
        return NapkinUtil.uiFor(c, napkinViewportUI);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
        this.viewport = (JViewport)c;
        this.forceScrollMode();
    }

    private void forceScrollMode() {
        this.revertScrollMode = this.viewport.getScrollMode();
        this.viewport.setScrollMode(0);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        if (this.revertScrollMode != this.viewport.getScrollMode()) {
            this.viewport.setScrollMode(this.revertScrollMode);
        }
        super.uninstallUI(c);
    }

    public void update(Graphics g, JComponent c) {
        g = NapkinUtil.defaultGraphics(g, c);
        NapkinUtil.background(g, c);
        if (this.viewport.getScrollMode() != 0) {
            this.forceScrollMode();
        }
        super.update(g, c);
        NapkinUtil.finishGraphics(g, c);
    }
}

