/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import napkin.NapkinConstants;
import napkin.NapkinIconFactory;
import napkin.NapkinSplitPaneUI;
import napkin.NapkinUtil;

public class NapkinSplitPaneDivider
extends BasicSplitPaneDivider
implements NapkinConstants {
    private JButton left;
    private JButton right;
    public static final int ARROW_SIZE = 5;
    public static final int SIZE = 9;
    static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);

    public NapkinSplitPaneDivider(NapkinSplitPaneUI ui) {
        super(ui);
    }

    public void update(Graphics g) {
        g = NapkinUtil.defaultGraphics(g, this.splitPane);
        NapkinUtil.background(g, this.splitPane);
        super.update(g);
        NapkinUtil.finishGraphics(g, this.splitPane);
    }

    protected JButton createLeftOneTouchButton() {
        int dir = this.orientation == 1 ? 7 : 1;
        this.left = this.createOneTouchButton(dir);
        return this.left;
    }

    protected JButton createRightOneTouchButton() {
        int dir = this.orientation == 1 ? 3 : 5;
        this.right = this.createOneTouchButton(dir);
        return this.right;
    }

    protected JButton createOneTouchButton(int dir) {
        JButton b = NapkinUtil.createArrowButton(dir, 5);
        b.setFocusable(false);
        b.setMinimumSize(new Dimension(9, 9));
        b.setCursor(DEFAULT_CURSOR);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    protected void setOrientation(int orientation) {
        if (this.left == null) {
            return;
        }
        if (orientation == 1) {
            this.left.setIcon(NapkinIconFactory.createArrowIcon(7, 5));
            this.right.setIcon(NapkinIconFactory.createArrowIcon(3, 5));
        } else {
            this.left.setIcon(NapkinIconFactory.createArrowIcon(1, 5));
            this.right.setIcon(NapkinIconFactory.createArrowIcon(5, 5));
        }
    }
}

