/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import napkin.DrawnShapeHolder;
import napkin.DrawnTabGenerator;
import napkin.NapkinConstants;

public class DrawnTabHolder
extends DrawnShapeHolder
implements NapkinConstants {
    private int tabPlacement;
    private int x;
    private int y;
    private int w;
    private int h;
    private final Point2D breakBeg = new Point2D.Double();
    private final Point2D breakEnd = new Point2D.Double();

    public DrawnTabHolder(int tabPlacement) {
        super(DrawnTabGenerator.generatorFor(tabPlacement));
    }

    public void shapeUpToDate(int tabPlacement, int x, int y, int w, int h) {
        if (tabPlacement == this.tabPlacement && w == this.w && h == this.h && this.x == x && this.y == y) {
            return;
        }
        if (tabPlacement != this.tabPlacement) {
            this.gen = DrawnTabGenerator.generatorFor(tabPlacement);
        }
        AffineTransform matrix = new AffineTransform();
        matrix.translate(x, y);
        matrix.scale(w, h);
        this.shape = this.gen.generate(matrix);
        this.tabPlacement = tabPlacement;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.setBreak(tabPlacement, x, w, y, h);
    }

    private void setBreak(int tabPlacement, int x, int w, int y, int h) {
        DrawnTabGenerator tab = (DrawnTabGenerator)this.gen;
        switch (tabPlacement) {
            case 1: {
                this.breakBeg.setLocation((double)x + tab.getLLX().get() * (double)w, (double)y + tab.getLLY().get() * (double)h);
                this.breakEnd.setLocation((double)x + tab.getLRX().get() * (double)w, (double)y + tab.getLRY().get() * (double)h);
                break;
            }
            case 4: {
                this.breakBeg.setLocation((double)x + tab.getULX().get() * (double)w, (double)y + tab.getULY().get() * (double)h);
                this.breakEnd.setLocation((double)x + tab.getLLX().get() * (double)w, (double)y + tab.getLLY().get() * (double)h);
                break;
            }
            case 3: {
                this.breakBeg.setLocation((double)x + tab.getURX().get() * (double)w, (double)y + tab.getURY().get() * (double)h);
                this.breakEnd.setLocation((double)x + tab.getULX().get() * (double)w, (double)y + tab.getULY().get() * (double)h);
                break;
            }
            case 2: {
                this.breakBeg.setLocation((double)x + tab.getLRX().get() * (double)w, (double)y + tab.getLRY().get() * (double)h);
                this.breakEnd.setLocation((double)x + tab.getURX().get() * (double)w, (double)y + tab.getURY().get() * (double)h);
            }
        }
    }

    public Point2D getBreakBeg() {
        return this.breakBeg;
    }

    public Point2D getBreakEnd() {
        return this.breakEnd;
    }
}

