/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import napkin.DrawnBoxGenerator;
import napkin.DrawnShapeHolder;
import napkin.NapkinBoxBorder;
import napkin.NapkinConstants;

public class DrawnBoxHolder
extends DrawnShapeHolder
implements NapkinConstants {
    private Rectangle size;
    private int breakSide = -1;
    private final Point2D begBreak = new Point2D.Double();
    private final Point2D endBreak = new Point2D.Double();

    public DrawnBoxHolder(DrawnBoxGenerator gen) {
        super(gen);
    }

    public DrawnBoxHolder() {
        this(new DrawnBoxGenerator());
    }

    void shapeUpToDate(Rectangle sz) {
        this.shapeUpToDate(sz, -1, 0.0, 0.0, 0.0, 0.0);
    }

    void shapeUpToDate(Rectangle sz, int bSide, double begX, double begY, double endX, double endY) {
        if (this.size != null && this.size.width == sz.width && this.size.height == sz.height && bSide == this.breakSide && this.begBreak.getX() == begX && this.begBreak.getY() == begY && this.endBreak.getX() == endX && this.endBreak.getY() == endY) {
            return;
        }
        this.size = (Rectangle)sz.clone();
        this.breakSide = bSide;
        this.begBreak.setLocation(begX, begY);
        this.endBreak.setLocation(endX, endY);
        Insets in = NapkinBoxBorder.DEFAULT_INSETS;
        double borderWidth = sz.getWidth() - (double)(in.left + in.right);
        double borderHeight = sz.getHeight() - (double)(in.top + in.bottom);
        int cornerX = in.top;
        int cornerY = in.left;
        DrawnBoxGenerator gen = (DrawnBoxGenerator)this.gen;
        gen.getSizeX().setMid(borderWidth);
        gen.getSizeY().setMid(borderHeight);
        gen.getBegX().setMid(cornerX);
        gen.getEndY().setMid(cornerY);
        AffineTransform matrix = new AffineTransform();
        matrix.translate(cornerX, cornerY);
        if (bSide == -1) {
            gen.setNoBreak();
        } else {
            gen.setBreak(bSide, begX, begY, endX, endY);
        }
        this.shape = gen.generate(matrix);
    }
}

