/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Component;
import java.awt.Container;

class ComponentWalker {
    private final Visitor visitor;

    ComponentWalker(Component top, Visitor visitor) {
        this.visitor = visitor;
        if (top != null) {
            this.visit(top, 0);
        }
    }

    private boolean visit(Component c, int depth) {
        if (!this.visitor.visit(c, depth)) {
            return false;
        }
        int childDepth = depth + 1;
        if (c instanceof Container) {
            Container container = (Container)c;
            int end = container.getComponentCount();
            for (int i = 0; i < end; ++i) {
                this.visit(container.getComponent(i), childDepth);
            }
        }
        return true;
    }

    static interface Visitor {
        public boolean visit(Component var1, int var2);
    }
}

