/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.net;

import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.FrameAnt;
import ants.p2p.query.ServerInfo;
import ants.p2p.utils.net.UPnPDescriptor;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.control.ActionListener;
import org.cybergarage.upnp.control.QueryListener;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.cybergarage.upnp.device.InvalidDescriptionException;

public class UPnPManager
extends ControlPoint
implements DeviceChangeListener,
ActionListener,
QueryListener {
    private static Logger _logger = Logger.getLogger((String)UPnPManager.class.getName());
    private static final String DESCRIPTION_FILE_NAME = WarriorAnt.workingPath + "upnpdescriptor/description.xml";
    private static final String PRESENTATION_URI = "http://antsp2p.sourceforge.net";
    public static final String ANTS_DEVICE_TYPE = "urn:schemas-upnp-org:device:antsp2p:1";
    public static final String ANTS_LAN_ADDRESS_SERVICE_TYPE = "urn:schemas-upnp-org:service:address:1";
    public static final String ANTS_LAN_ADDRESS_ACTION_TYPE = "GetLANAddress";
    private StateVariable serverInfo;
    private Device antsDev = null;
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String SERVICE_TYPE = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String TCP_PREFIX = "ANtsTCP";
    private String _guidSuffix;
    private static UPnPManager INSTANCE = null;
    private Device _router;
    private Service _service;
    private Mapping _tcp;

    public static synchronized UPnPManager instance() {
        if (INSTANCE == null) {
            UPnPDescriptor.createDirectoryStructure();
            INSTANCE = new UPnPManager();
            return INSTANCE;
        }
        return INSTANCE;
    }

    private UPnPManager() {
        _logger.info((Object)"Starting UPnP Service Manager.");
        try {
            this.addDeviceChangeListener(this);
            this.start();
        }
        catch (Exception bad) {
            bad.printStackTrace();
        }
    }

    public Device getDevice() {
        return this.antsDev;
    }

    public void setCurrentLanAddress(ServerInfo si) {
        try {
            if (si == null || this.serverInfo == null) {
                return;
            }
            this.serverInfo.setValue(si.toString());
        }
        catch (Exception e) {
            _logger.error((Object)"Error in setting UPnP LAN address", (Throwable)e);
        }
    }

    public ServerInfo getCurrentLanAddress() {
        try {
            if (this.serverInfo == null) {
                return null;
            }
            String[] addressPort = this.serverInfo.getValue().split(":");
            ServerInfo si = new ServerInfo("", addressPort[0], new Integer(addressPort[1]), "");
            return si;
        }
        catch (Exception e) {
            _logger.error((Object)"Error in retrieving UPnP LAN address", (Throwable)e);
            return null;
        }
    }

    public void startDevice() {
        this.stopDevice();
        try {
            this.antsDev = new Device(DESCRIPTION_FILE_NAME);
            Action getTimeAction = this.antsDev.getAction(ANTS_LAN_ADDRESS_ACTION_TYPE);
            getTimeAction.setActionListener(this);
            ServiceList serviceList = this.antsDev.getServiceList();
            Service service = serviceList.getService(0);
            service.setQueryListener(this);
            this.serverInfo = this.antsDev.getStateVariable("LANAddress");
            this.antsDev.setLeaseTime(60);
            this.antsDev.start();
        }
        catch (InvalidDescriptionException e) {
            _logger.error((Object)"Invalid description file for ANtsP2P UPnP Service", (Throwable)e);
        }
    }

    public void stopDevice() {
        if (this.antsDev != null) {
            this.antsDev.byebye();
            this.antsDev.stop();
            this.antsDev = null;
            this.serverInfo = null;
        }
    }

    public boolean queryControlReceived(StateVariable stateVar) {
        stateVar.setValue(this.serverInfo.getValue());
        return true;
    }

    public boolean actionControlReceived(Action action) {
        String actionName = action.getName();
        if (actionName.equals(ANTS_LAN_ADDRESS_ACTION_TYPE)) {
            Argument timeArg = action.getArgument("LANAddress");
            timeArg.setValue(this.serverInfo.getValue());
            return true;
        }
        return false;
    }

    public void update(String newValue) {
        this.serverInfo.setValue(newValue);
    }

    public synchronized boolean isNATPresent() {
        return this._router != null && this._service != null;
    }

    public boolean mappingsExist() {
        return this._tcp != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getNATAddress() throws UnknownHostException {
        Action getIP;
        UPnPManager uPnPManager = this;
        synchronized (uPnPManager) {
            if (!this.isNATPresent()) {
                return null;
            }
            getIP = this._service.getAction("GetExternalIPAddress");
        }
        if (getIP == null) {
            _logger.info((Object)"Couldn't find GetExternalIPAddress action!");
            return null;
        }
        if (!getIP.postControlAction()) {
            _logger.info((Object)"couldn't get our external address");
            return null;
        }
        Argument ret = getIP.getOutputArgumentList().getArgument("NewExternalIPAddress");
        return InetAddress.getByName(ret.getValue());
    }

    public synchronized void deviceAdded(Device dev) {
        _logger.info((Object)("Device added: " + dev.getFriendlyName()));
        if (this._service != null && this._router != null) {
            _logger.info((Object)"we already have a router");
            return;
        }
        if (dev.getDeviceType().equals(ROUTER_DEVICE) && dev.isRootDevice()) {
            this._router = dev;
        }
        if (this._router == null) {
            _logger.info((Object)"didn't get router device");
            return;
        }
        this.discoverService();
        if (this._service == null) {
            _logger.info((Object)"couldn't find service");
            this._router = null;
        } else {
            _logger.info((Object)("Found service, router: " + this._router.getFriendlyName() + ", service: " + this._service));
        }
    }

    private void discoverService() {
        Iterator iter = this._router.getDeviceList().iterator();
        while (iter.hasNext()) {
            Device current = (Device)iter.next();
            if (!current.getDeviceType().equals(WAN_DEVICE)) continue;
            DeviceList l = current.getDeviceList();
            _logger.info((Object)("found " + current.getDeviceType() + ", size: " + l.size() + ", on: " + current.getFriendlyName()));
            for (int i = 0; i < current.getDeviceList().size(); ++i) {
                Device current2 = l.getDevice(i);
                if (!current2.getDeviceType().equals(WANCON_DEVICE)) continue;
                _logger.info((Object)("found " + current2.getDeviceType() + ", on: " + current2.getFriendlyName()));
                this._service = current2.getService(SERVICE_TYPE);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mapPort(String address, int port) {
        _logger.info((Object)("Attempting to map port: " + port));
        Object gen = null;
        String localAddress = address;
        int localPort = port;
        Mapping tcp = new Mapping("", port, localAddress, localPort, "TCP", TCP_PREFIX + this.getGUIDSuffix());
        if (!this.addMapping(tcp)) {
            _logger.info((Object)" couldn't map tcp to whatever udp was mapped. cleaning up...");
            port = 0;
            tcp = null;
        }
        UPnPManager uPnPManager = this;
        synchronized (uPnPManager) {
            this._tcp = tcp;
        }
        Thread staleCleaner = new Thread(new StaleCleaner());
        staleCleaner.setDaemon(true);
        staleCleaner.setName("Stale Mapping Cleaner");
        staleCleaner.start();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMapping(Mapping m) {
        Action add;
        _logger.info((Object)("adding " + m));
        UPnPManager uPnPManager = this;
        synchronized (uPnPManager) {
            add = this._service.getAction("AddPortMapping");
        }
        if (add == null) {
            _logger.info((Object)"Couldn't find AddPortMapping action!");
            return false;
        }
        add.setArgumentValue("NewRemoteHost", m._externalAddress);
        add.setArgumentValue("NewExternalPort", m._externalPort);
        add.setArgumentValue("NewInternalClient", m._internalAddress);
        add.setArgumentValue("NewInternalPort", m._internalPort);
        add.setArgumentValue("NewProtocol", m._protocol);
        add.setArgumentValue("NewPortMappingDescription", m._description);
        add.setArgumentValue("NewEnabled", "1");
        add.setArgumentValue("NewLeaseDuration", 0);
        boolean success = add.postControlAction();
        _logger.info((Object)("Post succeeded: " + success));
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMapping(Mapping m) {
        Action remove;
        _logger.info((Object)("removing " + m));
        UPnPManager uPnPManager = this;
        synchronized (uPnPManager) {
            remove = this._service.getAction("DeletePortMapping");
        }
        if (remove == null) {
            _logger.info((Object)"Couldn't find DeletePortMapping action!");
            return false;
        }
        remove.setArgumentValue("NewRemoteHost", m._externalAddress);
        remove.setArgumentValue("NewExternalPort", m._externalPort);
        remove.setArgumentValue("NewProtocol", m._protocol);
        boolean success = remove.postControlAction();
        _logger.info((Object)("Remove succeeded: " + success));
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMappingsOnShutdown() {
        Mapping tcp;
        UPnPManager uPnPManager = this;
        synchronized (uPnPManager) {
            tcp = this._tcp;
        }
        final Thread cleaner = new Thread(){

            public void run() {
                _logger.info((Object)"start cleaning");
                UPnPManager.this.removeMapping(tcp);
                _logger.info((Object)"done cleaning");
            }
        };
        Thread waiter = new Thread(){

            public void run() {
                try {
                    _logger.info((Object)"waiting for UPnP cleaners to finish");
                    cleaner.join(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                _logger.info((Object)"UPnP cleaners done");
            }
        };
        waiter.setName("shutdown mapping waiter");
        try {
            Runtime.getRuntime().addShutdownHook(waiter);
        }
        catch (IllegalStateException ignored) {
            // empty catch block
        }
        cleaner.setName("shutdown mapping cleaner");
        cleaner.setDaemon(true);
        cleaner.start();
        Thread.yield();
    }

    public void finalize() {
        this.stop();
    }

    private synchronized String getGUIDSuffix() {
        if (this._guidSuffix == null) {
            this._guidSuffix = FrameAnt.getInstance(null).getGuiAnt().getConnectionAntPanel().getWarriorAnt().getIdent().substring(0, 10);
        }
        return this._guidSuffix;
    }

    public void deviceRemoved(Device dev) {
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        if (addr instanceof Inet4Address && !addr.isLoopbackAddress()) {
            return addr;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        addr = addresses.nextElement();
                        if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                        return addr;
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        throw new UnknownHostException("localhost has no interface with a non-loopback IPv4 address");
    }

    private class StaleCleaner
    implements Runnable {
        private StaleCleaner() {
        }

        private String list(List l) {
            String s = "";
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Argument next = (Argument)i.next();
                s = s + next.getName() + "->" + next.getValue() + ", ";
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Action getGeneric;
            _logger.info((Object)"Looking for stale mappings...");
            HashSet<Mapping> mappings = new HashSet<Mapping>();
            UPnPManager uPnPManager = UPnPManager.this;
            synchronized (uPnPManager) {
                getGeneric = UPnPManager.this._service.getAction("GetGenericPortMappingEntry");
            }
            if (getGeneric == null) {
                _logger.info((Object)"Couldn't find GetGenericPortMappingEntry action!");
                return;
            }
            try {
                int i = 0;
                while (true) {
                    getGeneric.setArgumentValue("NewPortMappingIndex", i);
                    _logger.info((Object)("Stale Iteration: " + i + ", generic.input: " + this.list(getGeneric.getInputArgumentList()) + ", generic.output: " + this.list(getGeneric.getOutputArgumentList())));
                    if (getGeneric.postControlAction()) {
                        mappings.add(new Mapping(getGeneric.getArgumentValue("NewRemoteHost"), getGeneric.getArgumentValue("NewExternalPort"), getGeneric.getArgumentValue("NewInternalClient"), getGeneric.getArgumentValue("NewInternalPort"), getGeneric.getArgumentValue("NewProtocol"), getGeneric.getArgumentValue("NewPortMappingDescription")));
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException bad) {
                _logger.error((Object)"NFE reading mappings!", (Throwable)bad);
                return;
            }
            _logger.info((Object)("Stale cleaner found " + mappings.size() + " total mappings"));
            Iterator iter = mappings.iterator();
            while (iter.hasNext()) {
                Mapping current = (Mapping)iter.next();
                _logger.info((Object)("Analyzing: " + current));
                if (current._description == null || !current._description.equals(UPnPManager.TCP_PREFIX + UPnPManager.this.getGUIDSuffix())) continue;
                StaleCleaner staleCleaner = this;
                synchronized (staleCleaner) {
                    if (UPnPManager.this._tcp != null && current._externalPort == ((UPnPManager)UPnPManager.this)._tcp._externalPort && current._internalAddress.equals(((UPnPManager)UPnPManager.this)._tcp._internalAddress) && current._internalPort == ((UPnPManager)UPnPManager.this)._tcp._internalPort) {
                        continue;
                    }
                }
                _logger.info((Object)("mapping " + current + " appears to be stale"));
                UPnPManager.this.removeMapping(current);
            }
        }
    }

    private final class Mapping {
        public final String _externalAddress;
        public final int _externalPort;
        public final String _internalAddress;
        public final int _internalPort;
        public final String _protocol;
        public final String _description;

        public Mapping(String externalAddress, String externalPort, String internalAddress, String internalPort, String protocol, String description) throws NumberFormatException {
            this._externalAddress = externalAddress;
            this._externalPort = Integer.parseInt(externalPort);
            this._internalAddress = internalAddress;
            this._internalPort = Integer.parseInt(internalPort);
            this._protocol = protocol;
            this._description = description;
        }

        public Mapping(String externalAddress, int externalPort, String internalAddress, int internalPort, String protocol, String description) {
            this._externalAddress = externalAddress;
            this._externalPort = externalPort;
            this._internalAddress = internalAddress;
            this._internalPort = internalPort;
            this._protocol = protocol;
            this._description = description;
        }

        public String toString() {
            return this._externalAddress + ":" + this._externalPort + "->" + this._internalAddress + ":" + this._internalPort + "@" + this._protocol + " desc: " + this._description;
        }
    }
}

