/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.indexer;

import ants.p2p.utils.donkey.DonkeyHashFile;
import ants.p2p.utils.encoding.Base16;
import ants.p2p.utils.indexer.DigestManager;
import helliker.id3.MP3File;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import ji.JI;

public class FileInfos
implements Serializable {
    String hash;
    String ed2kHash;
    Object[] chunckHashes;
    long lastModified;
    String name;
    long size;
    MP3File mp3File = null;
    String comment = "";

    public FileInfos(File f) throws Exception {
        if (!f.exists()) {
            throw new IOException("File not exists.");
        }
        this.name = f.getAbsolutePath();
        DigestManager dm = new DigestManager();
        this.chunckHashes = dm.getDigests(f);
        this.hash = dm.getDigest(this.chunckHashes);
        this.ed2kHash = Base16.toHexString(DonkeyHashFile.doHash(f)[0]);
        this.lastModified = f.lastModified();
        this.size = f.length();
        try {
            this.mp3File = new MP3File(this.name);
            if (!this.mp3File.isMP3()) {
                this.mp3File = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getHash() {
        return this.hash;
    }

    public String getED2KHash() {
        return this.ed2kHash;
    }

    public Object[] getChunckHashes() {
        return this.chunckHashes;
    }

    public long getSize() {
        return this.size;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o instanceof FileInfos) {
            return ((FileInfos)o).hash.equals(this.hash);
        }
        if (o instanceof String) {
            return ((String)o).equals(this.hash);
        }
        return this == o;
    }

    public boolean isMP3() {
        try {
            return this.mp3File.isMP3();
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getBitrate() throws Exception {
        return this.mp3File.getBitRate();
    }

    public String getAlbum() throws Exception {
        return this.mp3File.getAlbum();
    }

    public String getArtist() throws Exception {
        return this.mp3File.getArtist();
    }

    public String getYear() throws Exception {
        return this.mp3File.getYear();
    }

    public String getPlayingTimeString() throws Exception {
        return this.mp3File.getPlayingTimeString();
    }

    public String getExtendedInfos() {
        try {
            return "[MP3 Bitrate: " + this.getBitrate() + " - Length: " + this.getPlayingTimeString() + " - Artist: " + this.getArtist() + " - Album: " + this.getAlbum() + " - Year: " + this.getYear() + "]";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String sizeToString(double dSize) {
        int index;
        int x;
        double currentSize = dSize;
        dSize /= Math.pow(2.0, 20.0);
        for (x = 1; dSize > 1.0 && x < 5; dSize /= Math.pow(2.0, 10.0), ++x) {
        }
        String suffix = " bytes";
        String size = currentSize + suffix;
        if (x == 2) {
            suffix = " Mib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 20.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 3) {
            suffix = " Gib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 30.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 4) {
            suffix = " Tib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 40.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        return size;
    }

    public String toString() {
        String result = this.getHash() + "  ";
        String size = this.sizeToString(this.getSize());
        result = result + " " + JI.i("File Size") + ": " + size;
        while (result.length() < 65) {
            result = result + " ";
        }
        result = result + " " + this.getName();
        result = result + " " + this.getExtendedInfos();
        return result;
    }
}

