/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.donkey;

import ants.p2p.utils.donkey.Convert;
import ants.p2p.utils.donkey.DonkeyPacketConstants;
import ants.p2p.utils.donkey.MD4;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.logging.Logger;

public class DonkeyHashFile
implements DonkeyPacketConstants {
    static Logger log = Logger.getLogger(DonkeyHashFile.class.getName());
    public static PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(new Object());

    public static void addPropertyChangeListener(PropertyChangeListener pcl) {
        propertyChangeSupport.addPropertyChangeListener(pcl);
    }

    public static void removePropertyChangeListener(PropertyChangeListener pcl) {
        propertyChangeSupport.removePropertyChangeListener(pcl);
    }

    public static byte[][] doHash(File file) {
        byte[][] digest = null;
        try {
            propertyChangeSupport.firePropertyChange("fileIndexingInProgress", "[ED2K] " + file.getName(), new Integer(0));
            log.fine("Hashing " + file.toString());
            FileInputStream fis = new FileInputStream(file);
            digest = DonkeyHashFile.digest(file);
            fis.close();
        }
        catch (FileNotFoundException e) {
            log.warning(e.getMessage());
        }
        catch (IOException e) {
            log.warning(e.getMessage());
        }
        return digest;
    }

    public static byte[][] digest(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            int j;
            int i;
            FileChannel fc = fis.getChannel();
            MD4 msgDigest = new MD4();
            ByteBuffer bb = ByteBuffer.allocateDirect(16384).order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer di = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN);
            log.finest("pos:" + fc.position());
            int c = (int)((fc.size() + 9728000L - 1L) / 9728000L);
            log.finer("hash " + c + " EdonkeyParts");
            ByteBuffer hashset = ByteBuffer.allocate(16 * (c > 0 ? c : 1)).order(ByteOrder.LITTLE_ENDIAN);
            for (i = 1; i < c; ++i) {
                log.finest("filechannel pos:" + fc.position() + " part: " + i + " of " + c);
                while (fc.position() <= (long)i * 9728000L - (long)bb.capacity()) {
                    fc.read(bb);
                    bb.flip();
                    msgDigest.update(bb);
                    bb.rewind();
                    try {
                        Thread.currentThread();
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ex) {}
                }
                log.finest("filechannel pos:" + fc.position() + " part: " + i + " of " + c);
                if (fc.position() < (long)i * 9728000L) {
                    bb.limit((int)((long)i * 9728000L - fc.position()));
                    fc.read(bb);
                    bb.flip();
                    msgDigest.update(bb);
                    bb.rewind();
                    try {
                        Thread.currentThread();
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                hashset.limit(16 * i);
                msgDigest.finalDigest(hashset);
                int progress = (int)Math.floor((double)i * 100.0 / (double)c);
                propertyChangeSupport.firePropertyChange("fileIndexingInProgress", "[ED2K] " + file.getName(), new Integer(progress));
            }
            if (c > 0) {
                while (fc.position() < fc.size()) {
                    fc.read(bb);
                    bb.flip();
                    msgDigest.update(bb);
                    bb.rewind();
                    try {
                        Thread.currentThread();
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ex) {}
                }
                hashset.limit(16 * i);
            }
            msgDigest.finalDigest(hashset);
            hashset.flip();
            if (c > 1) {
                msgDigest.update(hashset);
                msgDigest.finalDigest(di);
            } else {
                di.put(hashset);
            }
            di.rewind();
            hashset.rewind();
            byte[][] hashes = new byte[c != 1 ? c + 1 : 1][16];
            di.get(hashes[0]);
            for (j = 1; j < hashes.length; ++j) {
                hashset.get(hashes[j]);
            }
            hashset.rewind();
            log.finer("Hash: " + Convert.bytesToHexString(hashes[0]));
            for (j = 1; j < hashes.length; ++j) {
                log.finer("partial hash of part " + j + " is " + Convert.bytesToHexString(hashes[j]));
            }
            log.fine("ed2k: file done");
            return hashes;
        }
        catch (IOException e) {
            log.warning(e.getMessage());
            return null;
        }
    }

    public static boolean isValidHashset(byte[][] hashes) {
        MD4 msgDigest = new MD4();
        for (int i = 1; i < hashes.length; ++i) {
            msgDigest.update(ByteBuffer.wrap(hashes[i]).order(ByteOrder.LITTLE_ENDIAN));
        }
        if (hashes.length > 1) {
            byte[] hash = new byte[16];
            msgDigest.finalDigest(ByteBuffer.wrap(hash).order(ByteOrder.LITTLE_ENDIAN));
            if (Arrays.equals(hash, hashes[0])) {
                log.fine("hashset ok");
                return true;
            }
            log.fine("hashset NOT ok");
            return false;
        }
        log.fine("dummy hashset");
        return true;
    }
}

