/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.addresses;

import ants.p2p.utils.addresses.InetAddressRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.ArrayList;

public class InetAddressWatchdog {
    static InetAddressWatchdog instance = null;
    ArrayList addresses = new ArrayList();

    public static InetAddressWatchdog getInstance() {
        if (instance == null) {
            instance = new InetAddressWatchdog();
            return instance;
        }
        return instance;
    }

    public void loadFilterFile(String fileName) {
        this.addresses = new ArrayList();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                throw new Exception("File doesn't exist");
            }
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String currentLine = null;
            while ((currentLine = br.readLine()) != null) {
                if (currentLine.charAt(0) == '#') continue;
                String[] initAddress = currentLine.split("[-]");
                String[] finalAddress = initAddress[1].split("[,]");
                this.addresses.add(new InetAddressRange(initAddress[0], finalAddress[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    InetAddressWatchdog() {
    }

    public boolean allowedAddress(String ip) throws Exception {
        ip = InetAddress.getByName(ip).getHostAddress();
        for (int x = 0; x < this.addresses.size(); ++x) {
            InetAddressRange iar = (InetAddressRange)this.addresses.get(x);
            if (!iar.isInRange(ip)) continue;
            return false;
        }
        return true;
    }
}

