/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.security.sockets.AddressesRequestHandler;
import ants.p2p.security.sockets.DirectNeighbourRequestHandler;
import ants.p2p.security.sockets.NewClientHandler;
import ants.p2p.security.sockets.SecureServer;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

class RequestsHandler
extends Thread {
    Socket localSocket;
    SecureServer caller;
    static Logger _logger = Logger.getLogger((String)RequestsHandler.class.getName());

    public RequestsHandler(SecureServer caller, Socket localSocket) {
        this.localSocket = localSocket;
        this.caller = caller;
    }

    public void run() {
        try {
            int type = this.localSocket.getInputStream().read();
            if (type == 0) {
                _logger.info((Object)"Connection type: 0");
                NewClientHandler handler = new NewClientHandler(this.caller, this.localSocket);
                handler.start();
            } else if (type == 1) {
                _logger.info((Object)"Connection type: 1");
                AddressesRequestHandler handler = new AddressesRequestHandler(this.caller, this.localSocket);
                handler.start();
            } else if (type == 2 && this.caller.n.acceptTCPDirectConnections()) {
                _logger.info((Object)"Connection type: 2");
                DirectNeighbourRequestHandler handler = new DirectNeighbourRequestHandler(this.caller, this.localSocket);
                handler.start();
            } else {
                this.localSocket.close();
            }
        }
        catch (IOException ex) {
            _logger.error((Object)"", (Throwable)ex);
            return;
        }
    }
}

