/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.query.QueryTuple;
import java.io.Serializable;
import java.net.InetAddress;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;

public class ServerInfo
extends QueryTuple {
    Object stringAddress;
    Object port;
    Object connectionType;

    public ServerInfo(String sessionKey, String stringAddress, Integer port, String connectionType) {
        super(sessionKey);
        this.stringAddress = stringAddress;
        this.port = port;
        this.connectionType = "Masked";
    }

    public ServerInfo(ServerInfo si, String sessionKey) {
        super(sessionKey);
        this.stringAddress = si.stringAddress;
        this.port = si.port;
        this.connectionType = "Masked";
    }

    public InetAddress getAddress() {
        if (this.stringAddress instanceof String) {
            try {
                return InetAddress.getByName((String)this.stringAddress);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Integer getPort() {
        if (this.port instanceof Integer) {
            return (Integer)this.port;
        }
        return null;
    }

    public String getConnectionType() {
        if (this.connectionType instanceof String) {
            return (String)this.connectionType;
        }
        return null;
    }

    public void encrypt(Cipher c) throws Exception {
        this.stringAddress = new SealedObject((Serializable)((Object)((String)this.stringAddress)), c);
        this.port = new SealedObject((Integer)this.port, c);
        this.connectionType = new SealedObject((Serializable)((Object)((String)this.connectionType)), c);
    }

    public void decrypt(Cipher c) throws Exception {
        this.stringAddress = (String)((SealedObject)this.stringAddress).getObject(c);
        this.port = (Integer)((SealedObject)this.port).getObject(c);
        this.connectionType = (String)((SealedObject)this.connectionType).getObject(c);
    }

    public String toString() {
        return this.stringAddress + ":" + this.getPort();
    }

    public boolean equals(Object o) {
        if (o instanceof ServerInfo) {
            ServerInfo so = (ServerInfo)o;
            if (this.getAddress().isAnyLocalAddress() && so.getAddress().isAnyLocalAddress() && this.getPort().equals(so.getPort())) {
                return true;
            }
            return this.getAddress().getHostAddress().equals(so.getAddress().getHostAddress()) && this.getPort().equals(so.getPort());
        }
        return this == o;
    }
}

