/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.MessageWrapper;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.query.HttpServerInfo;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileListItem;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.utils.encoding.StringHash;
import ants.p2p.utils.indexer.BackgroundEngine;
import ants.p2p.utils.indexer.FileInfos;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class QueryFileListUploaderThread
extends Thread {
    WarriorAnt wa;
    QueryMessage qm;
    String dest;
    static Logger _logger = Logger.getLogger((String)QueryFileListUploaderThread.class.getName());

    public QueryFileListUploaderThread(WarriorAnt wa, QueryMessage qm, String dest) {
        this.wa = wa;
        this.qm = qm;
        this.dest = dest;
        this.setPriority(1);
    }

    public void run() {
        QueryMessage oldQm = this.qm;
        try {
            this.qm = new QueryMessage(oldQm);
            ((QueryFileListItem)this.qm.getQuery()).setAddAction();
            this.qm.getPublicHeader().generateSessionKey();
            this.qm.rnd.setSeed(System.currentTimeMillis());
            ArrayList resultSet = BackgroundEngine.getInstance().getCompleteFileList();
            ArrayList<QueryFileTuple> uploadedResultSet = new ArrayList<QueryFileTuple>();
            _logger.info((Object)("Uploading file list[" + resultSet.size() + "] to: " + this.dest.substring(0, 10)));
            QueryFileListUploaderThread queryFileListUploaderThread = this;
            if (queryFileListUploaderThread.wa.isHttpEnabled()) {
                QueryFileListUploaderThread queryFileListUploaderThread2 = this;
                QueryFileListUploaderThread queryFileListUploaderThread3 = this;
                HttpServerInfo si = new HttpServerInfo(this.qm.getPublicHeader().getEncryptedSessionKey(), queryFileListUploaderThread2.wa.getHttpServerHomePage(), queryFileListUploaderThread3.wa.getHttpServerDescription(), this.wa.getIdent(), this.wa.getLocalInetAddress(), new Long(System.currentTimeMillis()));
                si.encrypt(this.qm.getPublicHeader().getEncCipher());
                resultSet.add(si);
                this.qm.tuples.add(si);
            }
            for (int x = 0; x < resultSet.size(); ++x) {
                if (resultSet.get(x) instanceof String) {
                    QueryCompletedFileTuple qtLocal = new QueryCompletedFileTuple(this.qm.getPublicHeader().getEncryptedSessionKey(), new File((String)resultSet.get(x)).getName(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getHash(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getED2KHash(), null, new Long(((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getSize()), this.wa.getIdent(), this.wa.getLocalInetAddress(), new Integer(WarriorAnt.maxPullRequestsToServe - this.wa.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getExtendedInfos(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getComment());
                    uploadedResultSet.add(qtLocal);
                    if (BackgroundEngine.getInstance().getLastUploadedList(this.dest).contains(qtLocal)) continue;
                    QueryCompletedFileTuple qt = new QueryCompletedFileTuple(this.qm.getPublicHeader().getEncryptedSessionKey(), new File((String)resultSet.get(x)).getName(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getHash(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getED2KHash(), null, new Long(((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getSize()), this.wa.getIdent(), this.wa.getLocalInetAddress(), new Integer(WarriorAnt.maxPullRequestsToServe - this.wa.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getExtendedInfos(), ((FileInfos)BackgroundEngine.getInstance().sharedFilesIndexName.get(resultSet.get(x))).getComment());
                    qt.encrypt(this.qm.getPublicHeader().getEncCipher());
                    this.qm.tuples.add(qt);
                } else if (resultSet.get(x) instanceof StringHash) {
                    BackgroundEngine be = BackgroundEngine.getInstance();
                    QueryPartialFileTuple qptLocal = be.getPartialFileTuple(this.qm.getPublicHeader().getEncryptedSessionKey(), ((StringHash)resultSet.get(x)).getHash(), QueryHashItem.ANTS_HASH, this.wa.getIdent(), new Integer(WarriorAnt.maxPullRequestsToServe - this.wa.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, false);
                    uploadedResultSet.add(qptLocal);
                    if (BackgroundEngine.getInstance().getLastUploadedList(this.dest).contains(qptLocal)) continue;
                    QueryPartialFileTuple qpt = be.getPartialFileTuple(this.qm.getPublicHeader().getEncryptedSessionKey(), ((StringHash)resultSet.get(x)).getHash(), QueryHashItem.ANTS_HASH, this.wa.getIdent(), new Integer(WarriorAnt.maxPullRequestsToServe - this.wa.inServiceFilePullRequests.size()), WarriorAnt.ConnectionType, false);
                    qpt.encrypt(this.qm.getPublicHeader().getEncCipher());
                    this.qm.tuples.add(qpt);
                }
                if ((x + 1) % 100 != 0 && x != resultSet.size() - 1) continue;
                this.qm.setProcessed();
                this.qm.resetDelivered();
                this.qm.getPublicHeader().invalidateSessionKey();
                if (this.qm.getTuples().size() > 0) {
                    MessageWrapper wm = this.wa.sendMessage(this.qm, this.dest, false, false);
                    while (this.wa.myMessages.contains(wm)) {
                        Thread.sleep(1000L);
                    }
                    if (this.wa.failedMessages.contains(wm)) {
                        this.wa.failedMessages.remove(wm);
                        _logger.debug((Object)(this.wa.getShortId() + ": Error in sending File list to " + this.dest.substring(0, 10)));
                        BackgroundEngine.getInstance().lastTimeUploadedFileList.put(this.dest, new Long(0L));
                        BackgroundEngine.getInstance().finishedUploadingFileList();
                        return;
                    }
                }
                this.qm = new QueryMessage(oldQm);
                ((QueryFileListItem)this.qm.getQuery()).setAddAction();
                this.qm.getPublicHeader().generateSessionKey();
                this.qm.rnd.setSeed(System.currentTimeMillis());
            }
            _logger.info((Object)("Last uploaded file list[" + BackgroundEngine.getInstance().getLastUploadedList(this.dest).size() + "]"));
            ArrayList removeList = (ArrayList)BackgroundEngine.getInstance().getLastUploadedList(this.dest).clone();
            removeList.removeAll(uploadedResultSet);
            _logger.info((Object)("To be removed file list[" + removeList.size() + "]"));
            ArrayList curUploadedList = (ArrayList)uploadedResultSet.clone();
            BackgroundEngine.getInstance().setLastUploadedList(this.dest, curUploadedList);
            curUploadedList.addAll(removeList);
            this.qm = new QueryMessage(oldQm);
            ((QueryFileListItem)this.qm.getQuery()).setRemoveAction();
            this.qm.getPublicHeader().generateSessionKey();
            this.qm.rnd.setSeed(System.currentTimeMillis());
            _logger.info((Object)("Uploading delete file list to: " + this.dest.substring(0, 10)));
            for (int x = 0; x < removeList.size(); ++x) {
                curUploadedList.remove(removeList.get(x));
                QueryFileTuple qft = (QueryFileTuple)removeList.get(x);
                qft.sessionKey = this.qm.getPublicHeader().getEncryptedSessionKey();
                qft.encrypt(this.qm.getPublicHeader().getEncCipher());
                this.qm.tuples.add(qft);
                if ((x + 1) % 100 != 0 && x != removeList.size() - 1) continue;
                this.qm.setProcessed();
                this.qm.resetDelivered();
                this.qm.getPublicHeader().invalidateSessionKey();
                if (this.qm.getTuples().size() > 0) {
                    MessageWrapper wm = this.wa.sendMessage(this.qm, this.dest, false, false);
                    while (this.wa.myMessages.contains(wm)) {
                        Thread.sleep(1000L);
                    }
                    if (this.wa.failedMessages.contains(wm)) {
                        this.wa.failedMessages.remove(wm);
                        _logger.debug((Object)(this.wa.getShortId() + ": Error in sending File list to " + this.dest.substring(0, 10)));
                        BackgroundEngine.getInstance().lastTimeUploadedFileList.put(this.dest, new Long(0L));
                        BackgroundEngine.getInstance().finishedUploadingFileList();
                        return;
                    }
                }
                this.qm = new QueryMessage(oldQm);
                ((QueryFileListItem)this.qm.getQuery()).setRemoveAction();
                this.qm.getPublicHeader().generateSessionKey();
                this.qm.rnd.setSeed(System.currentTimeMillis());
            }
            BackgroundEngine.getInstance().setLastUploadedList(this.dest, curUploadedList);
            BackgroundEngine.getInstance().finishedUploadingFileList();
            _logger.info((Object)("Uploaded file list[" + BackgroundEngine.getInstance().getLastUploadedList(this.dest).size() + "]"));
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            BackgroundEngine.getInstance().finishedUploadingFileList();
        }
    }
}

