/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.gui;

import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.FrameAnt_this_componentAdapter;
import ants.p2p.gui.FrameAnt_this_windowAdapter;
import ants.p2p.gui.GuiAnt;
import ants.p2p.gui.SettingsAntPanel;
import ants.p2p.gui.SwingWorker;
import ants.p2p.utils.addresses.InetAddressWatchdog;
import ants.p2p.utils.indexer.BackgroundEngine;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import ji.JI;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class FrameAnt
extends JFrame {
    static FrameAnt instance;
    GuiAnt ga;
    public static int WIDTH;
    public static int HEIGHT;
    static boolean isReady;
    static String logFileName;
    static Logger _logger;

    FrameAnt(String title) {
        super(title);
        instance = this;
        try {
            this.jbInit();
            isReady = true;
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
    }

    public GuiAnt getGuiAnt() {
        return this.ga;
    }

    public static FrameAnt getInstance(String title) {
        if (instance == null) {
            instance = new FrameAnt(title);
            return instance;
        }
        return instance;
    }

    public static boolean isReady() {
        return isReady;
    }

    public static void checkWorkingPath() {
        File cpf = new File(WarriorAnt.workingPath);
        if (cpf.exists() && !cpf.isDirectory()) {
            cpf.delete();
            cpf.mkdir();
        } else if (!cpf.exists()) {
            cpf.mkdir();
        }
    }

    public static void main(String[] args) {
        _logger.info((Object)("Running VM: " + System.getProperty("java.version")));
        _logger.info((Object)("Running DIR: " + System.getProperty("java.home")));
        try {
            _logger.info((Object)"Checking cipher..............");
            Cipher cipher = Cipher.getInstance("AES");
            _logger.info((Object)"Cipher OK");
            _logger.info((Object)"Checking key size............");
            byte[] key = new byte[16];
            SecretKeySpec secKey = new SecretKeySpec(key, "AES");
            cipher.init(1, secKey);
            _logger.info((Object)"Key size OK");
        }
        catch (Exception e) {
            _logger.error((Object)"Some features needed by ANts are not supported by current VM", (Throwable)e);
        }
        _logger.info((Object)"Loading static settings......");
        SettingsAntPanel.loadStaticSettings();
        SettingsAntPanel.setLookAndFeel();
        _logger.info((Object)"Setting language.............");
        JI.setCurrentLanguage(SettingsAntPanel.currentLanguage);
        _logger.info((Object)"Initializing ANTs............");
        FrameAnt fa = FrameAnt.getInstance("Ants P2P - version " + WarriorAnt.getVersion() + " - Protocol: " + WarriorAnt.getProtocolVersion());
        _logger.info((Object)"Setting look & feel...");
        SettingsAntPanel.setLookAndFeel(fa);
        _logger.info((Object)"Loading ipFilter.dat.........");
        InetAddressWatchdog.getInstance().loadFilterFile(WarriorAnt.workingPath + "ipFilter.dat");
        _logger.info((Object)"Showing window...");
        Logger.getRootLogger().setLevel(Level.OFF);
        fa.show();
        fa.validateTree();
    }

    public FrameAnt() {
        try {
            this.jbInit();
            isReady = true;
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setResizable(true);
        this.addComponentListener(new FrameAnt_this_componentAdapter(this));
        this.addWindowListener(new FrameAnt_this_windowAdapter(this));
        this.ga = new GuiAnt();
        this.getContentPane().add(this.ga);
        Image ico = null;
        if (this.ga.animationPanel != null) {
            ico = this.ga.animationPanel.getIcon();
        }
        if (ico != null) {
            this.setIcon(ico);
        }
        if (this.ga.sap.autoStartANts()) {
            _logger.info((Object)"Autostart enabled: running ANts");
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    FrameAnt.this.ga.cap.startANts();
                    return null;
                }
            };
            worker.start();
        }
        this.reshape(100, 100, 650, 550);
    }

    public void setIcon(Image ico) {
        if (ico != null) {
            try {
                this.setIconImage(ico);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void this_windowClosing(WindowEvent e) {
        int confirm = JOptionPane.showConfirmDialog(this, JI.i("Do you really want to exit?"), JI.i("Really?"), 2);
        if (confirm == 2) {
            this.setVisible(true);
            return;
        }
        JFrame waitingFrame = this.showWorkingFrame();
        if (this.ga.cap.warriorAnt != null) {
            this.ga.cap.warriorAnt.disconnectWarrior();
        }
        if (this.ga.cap.connectionManager != null) {
            this.ga.cap.connectionManager.stop();
            this.ga.cap.connectionManager = null;
        }
        if (this.ga.cap.ircBot != null) {
            this.ga.cap.ircBot.disconnect();
        }
        if (BackgroundEngine.getInstance() != null) {
            BackgroundEngine.getInstance().setPriority(5);
            BackgroundEngine.getInstance().terminate(true);
        }
        waitingFrame.setVisible(false);
        System.exit(0);
    }

    void this_componentResized(ComponentEvent e) {
        this.ga.setPreferredSize(this.getContentPane().getSize());
        this.ga.setSize(this.getContentPane().getSize());
    }

    private JFrame showWorkingFrame() {
        JFrame connectionDialog = new JFrame("ANts");
        connectionDialog.getContentPane().setLayout(new FlowLayout(1));
        connectionDialog.getContentPane().add(new JLabel("ANts is cleaning up. Please wait..."));
        JButton confirmConnection = new JButton("Force Exit");
        confirmConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        connectionDialog.getContentPane().add(confirmConnection);
        connectionDialog.pack();
        connectionDialog.setLocation(300, 300);
        connectionDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        SettingsAntPanel.setLookAndFeel(connectionDialog);
        connectionDialog.setVisible(true);
        return connectionDialog;
    }

    static {
        WIDTH = 600;
        HEIGHT = 600;
        isReady = false;
        logFileName = WarriorAnt.workingPath + "Log.properties";
        File log = new File(logFileName);
        if (log.exists()) {
            PropertyConfigurator.configure((String)logFileName);
        } else {
            BasicConfigurator.configure();
        }
        FrameAnt.checkWorkingPath();
        _logger = Logger.getLogger((String)FrameAnt.class.getName());
    }
}

