/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.gui;

import ants.p2p.filesharing.InterruptedDownload;
import ants.p2p.filesharing.MultipleSourcesDownloadManager;
import ants.p2p.gui.DownloadAntPanel;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class DownloadCellRenderer
extends DefaultTreeCellRenderer {
    DownloadAntPanel dap;

    public DownloadCellRenderer(DownloadAntPanel dap) {
        this.dap = dap;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode && !selected) {
            Object content = ((DefaultMutableTreeNode)value).getUserObject();
            if (content instanceof InterruptedDownload) {
                InterruptedDownload id = (InterruptedDownload)content;
                if (id.isAutoresumeActive()) {
                    c.setForeground(new Color(40, 100, 200));
                } else {
                    c.setForeground(new Color(100, 100, 100));
                }
            } else if (content instanceof MultipleSourcesDownloadManager) {
                MultipleSourcesDownloadManager msdm = (MultipleSourcesDownloadManager)content;
                if (msdm.getChunkHashes() == null) {
                    c.setForeground(new Color(150, 150, 200));
                } else {
                    int sourcesPercent = (int)((double)msdm.getPeersNumber() * 100.0 / (double)MultipleSourcesDownloadManager.MaxSources);
                    c.setForeground(new Color(200 - (sourcesPercent > 100 ? 100 : sourcesPercent), 0, 100 + (sourcesPercent > 100 ? 100 : sourcesPercent)));
                }
                if (!msdm.isAlive() && !msdm.checkCompleted()) {
                    this.setVisible(false);
                }
            } else if (content instanceof QueryPartialFileTuple || content instanceof QueryCompletedFileTuple) {
                QueryFileTuple qft = (QueryFileTuple)content;
                Object[] objPath = ((DefaultMutableTreeNode)value).getUserObjectPath();
                MultipleSourcesDownloadManager msdm = (MultipleSourcesDownloadManager)objPath[objPath.length - 2];
                if (msdm.findInServicePeer(qft.getOwnerID()) != null) {
                    c.setForeground(new Color(0, 0, 200));
                } else {
                    c.setForeground(new Color(200, 0, 0));
                }
            }
        }
        return c;
    }
}

