/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.Ant;
import ants.p2p.Message;
import ants.p2p.MessageWrapper;
import ants.p2p.NeighbourAnt;
import ants.p2p.Router;
import ants.p2p.RoutingTableElement;
import ants.p2p.filesharing.FilePullMessageProcessor;
import ants.p2p.filesharing.FilePullMessageWrapper;
import ants.p2p.filesharing.PartialFile;
import ants.p2p.http.HttpInterruptTransferMessage;
import ants.p2p.http.HttpProxy;
import ants.p2p.http.HttpRequestHandler;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.messages.ControlMessage;
import ants.p2p.messages.FileInfosPullErrorControlMessage;
import ants.p2p.messages.FileInfosPullMessage;
import ants.p2p.messages.FileInfosPushMessage;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileSizePullErrorControlMessage;
import ants.p2p.messages.FileSizePullMessage;
import ants.p2p.messages.FileSizePushMessage;
import ants.p2p.messages.FileTransferEndControlMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.messages.PrivateChatMessage;
import ants.p2p.messages.SecureConnectionErrorControlMessage;
import ants.p2p.messages.SecurityRequestMessage;
import ants.p2p.messages.SecurityResponseMessage;
import ants.p2p.query.HttpServerInfo;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryHttpServerItem;
import ants.p2p.query.QueryInetAddressItem;
import ants.p2p.query.QueryManager;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryNode;
import ants.p2p.query.QueryRandomItem;
import ants.p2p.query.QueryResultSenderThread;
import ants.p2p.query.QuerySupernodeItem;
import ants.p2p.query.ServerInfo;
import ants.p2p.query.security.AsymmetricProvider;
import ants.p2p.query.security.PublicHeader;
import ants.p2p.security.EndpointSecurityManager;
import ants.p2p.security.sockets.SSLProvider;
import ants.p2p.utils.addresses.InetAddressEngine;
import ants.p2p.utils.addresses.InetAddressWatchdog;
import ants.p2p.utils.encoding.Base16;
import ants.p2p.utils.indexer.BackgroundEngine;
import ants.p2p.utils.indexer.FileInfos;
import ants.p2p.utils.net.UPnPManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.UPnPStatus;

public class WarriorAnt
extends Ant {
    List partialFiles = new ArrayList();
    public List outputSecureConnections = new ArrayList();
    public List inputSecureConnections = new ArrayList();
    public List pendingSecureRequest = new ArrayList();
    public List inServiceFilePullRequests = new ArrayList();
    public List inServiceFilePushRequests = new ArrayList();
    public List pendingFilePullRequests = new ArrayList();
    static int httpProxyPort = 8080;
    HttpProxy httpProxy = null;
    static String httpServerDescription = "My personal Web Server";
    static String httpHomePage = "Default.htm";
    static boolean httpRunning = false;
    static int httpLocalServerPort = 80;
    public List scheduledHttpProxy = new ArrayList();
    public static int maxScheduledHttpProxy = 100;
    public List scheduledDownloads = new ArrayList();
    public static int maxScheduledDownloads = 1000;
    public static String workingPath = System.getProperty("user.dir") + "/";
    public static String ed2kPath = workingPath + "ed2k/";
    public static String previewsPath = workingPath + "previews/";
    public static String chunksHome = workingPath;
    public static String chunksPath = "chunks/";
    public static String downloadPath = workingPath + "downloads/";
    public static int maxPullRequestsToServe = 100;
    public static int maxOwnPullRequestsToTrace = 1000;
    public static int maxSecureConnections = 10000;
    public static int maxPartialFiles = 500;
    public static long partialFilesTimeout = Ant.messageTimeout * (long)Ant.maxRetransmissions;
    public static int blockSizeInDownload = (int)Math.pow(2.0, 19.0);
    public static boolean isServer = true;
    public static String password = "";
    public static int processProbability = 45 + (int)(System.currentTimeMillis() % 25L);
    public static boolean autoresumeFilesOnRun = true;
    public Integer writingFileLock = new Integer(0);
    static Logger _logger = Logger.getLogger((String)WarriorAnt.class.getName());

    public WarriorAnt(String id, int maxNeighbours, int serverPort, boolean acceptDC, String localInetAddress, boolean UPnP2) {
        super(id, maxNeighbours, serverPort, acceptDC, localInetAddress, UPnP2);
        processProbability += (int)(System.currentTimeMillis() % 25L);
        WarriorAnt.checkChunksPath();
    }

    public synchronized void setWritingFile() {
        this.writingFileLock = new Integer(this.writingFileLock + 1);
    }

    public synchronized void resetWritingFile() {
        this.writingFileLock = new Integer(this.writingFileLock - 1);
    }

    public void disconnectWarrior() {
        while (this.writingFileLock > 0) {
            try {
                WarriorAnt.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (InetAddressEngine.getInstance() != null) {
            InetAddressEngine.getInstance().terminate();
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleDownload(QueryFileTuple qft) {
        List list = this.scheduledDownloads;
        synchronized (list) {
            if (this.scheduledDownloads.contains(qft)) {
                return;
            }
            if (this.scheduledDownloads.size() > maxScheduledDownloads) {
                this.scheduledDownloads.remove(0);
            }
            this.scheduledDownloads.add(qft);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleDownload(String fileHash) {
        List list = this.scheduledDownloads;
        synchronized (list) {
            for (int x = this.scheduledDownloads.size() - 1; x >= 0; --x) {
                QueryFileTuple qft = (QueryFileTuple)this.scheduledDownloads.get(x);
                if (!fileHash.equals(qft.getFileHash())) continue;
                this.scheduledDownloads.remove(x);
            }
        }
    }

    public void scheduleHttpProxy(HttpServerInfo httpServer) {
        if (this.scheduledHttpProxy.contains(httpServer)) {
            return;
        }
        if (this.scheduledHttpProxy.size() > maxScheduledHttpProxy) {
            this.scheduledHttpProxy.remove(0);
        }
        this.scheduledHttpProxy.add(httpServer);
    }

    synchronized void checkScheduledDownloads(EndpointSecurityManager esm) throws Exception {
        for (int x = this.scheduledDownloads.size() - 1; x >= 0; --x) {
            QueryFileTuple qft = (QueryFileTuple)this.scheduledDownloads.get(x);
            if (!esm.getPeerId().equals(qft.getOwnerID())) continue;
            this.scheduledDownloads.remove(x);
            this.propertyChangeSupport.firePropertyChange("addSourcePeer", null, qft);
        }
    }

    synchronized void checkScheduledHttpProxy(EndpointSecurityManager esm) {
        for (int x = this.scheduledHttpProxy.size() - 1; x >= 0; --x) {
            HttpServerInfo httpServer = (HttpServerInfo)this.scheduledHttpProxy.get(x);
            if (!esm.getPeerId().equals(httpServer.getOwnerId())) continue;
            this.scheduledHttpProxy.remove(x);
            this.createProxy(esm);
        }
    }

    public static void setHttpServerProperties(String homePage, String description) {
        httpHomePage = homePage;
        httpServerDescription = description;
    }

    public static String getHttpServerDescription() {
        return httpServerDescription;
    }

    public static String getHttpServerHomePage() {
        return httpHomePage;
    }

    public static int getHttpLocalServerPort() {
        return httpLocalServerPort;
    }

    public static int getHttpProxyPort() {
        return httpProxyPort;
    }

    public static void setHttpLocalServerPort(int port) {
        if (port >= 0 && port < 65536) {
            httpLocalServerPort = port;
        }
    }

    public static void setHttpProxyPort(int port) {
        if (port >= 0 && port < 65536) {
            httpProxyPort = port;
        }
    }

    public static void httpEnabled(boolean enabled) {
        httpRunning = enabled;
    }

    public void getHttpServers() {
        try {
            QueryHttpServerItem httpItem = new QueryHttpServerItem(null);
            AsymmetricProvider ap = new AsymmetricProvider(false);
            QueryMessage qm = new QueryMessage(httpItem, ap.getPublicHeader());
            if (this.getNeighboursNumber() > 0) {
                MessageWrapper wm = this.sendBroadcastMessage(qm);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
        }
    }

    public HttpProxy getCurrentProxy() {
        return this.httpProxy;
    }

    public void resetCurrentProxy() {
        if (this.httpProxy != null) {
            try {
                if (this.httpProxy.terminate()) {
                    this.httpProxy = null;
                    this.propertyChangeSupport.firePropertyChange("currentProxyChanged", null, this.httpProxy);
                }
            }
            catch (Exception e) {
                _logger.error((Object)("Error in stoppoing proxy: " + this.httpProxy.getPort()), (Throwable)e);
            }
        }
    }

    public static boolean isHttpEnabled() {
        return httpRunning;
    }

    public static boolean isSupernode() {
        return NeighbourAnt.bandwidthLimit > 61440;
    }

    public void createSecureConnection(final String peerId, final boolean force) {
        final WarriorAnt currentAnt = this;
        if (this.getIdent().equals(peerId)) {
            return;
        }
        Thread secureConnectionCreator = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (WarriorAnt.this.outputSecureConnections.size() >= maxSecureConnections) {
                        return;
                    }
                    List list = WarriorAnt.this.pendingSecureRequest;
                    synchronized (list) {
                        EndpointSecurityManager esm;
                        int x;
                        for (x = WarriorAnt.this.pendingSecureRequest.size() - 1; x >= 0; --x) {
                            esm = (EndpointSecurityManager)WarriorAnt.this.pendingSecureRequest.get(x);
                            if (System.currentTimeMillis() - esm.getLastTimeUsed() <= Ant.messageTimeout * (long)Ant.maxRetransmissions) continue;
                            WarriorAnt.this.pendingSecureRequest.remove(x);
                            esm.resetLastTimeUsed();
                        }
                        for (x = WarriorAnt.this.pendingSecureRequest.size() - 1; x >= 0; --x) {
                            esm = (EndpointSecurityManager)WarriorAnt.this.pendingSecureRequest.get(x);
                            if (esm.getPeerId().equals(peerId) && !force) {
                                return;
                            }
                            if (!esm.getPeerId().equals(peerId) || !force) continue;
                            WarriorAnt.this.pendingSecureRequest.remove(x);
                            esm.resetLastTimeUsed();
                        }
                        _logger.info((Object)(WarriorAnt.this.getShortId() + " Creating secure connection"));
                        for (x = WarriorAnt.this.outputSecureConnections.size() - 1; x >= 0; --x) {
                            esm = (EndpointSecurityManager)WarriorAnt.this.outputSecureConnections.get(x);
                            if (!esm.getPeerId().equals(peerId)) continue;
                            WarriorAnt.this.outputSecureConnections.remove(esm);
                            esm.resetLastTimeUsed();
                        }
                        EndpointSecurityManager endpointSecurityManager = new EndpointSecurityManager(currentAnt, peerId);
                    }
                }
                catch (Exception e) {
                    _logger.error((Object)"Secure connection creation error", (Throwable)e);
                }
            }
        };
        secureConnectionCreator.setPriority(10);
        secureConnectionCreator.start();
    }

    public void removeInputSecureConnection(String peerId) {
        for (int x = this.inputSecureConnections.size() - 1; x >= 0; --x) {
            if (!((EndpointSecurityManager)this.inputSecureConnections.get(x)).getPeerId().equals(peerId)) continue;
            this.inputSecureConnections.remove(this.inputSecureConnections.get(x));
        }
    }

    public void removeOutputSecureConnection(String peerId) {
        for (int x = this.outputSecureConnections.size() - 1; x >= 0; --x) {
            if (!((EndpointSecurityManager)this.outputSecureConnections.get(x)).getPeerId().equals(peerId)) continue;
            this.outputSecureConnections.remove(this.outputSecureConnections.get(x));
        }
    }

    public void sendPrivateChatMessage(String peerId, String message, boolean initiator) throws Exception {
        EndpointSecurityManager esm;
        EndpointSecurityManager endpointSecurityManager = esm = initiator ? this.getOutputSecureConnectionManager(peerId) : this.getInputSecureConnectionManager(peerId);
        if (esm == null) {
            SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
            MessageWrapper wm = this.sendMessage(fterrcm, peerId, false, false);
            _logger.debug((Object)(this.getShortId() + ": No secure connection with " + peerId));
            while (this.myMessages.contains(wm) && !this.isDisconnected()) {
                Thread.sleep(1000L);
            }
            if (this.failedMessages.contains(wm)) {
                this.failedMessages.remove(wm);
                _logger.debug((Object)(this.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
            }
            throw new Exception("No secure connection avaiable with endpoint " + peerId);
        }
        PrivateChatMessage pcm = new PrivateChatMessage(message);
        MessageWrapper wm = null;
        pcm.encrypt(esm.getCipherEnc());
        wm = this.sendMessage(pcm, peerId, true, false);
        this.propertyChangeSupport.firePropertyChange("privateChatMessageSending", null, pcm);
        while (this.myMessages.contains(wm)) {
            Thread.sleep(1000L);
        }
        if (this.failedMessages.contains(wm)) {
            pcm.decrypt(esm.getCipherDec());
            this.failedMessages.remove(wm);
            this.propertyChangeSupport.firePropertyChange("privateChatMessageFailed", null, pcm);
            return;
        }
        pcm.decrypt(esm.getCipherDec());
        this.propertyChangeSupport.firePropertyChange("privateChatMessageDelivered", null, pcm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullFile(String fileName, String fileHash, long offset, long blocks, String peerId, int blockSize, String localFileName, boolean resume) throws Exception {
        EndpointSecurityManager esm = this.getOutputSecureConnectionManager(peerId);
        if (esm == null) {
            throw new Exception("No secure connection avaiable with endpoint " + peerId);
        }
        FilePullMessage frm = new FilePullMessage(fileName, Base16.fromHexString(fileHash), new Long(offset), new Long(blocks), new Integer(blockSize), localFileName, new Boolean(resume));
        MessageWrapper wm = null;
        frm.encrypt(esm.getCipherEnc());
        wm = this.sendMessage(frm, peerId, false, false);
        List list = this.pendingFilePullRequests;
        synchronized (list) {
            FilePullMessage fpr;
            int x;
            FilePullMessage frmCopia = new FilePullMessage(frm, fileName, Base16.fromHexString(fileHash), new Long(offset), new Long(blocks), new Integer(blockSize), localFileName, new Boolean(resume));
            boolean removed = false;
            for (x = this.pendingFilePullRequests.size() - 1; x >= 0; --x) {
                fpr = ((FilePullMessageWrapper)this.pendingFilePullRequests.get(x)).getFilePullMessage();
                if (!fpr.getDest().equals(frmCopia.getDest()) || !WarriorAnt.compareHash(fpr.getHash(), frmCopia.getHash()) || !fpr.getLocalFileName().equals(frmCopia.getLocalFileName()) || !fpr.getBlocks().equals(frmCopia.getBlocks()) || !fpr.getBlockSize().equals(frmCopia.getBlockSize()) || !fpr.getOffset().equals(frmCopia.getOffset())) continue;
                this.pendingFilePullRequests.remove(x);
                removed = true;
            }
            for (x = this.inServiceFilePushRequests.size() - 1; x >= 0; --x) {
                fpr = (FilePullMessage)this.inServiceFilePushRequests.get(x);
                if (!fpr.getDest().equals(frmCopia.getDest()) || !WarriorAnt.compareHash(fpr.getHash(), frmCopia.getHash()) || !fpr.getLocalFileName().equals(frmCopia.getLocalFileName()) || !fpr.getBlocks().equals(frmCopia.getBlocks()) || !fpr.getBlockSize().equals(frmCopia.getBlockSize()) || !fpr.getOffset().equals(frmCopia.getOffset())) continue;
                this.inServiceFilePushRequests.remove(x);
                removed = true;
            }
            if (!removed && this.pendingFilePullRequests.size() >= maxOwnPullRequestsToTrace) {
                this.pendingFilePullRequests.remove(0);
            }
            this.pendingFilePullRequests.add(new FilePullMessageWrapper(frmCopia));
        }
        while (this.myMessages.contains(wm)) {
            Thread.sleep(1000L);
        }
        if (this.failedMessages.contains(wm)) {
            frm.decrypt(esm.getCipherDec());
            this.failedMessages.remove(wm);
            _logger.debug((Object)(this.getShortId() + ": Error in sending PullFileMessage " + frm.getFileName() + " - Cannot send pull request to id " + frm.getDest()));
            this.propertyChangeSupport.firePropertyChange("filePullRequestError", null, frm);
            return;
        }
    }

    public void pullFileInfos(String hash, String peerId, boolean getChunkHashes) throws Exception {
        EndpointSecurityManager esm = this.getOutputSecureConnectionManager(peerId);
        if (esm == null) {
            throw new Exception("No secure connection avaiable with endpoint " + peerId);
        }
        FileInfosPullMessage frm = new FileInfosPullMessage(Base16.fromHexString(hash), getChunkHashes);
        MessageWrapper wm = null;
        frm.encrypt(esm.getCipherEnc());
        wm = this.sendMessage(frm, peerId, false, false);
        while (this.myMessages.contains(wm)) {
            Thread.sleep(1000L);
        }
        if (this.failedMessages.contains(wm)) {
            this.failedMessages.remove(wm);
            frm.decrypt(esm.getCipherDec());
            _logger.debug((Object)(this.getShortId() + ": Error in sending PullFileInfosMessage " + Base16.toHexString(frm.getHash()) + " - Cannot send pull request to id " + frm.getDest()));
            throw new Exception("Error in sending PullFileInfosMessage " + peerId);
        }
    }

    public void pullFileSize(String fileName, String fileHash, String peerId) throws Exception {
        EndpointSecurityManager esm = this.getOutputSecureConnectionManager(peerId);
        if (esm == null) {
            throw new Exception("No secure connection avaiable with endpoint " + peerId);
        }
        FileSizePullMessage fsrm = new FileSizePullMessage(fileName, Base16.fromHexString(fileHash));
        fsrm.encrypt(esm.getCipherEnc());
        MessageWrapper wm = this.sendMessage(fsrm, peerId, true, false);
        while (this.myMessages.contains(wm)) {
            Thread.sleep(1000L);
        }
        if (this.failedMessages.contains(wm)) {
            this.failedMessages.remove(wm);
            fsrm.decrypt(esm.getCipherDec());
            _logger.debug((Object)(this.getShortId() + ": Error in sending PullFileSizeMessage " + fsrm.getFileName() + " - Cannot send pull request to id " + fsrm.getDest()));
            this.propertyChangeSupport.firePropertyChange("fileSizePullError", null, fsrm);
            return;
        }
    }

    public void getALanServer() {
        try {
            _logger.info((Object)"Searching for lan peers...OK");
            DeviceList rootDevList = UPnPManager.instance().getDeviceList();
            int nDevs = rootDevList.size();
            for (int n = 0; n < nDevs; ++n) {
                Device dev = rootDevList.getDevice(n);
                if (!dev.getDeviceType().equals("urn:schemas-upnp-org:device:antsp2p:1") || !dev.isRootDevice()) continue;
                Service service = dev.getService("urn:schemas-upnp-org:service:address:1");
                Action action = service.getAction("GetLANAddress");
                boolean ctrlRes = action.postControlAction();
                if (ctrlRes) {
                    Argument arg = action.getArgument("LANAddress");
                    String value = arg.getValue();
                    String[] addressPort = value.split(":");
                    ServerInfo si = new ServerInfo("", addressPort[0], new Integer(addressPort[1]), "");
                    ArrayList<ServerInfo> resultSet = new ArrayList<ServerInfo>();
                    resultSet.add(si);
                    System.out.print(si);
                    this.propertyChangeSupport.firePropertyChange("inetAddressQueryCompleted", null, resultSet);
                    continue;
                }
                UPnPStatus err = action.getControlStatus();
                _logger.error((Object)(err.getDescription() + " (" + Integer.toString(err.getCode()) + ")"));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot search peers in the local LAN", (Throwable)e);
        }
    }

    public void getServersWithFreeSlots() {
        try {
            QueryInetAddressItem qia = new QueryInetAddressItem(null);
            AsymmetricProvider ap = new AsymmetricProvider(false);
            QueryMessage qm = new QueryMessage(qia, ap.getPublicHeader());
            QueryMessage qmLocal = new QueryMessage(qm);
            QueryManager queryManager = new QueryManager(qmLocal, this);
            queryManager = new QueryManager(this, qmLocal);
            this.propertyChangeSupport.firePropertyChange("inetAddressQueryCompleted", null, queryManager.resultSet);
            if (this.getNeighboursNumber() > 0) {
                MessageWrapper wm = this.sendBroadcastMessage(qm);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
        }
    }

    public MessageWrapper doSupernodeQuery() {
        try {
            QuerySupernodeItem qsi = new QuerySupernodeItem(null);
            AsymmetricProvider ap = new AsymmetricProvider(false);
            QueryMessage qm = new QueryMessage(qsi, ap.getPublicHeader());
            if (this.getNeighboursNumber() > 0) {
                MessageWrapper wm = this.sendBroadcastMessage(qm);
                return wm;
            }
            return null;
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
            return null;
        }
    }

    public synchronized ArrayList getServersWithFreeSlots(InetAddress host, int port, InetAddress localhost) {
        Socket local = null;
        try {
            if (!InetAddressWatchdog.getInstance().allowedAddress(host.getHostAddress())) {
                return null;
            }
            local = SSLProvider.getSSLSecuredSocket(host.getHostAddress(), port, proxied);
            local.getOutputStream().write(1);
            local.getOutputStream().flush();
            ObjectInputStream ois = new ObjectInputStream(local.getInputStream());
            ArrayList peers = (ArrayList)ois.readObject();
            for (int x = peers.size() - 1; x >= 0; --x) {
                ServerInfo peer = (ServerInfo)peers.get(x);
                if (!peer.getAddress().equals(localhost) || peer.getPort().intValue() != this.getServerPort()) continue;
                peers.remove(peer);
            }
            ois.close();
            return peers;
        }
        catch (Exception e) {
            _logger.error((Object)("Failed to get peers infos: " + e.getMessage()));
            if (local != null) {
                try {
                    local.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public MessageWrapper doQuery(QueryNode query, PublicHeader ph) throws Exception {
        QueryMessage qm = new QueryMessage(query, ph);
        MessageWrapper wm = this.sendBroadcastMessage(qm);
        return wm;
    }

    public MessageWrapper[] doSupernodeQuery(QueryNode query, PublicHeader ph, List supernodeSet) throws Exception {
        Iterator superNodes = supernodeSet.iterator();
        ArrayList<MessageWrapper> messages = new ArrayList<MessageWrapper>();
        while (superNodes.hasNext()) {
            String curSupernode = (String)superNodes.next();
            MessageWrapper qw = this.doQuery(query, ph, curSupernode);
            if (qw == null || qw.getMessage() == null) continue;
            messages.add(qw);
        }
        MessageWrapper[] mw = new MessageWrapper[messages.size()];
        for (int x = 0; x < messages.size(); ++x) {
            mw[x] = (MessageWrapper)messages.get(x);
        }
        return mw;
    }

    private MessageWrapper doQuery(QueryNode query, PublicHeader ph, String dest) throws Exception {
        QueryMessage qm = new QueryMessage(query, ph);
        MessageWrapper wm = this.sendMessage(qm, dest, false, false);
        return wm;
    }

    public QueryMessage doRandomQuery(long timeToLive) {
        try {
            QueryRandomItem qri = new QueryRandomItem(null);
            AsymmetricProvider ap = new AsymmetricProvider(false);
            QueryMessage qm = new QueryMessage(qri, ap.getPublicHeader());
            if (this.getNeighboursNumber() > 0) {
                MessageWrapper wm = this.sendBroadcastMessage(qm);
                return qm;
            }
            return null;
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
            return null;
        }
    }

    public boolean areInMyMessages(ArrayList list) {
        for (int x = 0; x < list.size(); ++x) {
            if (!this.myMessages.contains(list.get(x))) continue;
            return true;
        }
        return false;
    }

    public ArrayList removeDeliveredMessagesFromList(ArrayList list) {
        for (int x = list.size() - 1; x >= 0; --x) {
            if (this.myMessages.contains(list.get(x)) || this.failedMessages.contains(list.get(x))) continue;
            list.remove(x);
        }
        return list;
    }

    public boolean areInFailedMessages(ArrayList list) {
        for (int x = 0; x < list.size(); ++x) {
            if (!this.failedMessages.contains(list.get(x))) continue;
            return true;
        }
        return false;
    }

    public static void checkChunksPath() {
        WarriorAnt.checkChuncksHome();
        File cpf = new File(chunksHome + chunksPath);
        if (cpf.exists() && !cpf.isDirectory()) {
            cpf.delete();
            cpf.mkdir();
        } else if (!cpf.exists()) {
            cpf.mkdir();
        }
    }

    public static void checkPreviewPath() {
        File cpf = new File(previewsPath);
        if (cpf.exists() && !cpf.isDirectory()) {
            cpf.delete();
            cpf.mkdir();
        } else if (!cpf.exists()) {
            cpf.mkdir();
        }
    }

    public static void checked2kPath() {
        File cpf = new File(ed2kPath);
        boolean created = false;
        if (cpf.exists() && !cpf.isDirectory()) {
            cpf.delete();
            cpf.mkdir();
            created = true;
        } else if (!cpf.exists()) {
            cpf.mkdir();
            created = true;
        }
        if (created) {
            int read;
            byte[] buff;
            FileOutputStream fos;
            InputStream is;
            URL url = new Base16().getClass().getClassLoader().getResource("anims/ed2k_1.gif");
            if (url != null) {
                try {
                    is = url.openStream();
                    fos = new FileOutputStream(new File(ed2kPath + "ed2k_1.gif"));
                    while (is.available() > 0) {
                        buff = new byte[500000];
                        read = is.read(buff);
                        fos.write(buff, 0, read);
                    }
                    fos.close();
                }
                catch (Exception e) {
                    _logger.error((Object)"Error in copying picture to ed2k folder", (Throwable)e);
                }
            }
            if ((url = new Base16().getClass().getClassLoader().getResource("anims/ed2k_2.gif")) != null) {
                try {
                    is = url.openStream();
                    fos = new FileOutputStream(new File(ed2kPath + "ed2k_2.gif"));
                    while (is.available() > 0) {
                        buff = new byte[500000];
                        read = is.read(buff);
                        fos.write(buff, 0, read);
                    }
                    fos.close();
                }
                catch (Exception e) {
                    _logger.error((Object)"Error in copying picture to ed2k folder", (Throwable)e);
                }
            }
        }
    }

    public static void checkChuncksHome() {
        File cpf = new File(chunksHome);
        if (cpf.exists() && !cpf.isDirectory()) {
            cpf.delete();
            cpf.mkdir();
        } else if (!cpf.exists()) {
            cpf.mkdir();
        }
    }

    public static void checkDownloadPath() {
        File cpf = new File(downloadPath);
        if (cpf.exists() && !cpf.isDirectory()) {
            cpf.delete();
            cpf.mkdir();
        } else if (!cpf.exists()) {
            cpf.mkdir();
        }
    }

    public void createProxy(EndpointSecurityManager esm) {
        try {
            if (this.httpProxy != null && !this.httpProxy.terminate()) {
                throw new Exception("Active proxy not stopped");
            }
            this.httpProxy = new HttpProxy(httpProxyPort, esm.getPeerId(), this);
            this.propertyChangeSupport.firePropertyChange("currentProxyChanged", null, this.httpProxy);
            _logger.info((Object)("Proxy to " + esm.getPeerId() + " started on port " + this.httpProxy.getPort()));
        }
        catch (Exception e) {
            _logger.error((Object)"Error in creating proxy", (Throwable)e);
        }
    }

    protected void processMessage(final Message m, final Router r) {
        Thread processor = new Thread(){

            public void run() {
                WarriorAnt.this.processMessageThread(m, r);
            }
        };
        processor.start();
    }

    protected void processMessageThread(Message m, Router r) {
        _logger.debug((Object)("Processing message: ID " + m.getAck_Id() + " Type: " + m.getType() + " From: " + m.getSource() + " To: " + m.getDest()));
        try {
            if (m.getType() == 1 && m instanceof QueryMessage) {
                this.processQueryMessage((QueryMessage)m, r);
            } else if (m.getType() != 1 && m.getType() != 1) {
                if (m instanceof FilePushMessage) {
                    this.processFilePushMessage((FilePushMessage)m, r);
                }
                if (m instanceof FileSizePushMessage) {
                    this.processFileSizePushMessage((FileSizePushMessage)m, r);
                }
                if (m instanceof FilePullMessage) {
                    this.processFilePullMessage((FilePullMessage)m, r);
                }
                if (m instanceof FileInfosPullMessage) {
                    this.processFileInfosPullMessage((FileInfosPullMessage)m, r);
                }
                if (m instanceof FileInfosPushMessage) {
                    this.processFileInfosPushMessage((FileInfosPushMessage)m, r);
                }
                if (m instanceof FileSizePullMessage) {
                    this.processFileSizePullMessage((FileSizePullMessage)m, r);
                }
                if (m instanceof FilePartMessage) {
                    this.processFilePartMessage((FilePartMessage)m, r);
                }
                if (m instanceof ControlMessage) {
                    this.processControlMessage((ControlMessage)m, r);
                }
                if (m instanceof SecurityRequestMessage) {
                    this.processSecurityRequestMessage((SecurityRequestMessage)m, r);
                }
                if (m instanceof SecurityResponseMessage) {
                    this.processSecurityResponseMessage((SecurityResponseMessage)m, r);
                }
                if (m instanceof QueryMessage) {
                    this.processQueryMessage((QueryMessage)m, r);
                }
                if (m instanceof HttpRequestMessage) {
                    this.processHttpRequestMessage((HttpRequestMessage)m, r);
                }
                if (m instanceof HttpResponsePartMessage) {
                    this.processHttpResponsePartMessage((HttpResponsePartMessage)m, r);
                }
                if (m instanceof PrivateChatMessage) {
                    this.processPrivateChatMessage((PrivateChatMessage)m, r);
                }
            }
            _logger.debug((Object)("Processed message: ID " + m.getAck_Id() + " Type: " + m.getType() + " From: " + m.getSource() + " To: " + m.getDest()));
        }
        catch (Exception e) {
            _logger.error((Object)(this.getShortId() + ": Error In Processing message: id = " + m.getAck_Id() + " Source: " + m.getSource() + " Dest: " + m.getDest()), (Throwable)e);
        }
    }

    private void processFileInfosPullMessage(FileInfosPullMessage fipm, Router r) throws Exception {
        try {
            EndpointSecurityManager esm = this.getInputSecureConnectionManager(fipm.getSource());
            if (esm == null) {
                SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                MessageWrapper wm = this.sendMessage(fterrcm, fipm.getSource(), false, false);
                _logger.debug((Object)(this.getShortId() + ": No secure connection with " + fipm.getSource()));
                while (this.myMessages.contains(wm) && !this.isDisconnected()) {
                    Thread.sleep(1000L);
                }
                if (this.failedMessages.contains(wm)) {
                    this.failedMessages.remove(wm);
                    _logger.debug((Object)(this.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                }
                throw new Exception("No secure connection avaiable with endpoint " + fipm.getSource());
            }
            fipm.decrypt(esm.getCipherDec());
            byte[] hash = fipm.getHash();
            QueryFileTuple qft = null;
            BackgroundEngine be = BackgroundEngine.getInstance();
            FileInfos fi = be.getLocalFile(Base16.toHexString(hash), QueryHashItem.ANTS_HASH);
            Object pfi = be.getPartialFile(Base16.toHexString(hash), QueryHashItem.ANTS_HASH);
            if (fi != null) {
                qft = new QueryCompletedFileTuple(null, new File(fi.getName()).getName(), fi.getHash(), fi.getED2KHash(), fipm.getChunkHashes() ? fi.getChunckHashes() : null, new Long(fi.getSize()), this.getIdent(), this.getLocalInetAddress(), new Integer(maxPullRequestsToServe - this.inServiceFilePullRequests.size()), ConnectionType, fi.getExtendedInfos(), fi.getComment());
            } else if (pfi != null) {
                qft = be.getPartialFileTuple(null, Base16.toHexString(hash), QueryHashItem.ANTS_HASH, this.getIdent(), new Integer(maxPullRequestsToServe - this.inServiceFilePullRequests.size()), ConnectionType, fipm.getChunkHashes());
            } else {
                FileInfosPullErrorControlMessage fterrcm = new FileInfosPullErrorControlMessage(new Integer(0), hash, "File don't exist");
                fterrcm.encrypt(esm.getCipherEnc());
                MessageWrapper wm = this.sendMessage(fterrcm, fipm.getSource(), false, false);
                _logger.debug((Object)(this.getShortId() + ": File " + Base16.toHexString(fipm.getHash()) + " don't exist. Cannot serve pull request from id " + fipm.getSource()));
                while (this.myMessages.contains(wm)) {
                    Thread.sleep(1000L);
                }
                if (this.failedMessages.contains(wm)) {
                    this.failedMessages.remove(wm);
                    fterrcm.decrypt(esm.getCipherDec());
                    _logger.debug((Object)(this.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                    return;
                }
                return;
            }
            FileInfosPushMessage firm = new FileInfosPushMessage(hash, qft);
            firm.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.sendMessage(firm, fipm.getSource(), false, false);
            while (this.myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (this.failedMessages.contains(wm)) {
                this.failedMessages.remove(wm);
                firm.decrypt(esm.getCipherDec());
                _logger.debug((Object)(this.getShortId() + ": Error in sending FileSizePushMessage " + Base16.toHexString(firm.getHash()) + " - Cannot serve pull request from id " + fipm.getSource()));
                return;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            throw new Exception(this.getShortId() + ": Error In Processing FileInfosPullMessage: id = " + fipm.getAck_Id() + " Source: " + fipm.getSource() + " Dest: " + fipm.getDest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileSizePullMessage(FileSizePullMessage fspm, Router r) throws Exception {
        try {
            EndpointSecurityManager esm = this.getInputSecureConnectionManager(fspm.getSource());
            if (esm == null) {
                SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                MessageWrapper wm = this.sendMessage(fterrcm, fspm.getSource(), false, false);
                _logger.debug((Object)(this.getShortId() + ": No secure connection with " + fspm.getSource()));
                while (this.myMessages.contains(wm) && !this.isDisconnected()) {
                    Thread.sleep(1000L);
                }
                if (this.failedMessages.contains(wm)) {
                    this.failedMessages.remove(wm);
                    _logger.debug((Object)(this.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                }
                throw new Exception("No secure connection avaiable with endpoint " + fspm.getSource());
            }
            fspm.decrypt(esm.getCipherDec());
            byte[] hash = fspm.getHash();
            File f = new File(fspm.getFileName());
            if (!f.exists()) {
                FileSizePullErrorControlMessage fterrcm = new FileSizePullErrorControlMessage(new Integer(0), hash, "File don't exist");
                fterrcm.encrypt(esm.getCipherEnc());
                MessageWrapper wm = this.sendMessage(fterrcm, fspm.getSource(), false, false);
                _logger.debug((Object)(this.getShortId() + ": File " + fspm.getFileName() + " don't exist. Cannot serve pull request from id " + fspm.getSource()));
                while (this.myMessages.contains(wm)) {
                    Thread.sleep(1000L);
                }
                if (this.failedMessages.contains(wm)) {
                    this.failedMessages.remove(wm);
                    fterrcm.decrypt(esm.getCipherDec());
                    _logger.debug((Object)(this.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                    return;
                }
                return;
            }
            FileSizePushMessage fsrm = new FileSizePushMessage(f.getName(), hash, new Long(f.length()));
            fsrm.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.sendMessage(fsrm, fspm.getSource(), false, false);
            while (this.myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (this.failedMessages.contains(wm)) {
                this.failedMessages.remove(wm);
                fsrm.decrypt(esm.getCipherDec());
                _logger.debug((Object)(this.getShortId() + ": Error in sending FileSizePushMessage " + fsrm.getFileName() + " - Cannot serve pull request from id " + fspm.getSource()));
                return;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            List list = this.inServiceFilePullRequests;
            synchronized (list) {
                if (this.inServiceFilePullRequests.contains(fspm)) {
                    this.inServiceFilePullRequests.remove(fspm);
                }
            }
            throw new Exception(this.getShortId() + ": Error In Processing FileSizePullMessage: id = " + fspm.getAck_Id() + " Source: " + fspm.getSource() + " Dest: " + fspm.getDest());
        }
    }

    private void processQueryMessage(QueryMessage qm, Router r) throws Exception {
        block16: {
            try {
                if ((qm.getType() == 2 || qm.getType() == 0 && !this.inTransitMessages.contains(qm)) && !qm.getProcessed()) {
                    double mustProcess = Math.random() * 100.0;
                    if ((qm.getType() == 0 || mustProcess < (double)processProbability) && !qm.getSource().equals(this.getIdent())) {
                        _logger.debug((Object)(this.getShortId() + "Processing Query"));
                        QueryResultSenderThread qrst = new QueryResultSenderThread(this, qm, r);
                        qrst.run();
                        _logger.debug((Object)(this.getShortId() + ": Processed query by " + qm.getSource().substring(0, 10) + "."));
                    } else {
                        _logger.debug((Object)"Unprocessed Query");
                    }
                    break block16;
                }
                if ((qm.getType() == 1 || qm.getType() == 0) && qm.getProcessed()) {
                    QueryManager queryManager = new QueryManager(this, qm);
                    if (qm.getQuery() instanceof QuerySupernodeItem) {
                        _logger.info((Object)"Ricevuta parte di query supernode");
                        this.propertyChangeSupport.firePropertyChange("supernodeQueryCompleted", qm, queryManager.resultSet);
                    } else if (qm.getQuery() instanceof QueryInetAddressItem) {
                        _logger.info((Object)"Ricevuta parte di query inetAddress");
                        this.propertyChangeSupport.firePropertyChange("inetAddressQueryCompleted", null, queryManager.resultSet);
                    } else if (qm.getQuery() instanceof QueryHttpServerItem) {
                        _logger.info((Object)"Ricevuta parte di http server query");
                        this.propertyChangeSupport.firePropertyChange("httpServerQueryCompleted", qm, queryManager.resultSet);
                    } else {
                        if (queryManager.resultSet.size() > 0 && queryManager.resultSet.get(0) instanceof HttpServerInfo) {
                            ArrayList httpResultSet = new ArrayList();
                            httpResultSet.add(queryManager.resultSet.get(0));
                            _logger.info((Object)"Ricevuta parte di http server query");
                            this.propertyChangeSupport.firePropertyChange("httpServerQueryCompleted", qm, httpResultSet);
                            queryManager.resultSet.remove(0);
                        }
                        for (int x = 0; x < queryManager.resultSet.size() && this.acceptTCPDirectConnections; ++x) {
                            RoutingTableElement rte;
                            QueryFileTuple qft;
                            if (queryManager.resultSet.get(x) == null || (qft = (QueryFileTuple)queryManager.resultSet.get(x)).getOwnerIP().equals("") || qft.getOwnerID().equals(this.getIdent())) continue;
                            if (this.routingTable.get(qft.getOwnerID()) != null) {
                                rte = (RoutingTableElement)this.routingTable.get(qft.getOwnerID());
                                rte.setIP(qft.getOwnerIP());
                                continue;
                            }
                            rte = new RoutingTableElement();
                            rte.setIP(qft.getOwnerIP());
                            this.routingTable.put(qft.getOwnerID(), rte);
                        }
                        this.propertyChangeSupport.firePropertyChange("queryCompleted", qm, queryManager.resultSet);
                        String source = qm.getSource();
                        if (source.length() > 10) {
                            source = source.substring(0, 10);
                        }
                        _logger.info((Object)("Ricevuta parte di query file[" + source + "]: " + qm.getQuery() + " " + qm.getTuples().get(0) + " " + qm.getTuples().size()));
                    }
                    break block16;
                }
                throw new Exception(this.getShortId() + ": Error In Processing query. Source: " + qm.getSource());
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
                throw new Exception(this.getShortId() + ": Error In Processing query. Source: " + qm.getSource() + "\nMessage dump: type " + qm.getType() + "  processed: " + qm.getProcessed() + "  delivered: " + qm.getDelivered());
            }
        }
    }

    private void processFilePullMessage(FilePullMessage fpm, Router r) throws Exception {
        if (this.getNeighbour(r.getRequirer()) != null) {
            this.getNeighbour(r.getRequirer()).setLastActiveUploadTime();
        }
        _logger.info((Object)("Set last active upload for " + r.getRequirer()));
        _logger.info((Object)("Running FilePullMessageProcessor. Free slots: " + (maxPullRequestsToServe - this.inServiceFilePullRequests.size())));
        FilePullMessageProcessor fpmp = new FilePullMessageProcessor(this, fpm);
        fpmp.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInServiceFilePullRequests(boolean addThis, final FilePullMessage fpm) {
        List list = this.inServiceFilePullRequests;
        synchronized (list) {
            if (this.inServiceFilePullRequests.contains(fpm)) {
                _logger.info((Object)(this.getShortId() + ": Found in service file pull! Rejecting message"));
                return true;
            }
            for (int x = 0; x < this.inServiceFilePullRequests.size(); ++x) {
                FilePullMessage currentFpM = (FilePullMessage)this.inServiceFilePullRequests.get(x);
                if (currentFpM == null || !currentFpM.getBlocks().equals(fpm.getBlocks()) || !currentFpM.getBlockSize().equals(fpm.getBlockSize()) || !currentFpM.getFileName().equals(fpm.getFileName()) || !WarriorAnt.compareHash(currentFpM.getHash(), fpm.getHash()) || !currentFpM.getLocalFileName().equals(fpm.getLocalFileName()) || !currentFpM.getOffset().equals(fpm.getOffset()) || !currentFpM.getResume().equals(fpm.getResume()) || !currentFpM.getSource().equals(fpm.getSource())) continue;
                _logger.info((Object)(this.getShortId() + ": Found in service file pull! Rejecting message"));
                return true;
            }
            _logger.info((Object)(this.getShortId() + ": Not Found in service file pull! Processing message"));
            if (addThis) {
                if (this.inServiceFilePullRequests.size() >= maxPullRequestsToServe) {
                    Thread notifier;
                    _logger.info((Object)(this.getShortId() + ": Already serving max request! Rejecting message"));
                    final EndpointSecurityManager esm = this.getInputSecureConnectionManager(fpm.getSource());
                    if (esm == null) {
                        notifier = new Thread(){

                            public void run() {
                                try {
                                    SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                                    MessageWrapper wm = WarriorAnt.this.sendMessage(fterrcm, fpm.getSource(), false, false);
                                    _logger.debug((Object)(WarriorAnt.this.getShortId() + ": No secure connection with " + fpm.getSource()));
                                    while (WarriorAnt.this.myMessages.contains(wm) && !WarriorAnt.this.isDisconnected()) {
                                        3.sleep(1000L);
                                    }
                                    if (WarriorAnt.this.failedMessages.contains(wm)) {
                                        WarriorAnt.this.failedMessages.remove(wm);
                                        _logger.debug((Object)(WarriorAnt.this.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                                    }
                                    _logger.error((Object)("No secure connection avaiable with endpoint " + fpm.getSource()));
                                }
                                catch (Exception e) {
                                    _logger.error((Object)"Exception while trying to notify secure connection error", (Throwable)e);
                                }
                            }
                        };
                        notifier.start();
                        return true;
                    }
                    notifier = new Thread(){

                        public void run() {
                            try {
                                FileTransferErrorControlMessage cm = new FileTransferErrorControlMessage(new Integer(1), fpm.getHash(), "No free slots", fpm);
                                cm.encrypt(esm.getCipherEnc());
                                MessageWrapper wm2 = WarriorAnt.this.sendMessage(cm, fpm.getSource(), false, false);
                                while (WarriorAnt.this.myMessages.contains(wm2)) {
                                    Thread.sleep(1000L);
                                }
                                if (WarriorAnt.this.failedMessages.contains(wm2)) {
                                    WarriorAnt.this.failedMessages.remove(wm2);
                                    _logger.info((Object)(WarriorAnt.this.getShortId() + ": Error file transfer interruption " + fpm.getFileName() + ". Cannot notificate interruption of msg id " + fpm.getSource()));
                                }
                                _logger.warn((Object)(WarriorAnt.this.getShortId() + ": File pull interrupted [No free slots]: id = " + fpm.getAck_Id() + " Source: " + fpm.getSource() + " Dest: " + fpm.getDest() + " File Name: " + fpm.getFileName()));
                            }
                            catch (Exception e) {
                                _logger.error((Object)"Exception while trying to notify secure connection error", (Throwable)e);
                            }
                        }
                    };
                    notifier.start();
                    return true;
                }
                this.inServiceFilePullRequests.add(fpm);
            }
            return false;
        }
    }

    private void processFileInfosPushMessage(FileInfosPushMessage fipm, Router r) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(fipm.getSource());
            if (esm == null) {
                throw new Exception("No secure connection avaiable with endpoint " + fipm.getSource());
            }
            fipm.decrypt(esm.getCipherDec());
            _logger.info((Object)("File infos received: hash=" + Base16.toHexString(fipm.getHash()) + "   chunks: " + fipm.getQueryFileTuple().getChunkHashes().getChunkHashes()));
            this.propertyChangeSupport.firePropertyChange("fileInfosPullCompleted", null, fipm);
        }
        catch (Exception e) {
            this.propertyChangeSupport.firePropertyChange("fileInfosPullError", null, fipm);
            throw new Exception(this.getShortId() + ": Error In Processing FileInfosPushMessage: id = " + fipm.getAck_Id() + " Source: " + fipm.getSource() + " Dest: " + fipm.getDest(), e);
        }
    }

    private void processFileSizePushMessage(FileSizePushMessage fspm, Router r) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(fspm.getSource());
            if (esm == null) {
                throw new Exception("No secure connection avaiable with endpoint " + fspm.getSource());
            }
            fspm.decrypt(esm.getCipherDec());
            _logger.info((Object)("File: name=" + fspm.getFileName() + " hash=" + Base16.toHexString(fspm.getHash()) + " size=" + fspm.getSize()));
            this.propertyChangeSupport.firePropertyChange("fileSizePushReceived", null, fspm);
        }
        catch (Exception e) {
            this.propertyChangeSupport.firePropertyChange("fileSizePushError", null, fspm);
            _logger.error((Object)"", (Throwable)e);
            throw new Exception(this.getShortId() + ": Error In Processing FileSizePushMessage: id = " + fspm.getAck_Id() + " Source: " + fspm.getSource() + " Dest: " + fspm.getDest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilePushMessage(FilePushMessage fpm, Router r) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(fpm.getSource());
            if (esm == null) {
                throw new Exception("No secure connection avaiable with endpoint " + fpm.getSource());
            }
            fpm.decrypt(esm.getCipherDec());
            boolean proceed = false;
            List list = this.pendingFilePullRequests;
            synchronized (list) {
                for (int x = this.pendingFilePullRequests.size() - 1; x >= 0; --x) {
                    FilePullMessage fpr = ((FilePullMessageWrapper)this.pendingFilePullRequests.get(x)).getFilePullMessage();
                    if (!fpr.getDest().equals(fpm.getSource()) || !fpr.getLocalFileName().equals(fpm.getFileName()) || !fpr.getOffset().equals(fpm.getOffset()) || !fpr.getBlockSize().equals(fpm.getBlockSize()) || !fpr.getBlocks().equals(new Long(PartialFile.computeGroupFactor(fpm.getBlockSize()))) || !fpr.getResume().equals(fpm.getResume()) || !WarriorAnt.compareHash(fpr.getHash(), fpm.getHash())) continue;
                    List list2 = this.inServiceFilePushRequests;
                    synchronized (list2) {
                        _logger.info((Object)(this.getShortId() + ": Found pending pull request... received serving push!!!"));
                        if (this.inServiceFilePushRequests.size() >= maxOwnPullRequestsToTrace) {
                            this.inServiceFilePushRequests.remove(0);
                        }
                        this.inServiceFilePushRequests.add(fpr);
                        this.pendingFilePullRequests.remove(x);
                        proceed = true;
                        continue;
                    }
                }
                if (!proceed) {
                    _logger.info((Object)(this.getShortId() + ": Not Found pending pull request... ingnoring message."));
                    return;
                }
                if (this.getNeighbour(r.getRequirer()) != null) {
                    this.getNeighbour(r.getRequirer()).setLastActiveDownloadTime();
                }
                _logger.info((Object)("Set last active download for " + r.getRequirer()));
                this.propertyChangeSupport.firePropertyChange("filePushInit", null, fpm);
                _logger.info((Object)(this.getShortId() + ": Creating file: name=" + chunksHome + fpm.getFileName() + " hash=" + Base16.toHexString(fpm.getHash())));
                byte[] hash = fpm.getHash();
                String name = fpm.getFileName();
                PartialFile pf = new PartialFile(name, fpm.getSource(), hash, fpm.getResume(), fpm.getOffset(), fpm, this.propertyChangeSupport);
                this.partialFiles.add(pf);
            }
            this.prunePartialFiles();
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            this.propertyChangeSupport.firePropertyChange("filePushError", null, fpm);
            throw new Exception(this.getShortId() + ": Error In Processing FilePushMessage: id = " + fpm.getAck_Id() + " Source: " + fpm.getSource() + " Dest: " + fpm.getDest());
        }
    }

    public void prunePartialFiles() {
        int x;
        for (x = this.pendingFilePullRequests.size() - 1; x >= 0; --x) {
            FilePullMessageWrapper fpmw = (FilePullMessageWrapper)this.pendingFilePullRequests.get(x);
            if (System.currentTimeMillis() - fpmw.getTimeStamp() <= partialFilesTimeout) continue;
            this.pendingFilePullRequests.remove(x);
            this.propertyChangeSupport.firePropertyChange("filePullRequestError", null, fpmw.getFilePullMessage());
        }
        for (x = this.partialFiles.size() - 1; x >= 0; --x) {
            PartialFile pf = (PartialFile)this.partialFiles.get(x);
            if (System.currentTimeMillis() - pf.getLastActivityTime() <= partialFilesTimeout) continue;
            this.partialFiles.remove(pf);
            _logger.info((Object)("Partial file timed out: " + pf.getName() + " " + pf.getFilePushMessage().getSource().substring(0, 10)));
            for (int y = 0; y < this.inServiceFilePushRequests.size(); ++y) {
                FilePullMessage fpr = (FilePullMessage)this.inServiceFilePushRequests.get(y);
                if (!fpr.getDest().equals(pf.getFilePushMessage().getSource()) || !WarriorAnt.compareHash(fpr.getHash(), pf.getFilePushMessage().getHash())) continue;
                this.inServiceFilePushRequests.remove(fpr);
                _logger.info((Object)("Removed in service file push: " + pf.getName() + " " + pf.getFilePushMessage().getSource().substring(0, 10)));
            }
            this.propertyChangeSupport.firePropertyChange("filePartDownloadInterrupted", null, pf.getFilePushMessage());
            _logger.info((Object)("Removed source: " + pf.getName() + " " + pf.getFilePushMessage().getSource().substring(0, 10)));
        }
    }

    private void processPrivateChatMessage(PrivateChatMessage pcm, Router r) throws Exception {
        try {
            this.propertyChangeSupport.firePropertyChange("privateChatMessageReceived", null, pcm);
        }
        catch (Exception e) {
            throw new Exception(this.getShortId() + ": Error In Processing PrivateChatMessage: id = " + pcm.getAck_Id() + " Source: " + pcm.getSource() + " Dest: " + pcm.getDest(), e);
        }
    }

    private void processFilePartMessage(FilePartMessage fpm, Router r) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(fpm.getSource());
            if (esm == null) {
                this.propertyChangeSupport.firePropertyChange("securityConnectionError", fpm.getSource(), fpm);
                throw new Exception("No secure connection avaiable with endpoint " + fpm.getSource());
            }
            fpm.decrypt(esm.getCipherDec());
            byte[] hash = fpm.getHash();
            PartialFile part = this.getPartialFile(hash, fpm.getFilePushMessage());
            if (part != null) {
                part.appendBytes(fpm.getContent(), fpm.getPartId());
                if (this.getNeighbour(r.getRequirer()) != null) {
                    this.getNeighbour(r.getRequirer()).setLastActiveDownloadTime();
                }
            } else {
                throw new Exception(this.getShortId() + ": Partial file is null. Error In Processing FilePartMessage: id = " + fpm.getAck_Id() + " Source: " + fpm.getSource() + " Dest: " + fpm.getDest() + "\nName: " + fpm.getFilePushMessage().getFileName());
            }
            _logger.info((Object)("Set last active download for " + r.getRequirer()));
            this.propertyChangeSupport.firePropertyChange("filePartUpdate", null, fpm);
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            if (!e.getMessage().equals("No secure connection avaiable with endpoint " + fpm.getSource())) {
                this.propertyChangeSupport.firePropertyChange("filePartError", null, fpm);
            }
            throw new Exception(this.getShortId() + ": Error In Processing FilePartMessage: id = " + fpm.getAck_Id() + " Source: " + fpm.getSource() + " Dest: " + fpm.getDest());
        }
    }

    private void processHttpRequestMessage(HttpRequestMessage httpRequest, Router r) throws Exception {
        try {
            EndpointSecurityManager esm = this.getInputSecureConnectionManager(httpRequest.getSource());
            if (esm == null) {
                SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                MessageWrapper wm = this.sendMessage(fterrcm, httpRequest.getSource(), false, false);
                _logger.debug((Object)(this.getShortId() + ": No secure connection with " + httpRequest.getSource()));
                while (this.myMessages.contains(wm) && !this.isDisconnected()) {
                    Thread.sleep(1000L);
                }
                if (this.failedMessages.contains(wm)) {
                    this.failedMessages.remove(wm);
                    _logger.debug((Object)(this.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                }
                throw new Exception("No secure connection avaiable with endpoint " + httpRequest.getSource());
            }
            if (this.getNeighbour(r.getRequirer()) != null) {
                this.getNeighbour(r.getRequirer()).setLastActiveUploadTime();
            }
            _logger.info((Object)("Set last active http upload for " + r.getRequirer()));
            httpRequest.decrypt(esm.getCipherDec());
            HttpRequestHandler requestHandler = new HttpRequestHandler(httpRequest, this);
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            if (!e.getMessage().equals("No secure connection avaiable with endpoint " + httpRequest.getSource())) {
                this.propertyChangeSupport.firePropertyChange("httpRequestError", null, httpRequest);
            }
            throw new Exception(this.getShortId() + ": Error In Processing httpRequestMessage: id = " + httpRequest.getAck_Id() + " Source: " + httpRequest.getSource() + " Dest: " + httpRequest.getDest());
        }
    }

    private void processHttpResponsePartMessage(HttpResponsePartMessage httpResponse, Router r) throws Exception {
        try {
            EndpointSecurityManager esm = this.getOutputSecureConnectionManager(httpResponse.getSource());
            if (esm == null) {
                this.propertyChangeSupport.firePropertyChange("securityConnectionError", httpResponse.getSource(), httpResponse);
                throw new Exception("No secure connection avaiable with endpoint " + httpResponse.getSource());
            }
            if (this.getNeighbour(r.getRequirer()) != null) {
                this.getNeighbour(r.getRequirer()).setLastActiveDownloadTime();
            }
            _logger.info((Object)("Set last active http download for " + r.getRequirer()));
            httpResponse.decrypt(esm.getCipherDec());
            this.propertyChangeSupport.firePropertyChange("httpResponsePart", null, httpResponse);
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            if (!e.getMessage().equals("No secure connection avaiable with endpoint " + httpResponse.getSource())) {
                this.propertyChangeSupport.firePropertyChange("httpResponseError", null, httpResponse);
            }
            throw new Exception(this.getShortId() + ": Error In Processing httpRequestMessage: id = " + httpResponse.getAck_Id() + " Source: " + httpResponse.getSource() + " Dest: " + httpResponse.getDest());
        }
    }

    private void processHttpTransferEndControlMessage(HttpTransferEndControlMessage httpResponseEnd, Router r) throws Exception {
        if (httpResponseEnd.getControlId() == 0) {
            _logger.debug((Object)("\n" + this.getShortId() + ": Http tranfer ended from id " + httpResponseEnd.getSource() + ".\nReason: " + httpResponseEnd.getMessage()));
            if (this.getNeighbour(r.getRequirer()) != null) {
                this.getNeighbour(r.getRequirer()).setLastActiveDownloadTime();
            }
            _logger.info((Object)("Set last active http download for " + r.getRequirer()));
            this.propertyChangeSupport.firePropertyChange("httpResponseEnd", null, httpResponseEnd);
        }
    }

    private void processHttpInterruptTransferMessage(HttpInterruptTransferMessage httpInterruptTranfer, Router r) throws Exception {
        if (httpInterruptTranfer.getControlId() == 0) {
            _logger.debug((Object)("\n" + this.getShortId() + ": Http tranfer interrupted from id " + httpInterruptTranfer.getSource() + ".\nReason: " + httpInterruptTranfer.getMessage()));
            if (this.getNeighbour(r.getRequirer()) != null) {
                this.getNeighbour(r.getRequirer()).setLastActiveUploadTime();
            }
            _logger.info((Object)("Set last active http upload for " + r.getRequirer()));
            this.propertyChangeSupport.firePropertyChange("httpInterruptTransfer", null, httpInterruptTranfer.getRequest());
        }
    }

    private void processControlMessage(ControlMessage cm, Router r) throws Exception {
        block17: {
            try {
                if (cm instanceof FileTransferEndControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    FileTransferEndControlMessage ftecm = (FileTransferEndControlMessage)cm;
                    this.processFileTransferEndControlMessage(ftecm, r);
                    break block17;
                }
                if (cm instanceof FileTransferErrorControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    FileTransferErrorControlMessage fterrcm = (FileTransferErrorControlMessage)cm;
                    this.processFileTransferErrorControlMessage(fterrcm, r);
                    break block17;
                }
                if (cm instanceof SecureConnectionErrorControlMessage) {
                    SecureConnectionErrorControlMessage scecm = (SecureConnectionErrorControlMessage)cm;
                    this.processSecureConnectionErrorControlMessage(scecm, r);
                    break block17;
                }
                if (cm instanceof FileSizePullErrorControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    FileSizePullErrorControlMessage fsperrcm = (FileSizePullErrorControlMessage)cm;
                    this.processFileSizePullErrorControlMessage(fsperrcm);
                    break block17;
                }
                if (cm instanceof FileInfosPullErrorControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    FileInfosPullErrorControlMessage fiperrcm = (FileInfosPullErrorControlMessage)cm;
                    this.processFileInfosPullErrorControlMessage(fiperrcm);
                    break block17;
                }
                if (cm instanceof HttpTransferEndControlMessage) {
                    EndpointSecurityManager esm = this.getOutputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    HttpTransferEndControlMessage httpTransferError = (HttpTransferEndControlMessage)cm;
                    this.processHttpTransferEndControlMessage(httpTransferError, r);
                    break block17;
                }
                if (cm instanceof HttpInterruptTransferMessage) {
                    EndpointSecurityManager esm = this.getInputSecureConnectionManager(cm.getSource());
                    if (esm == null) {
                        SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                        MessageWrapper wm = this.sendMessage(fterrcm, cm.getSource(), false, false);
                        _logger.debug((Object)(this.getShortId() + ": No secure connection with " + cm.getSource()));
                        while (this.myMessages.contains(wm) && !this.isDisconnected()) {
                            Thread.sleep(1000L);
                        }
                        if (this.failedMessages.contains(wm)) {
                            this.failedMessages.remove(wm);
                            _logger.debug((Object)(this.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                        }
                        throw new Exception("No secure connection avaiable with endpoint " + cm.getSource());
                    }
                    cm.decrypt(esm.getCipherDec());
                    HttpInterruptTransferMessage httpInterruptTransfer = (HttpInterruptTransferMessage)cm;
                    this.processHttpInterruptTransferMessage(httpInterruptTransfer, r);
                    break block17;
                }
                throw new Exception("Unexpected Control Message");
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
                throw new Exception(this.getShortId() + ": Error In Processing ControlMessage: id = " + cm.getAck_Id() + " Source: " + cm.getSource() + " Dest: " + cm.getDest());
            }
        }
    }

    private void processFileSizePullErrorControlMessage(FileSizePullErrorControlMessage fsperrcm) throws Exception {
        if (fsperrcm.getControlId() == 0) {
            _logger.info((Object)("\n" + this.getShortId() + ": File size pull aborted from id " + fsperrcm.getSource() + ". File hash = " + Base16.toHexString(fsperrcm.getContent()) + ".\nReason: " + fsperrcm.getMessage()));
            this.propertyChangeSupport.firePropertyChange("fileSizePullError", null, fsperrcm);
        }
    }

    private void processFileInfosPullErrorControlMessage(FileInfosPullErrorControlMessage fiperrcm) throws Exception {
        if (fiperrcm.getControlId() == 0) {
            _logger.info((Object)("\n" + this.getShortId() + ": File size pull aborted from id " + fiperrcm.getSource() + ". File hash = " + Base16.toHexString(fiperrcm.getContent()) + ".\nReason: " + fiperrcm.getMessage()));
            this.propertyChangeSupport.firePropertyChange("fileInfosPullError", null, fiperrcm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileTransferErrorControlMessage(FileTransferErrorControlMessage fterrcm, Router r) throws Exception {
        if (fterrcm.getControlId() == 0 || fterrcm.getControlId() == 1) {
            List list = this.pendingFilePullRequests;
            synchronized (list) {
                for (int x = this.pendingFilePullRequests.size() - 1; x >= 0; --x) {
                    FilePullMessage fpr = ((FilePullMessageWrapper)this.pendingFilePullRequests.get(x)).getFilePullMessage();
                    if (!fpr.equals(fterrcm.getFilePullMessage())) continue;
                    this.pendingFilePullRequests.remove(x);
                    _logger.info((Object)("\n" + this.getShortId() + ": File transfer aborted from id " + fterrcm.getSource() + ". File hash = " + Base16.toHexString(fterrcm.getContent()) + ".\nReason: " + fterrcm.getMessage()));
                    if (this.getNeighbour(r.getRequirer()) != null) {
                        this.getNeighbour(r.getRequirer()).setLastActiveDownloadTime();
                    }
                    _logger.info((Object)("Set last active download for " + r.getRequirer()));
                    this.propertyChangeSupport.firePropertyChange("filePartDownloadError", null, fterrcm);
                }
            }
        }
        if (fterrcm.getControlId() == 1) {
            List list = this.inServiceFilePushRequests;
            synchronized (list) {
                for (int x = this.inServiceFilePushRequests.size() - 1; x >= 0; --x) {
                    FilePullMessage fpr = (FilePullMessage)this.inServiceFilePushRequests.get(x);
                    if (!fpr.equals(fterrcm.getFilePullMessage())) continue;
                    this.inServiceFilePushRequests.remove(x);
                    _logger.info((Object)("\n" + this.getShortId() + ": File transfer aborted from id " + fterrcm.getSource() + ". File hash = " + Base16.toHexString(fterrcm.getContent()) + ".\nReason: " + fterrcm.getMessage()));
                    if (this.getNeighbour(r.getRequirer()) != null) {
                        this.getNeighbour(r.getRequirer()).setLastActiveDownloadTime();
                    }
                    _logger.info((Object)("Set last active download for " + r.getRequirer()));
                    this.propertyChangeSupport.firePropertyChange("filePartDownloadError", null, fterrcm);
                }
            }
        }
    }

    private void processSecureConnectionErrorControlMessage(SecureConnectionErrorControlMessage fterrcm, Router r) throws Exception {
        this.removeOutputSecureConnection(fterrcm.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileTransferEndControlMessage(FileTransferEndControlMessage ftecm, Router r) throws Exception {
        if (ftecm.getControlId() == 0) {
            List list = this.inServiceFilePushRequests;
            synchronized (list) {
                for (int x = this.inServiceFilePushRequests.size() - 1; x >= 0; --x) {
                    FilePullMessage fpr = (FilePullMessage)this.inServiceFilePushRequests.get(x);
                    if (!fpr.getDest().equals(ftecm.getSource()) || !WarriorAnt.compareHash(fpr.getHash(), ftecm.getContent())) continue;
                    this.inServiceFilePushRequests.remove(x);
                    _logger.info((Object)("\n" + this.getShortId() + ": File transfer succeded from id " + ftecm.getSource() + "\nFile hash = " + Base16.toHexString(ftecm.getContent()) + "\nFile local name = " + ftecm.getFilePushMessage().getFileName()));
                }
            }
            byte[] hash = ftecm.getContent();
            PartialFile part = this.getPartialFile(hash, ftecm.getFilePushMessage());
            if (part != null) {
                part.finalizeFile();
                this.partialFiles.remove(part);
                _logger.info((Object)(this.getShortId() + ": Partial file removed: name=" + chunksHome + part.getFilePushMessage().getFileName() + " hash=" + Base16.toHexString(part.getFilePushMessage().getHash())));
            } else {
                _logger.warn((Object)("Partial null file hash:" + Base16.toHexString(hash) + " " + ftecm.getFilePushMessage().getAck_Id()));
            }
            if (this.getNeighbour(r.getRequirer()) != null) {
                this.getNeighbour(r.getRequirer()).setLastActiveDownloadTime();
            }
            _logger.info((Object)("Set last active download for " + r.getRequirer()));
            this.propertyChangeSupport.firePropertyChange("filePartDownloadCompleted", null, ftecm.getFilePushMessage());
        } else if (ftecm.getControlId() == 1) {
            List list = this.inServiceFilePushRequests;
            synchronized (list) {
                for (int x = this.inServiceFilePushRequests.size() - 1; x >= 0; --x) {
                    FilePullMessage fpr = (FilePullMessage)this.inServiceFilePushRequests.get(x);
                    if (!fpr.getDest().equals(ftecm.getSource()) || !WarriorAnt.compareHash(fpr.getHash(), ftecm.getContent())) continue;
                    this.inServiceFilePushRequests.remove(x);
                    _logger.info((Object)("\n" + this.getShortId() + ": File transfer aborted from id " + ftecm.getSource() + ". File hash = " + Base16.toHexString(ftecm.getContent()) + ".\nReason: " + ftecm.getMessage()));
                    byte[] hash = ftecm.getContent();
                    PartialFile part = this.getPartialFile(hash, ftecm.getFilePushMessage());
                    if (part != null) {
                        this.partialFiles.remove(part);
                    }
                    if (this.getNeighbour(r.getRequirer()) != null) {
                        this.getNeighbour(r.getRequirer()).setLastActiveDownloadTime();
                    }
                    _logger.info((Object)("Set last active download for " + r.getRequirer()));
                    this.propertyChangeSupport.firePropertyChange("filePartDownloadInterrupted", null, ftecm.getFilePushMessage());
                }
            }
        }
    }

    private void processSecurityRequestMessage(SecurityRequestMessage srm, Router r) throws Exception {
        _logger.info((Object)("Input secure connections: " + this.inputSecureConnections.size()));
        for (int x = 0; x < this.inputSecureConnections.size(); ++x) {
            EndpointSecurityManager esmTemp = (EndpointSecurityManager)this.inputSecureConnections.get(x);
            _logger.info((Object)(esmTemp.getPeerId() + " " + new Date(esmTemp.getLastTimeUsed()).toGMTString()));
        }
        _logger.info((Object)"End of input secure connection list (last time used order)");
        if (this.inputSecureConnections.size() >= maxSecureConnections) {
            return;
        }
        EndpointSecurityManager esm = new EndpointSecurityManager(this, srm);
    }

    private void processSecurityResponseMessage(SecurityResponseMessage srm, Router r) throws Exception {
        EndpointSecurityManager esm;
        _logger.info((Object)(this.getShortId() + ": Secure connection response received"));
        boolean found = false;
        for (int x = this.outputSecureConnections.size() - 1; x >= 0; --x) {
            esm = (EndpointSecurityManager)this.outputSecureConnections.get(x);
            if (esm.getPeerId().equals(srm.getSource()) && esm.getSecurityMessage().equals(srm.getRequestMessage())) {
                found = true;
            }
            if (!found) continue;
            return;
        }
        esm = this.getPendingSecureConnectionRequest(srm.getSource(), srm);
        int counter = 0;
        while (esm == null && counter++ < 60) {
            WarriorAnt.sleep(1000L);
            esm = this.getPendingSecureConnectionRequest(srm.getSource(), srm);
        }
        if (esm != null) {
            esm.processSecurityResponseMessage(srm);
            _logger.info((Object)(this.getShortId() + ": Secure connection created"));
            this.propertyChangeSupport.firePropertyChange("secureConnectionCreated", null, srm);
            this.checkScheduledDownloads(esm);
            this.checkScheduledHttpProxy(esm);
        }
    }

    PartialFile getPartialFile(byte[] hash, FilePushMessage fpm) {
        for (int x = 0; x < this.partialFiles.size(); ++x) {
            if (!WarriorAnt.compareHash(((PartialFile)this.partialFiles.get(x)).getHash(), hash) || !((PartialFile)this.partialFiles.get(x)).getFilePushMessage().equals(fpm)) continue;
            return (PartialFile)this.partialFiles.get(x);
        }
        return null;
    }

    public EndpointSecurityManager getOutputSecureConnectionManager(String peerId) {
        for (int x = 0; x < this.outputSecureConnections.size(); ++x) {
            if (!((EndpointSecurityManager)this.outputSecureConnections.get(x)).getPeerId().equals(peerId)) continue;
            return (EndpointSecurityManager)this.outputSecureConnections.get(x);
        }
        return null;
    }

    public EndpointSecurityManager getInputSecureConnectionManager(String peerId) {
        for (int x = 0; x < this.inputSecureConnections.size(); ++x) {
            if (!((EndpointSecurityManager)this.inputSecureConnections.get(x)).getPeerId().equals(peerId)) continue;
            EndpointSecurityManager esm = (EndpointSecurityManager)this.inputSecureConnections.get(x);
            return (EndpointSecurityManager)this.inputSecureConnections.get(x);
        }
        return null;
    }

    public EndpointSecurityManager getPendingSecureConnectionRequest(String peerId, SecurityResponseMessage srm) {
        for (int x = 0; x < this.pendingSecureRequest.size(); ++x) {
            if (!((EndpointSecurityManager)this.pendingSecureRequest.get(x)).getPeerId().equals(peerId) || !((EndpointSecurityManager)this.pendingSecureRequest.get(x)).getSecurityMessage().equals(srm.getRequestMessage())) continue;
            return (EndpointSecurityManager)this.pendingSecureRequest.get(x);
        }
        return null;
    }

    public static boolean compareHash(byte[] h1, byte[] h2) {
        if (h1.length != h2.length) {
            return false;
        }
        for (int x = 0; x < h1.length; ++x) {
            if (h1[x] == h2[x]) continue;
            return false;
        }
        return true;
    }
}

