/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.MessageWrapper;
import ants.p2p.NeighbourAnt;
import ants.p2p.filesharing.PartialFile;
import ants.p2p.filesharing.PullWatchDog;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileTransferEndControlMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.messages.SecureConnectionErrorControlMessage;
import ants.p2p.query.QueryHashItem;
import ants.p2p.security.EndpointSecurityManager;
import ants.p2p.utils.encoding.Base16;
import ants.p2p.utils.indexer.BackgroundEngine;
import ants.p2p.utils.indexer.FileInfos;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import ji.JI;
import org.apache.log4j.Logger;

public class FilePullMessageProcessor
extends Thread {
    PullWatchDog watchDog = new PullWatchDog(this);
    static Logger _logger = Logger.getLogger((String)FilePullMessageProcessor.class.getName());
    WarriorAnt n;
    FilePullMessage fpm;
    int percentage = 0;
    long startTime = System.currentTimeMillis();
    boolean terminate = false;

    public FilePullMessageProcessor(WarriorAnt n, FilePullMessage fpm) {
        this.n = n;
        this.fpm = fpm;
        this.setPriority(6);
    }

    public FilePullMessage getFilePullMessage() {
        return this.fpm;
    }

    public void run() {
        FileInputStream fis = null;
        this.watchDog.start();
        try {
            Object partialFile;
            EndpointSecurityManager esm = this.n.getInputSecureConnectionManager(this.fpm.getSource());
            if (esm == null) {
                SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                MessageWrapper wm = this.n.sendMessage(fterrcm, this.fpm.getSource(), false, false);
                _logger.debug((Object)(this.n.getShortId() + ": No secure connection with " + this.fpm.getSource()));
                while (this.n.myMessages.contains(wm) && !this.terminate) {
                    Thread.sleep(1000L);
                }
                if (this.n.failedMessages.contains(wm)) {
                    this.n.failedMessages.remove(wm);
                    _logger.debug((Object)(this.n.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                }
                this.watchDog.terminate();
                throw new Exception("No secure connection avaiable with endpoint " + this.fpm.getSource());
            }
            try {
                this.fpm.decrypt(esm.getCipherDec());
            }
            catch (Exception e) {
                SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                MessageWrapper wm = this.n.sendMessage(fterrcm, this.fpm.getSource(), false, false);
                _logger.debug((Object)(this.n.getShortId() + ": No secure connection with " + this.fpm.getSource()));
                while (this.n.myMessages.contains(wm) && !this.terminate) {
                    Thread.sleep(1000L);
                }
                if (this.n.failedMessages.contains(wm)) {
                    this.n.failedMessages.remove(wm);
                    _logger.debug((Object)(this.n.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                }
                this.watchDog.terminate();
                throw new Exception("No secure connection avaiable with endpoint " + this.fpm.getSource(), e);
            }
            if (this.n.checkInServiceFilePullRequests(false, this.fpm)) {
                this.watchDog.terminate();
                return;
            }
            byte[] hash = this.fpm.getHash();
            Long offset = this.fpm.getOffset();
            File f = null;
            BackgroundEngine be = BackgroundEngine.getInstance();
            boolean shared = false;
            boolean partial = false;
            String fpmHash = Base16.toHexString(hash);
            FileInfos fileInfo = (FileInfos)be.sharedFilesIndexHash.get(fpmHash);
            if (fileInfo != null) {
                shared = true;
                f = new File(fileInfo.getName());
            }
            if (!(shared && f != null && f.exists() || (partialFile = BackgroundEngine.getInstance().getPartialFile(fpmHash, QueryHashItem.ANTS_HASH)) == null)) {
                shared = true;
                long partId = this.fpm.getOffset() / ((long)this.fpm.getBlockSize().intValue() * this.fpm.getBlocks());
                f = new File(WarriorAnt.chunksHome + WarriorAnt.chunksPath + fpmHash + "." + partId);
                partial = true;
            }
            if (!shared || f == null || !f.exists()) {
                FileTransferErrorControlMessage fterrcm = new FileTransferErrorControlMessage(new Integer(0), hash, "File don't exist", this.fpm);
                fterrcm.encrypt(esm.getCipherEnc());
                MessageWrapper wm = this.n.sendMessage(fterrcm, this.fpm.getSource(), false, false);
                _logger.debug((Object)(this.n.getShortId() + ": File " + this.fpm.getFileName() + " don't exist. Cannot serve pull request from id " + this.fpm.getSource()));
                while (this.n.myMessages.contains(wm) && !this.terminate) {
                    Thread.sleep(1000L);
                }
                if (this.n.failedMessages.contains(wm)) {
                    this.n.failedMessages.remove(wm);
                    fterrcm.decrypt(esm.getCipherDec());
                    _logger.debug((Object)(this.n.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                }
                this.watchDog.terminate();
                return;
            }
            if (this.n.checkInServiceFilePullRequests(true, this.fpm)) {
                this.watchDog.terminate();
                return;
            }
            fis = new FileInputStream(f);
            FilePushMessage frm = new FilePushMessage(this.fpm.getLocalFileName(), hash, offset, this.fpm.getBlockSize(), this.fpm.getResume(), new Long(f.length()));
            frm.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.n.sendMessage(frm, this.fpm.getSource(), false, false);
            while (this.n.myMessages.contains(wm) && !this.n.isDisconnected() && !this.terminate) {
                Thread.sleep(1000L);
            }
            if (this.n.failedMessages.contains(wm)) {
                this.n.failedMessages.remove(wm);
                frm.decrypt(esm.getCipherDec());
                _logger.debug((Object)(this.n.getShortId() + ": Error in sending FilePushMessage " + frm.getFileName() + " - Cannot serve pull request from id " + this.fpm.getSource()));
                this.n.inServiceFilePullRequests.remove(this.fpm);
                this.watchDog.terminate();
                return;
            }
            this.watchDog.setReceivedPart();
            frm.decrypt(esm.getCipherDec());
            this.n.propertyChangeSupport.firePropertyChange("filePullInit", null, this);
            byte[] block = new byte[this.fpm.getBlockSize().intValue()];
            long blocks = this.fpm.getBlocks();
            if (!partial) {
                fis.skip(offset);
            }
            long partId = 0L;
            long partsUploaded = 0L;
            ArrayList messageGroup = new ArrayList();
            long sizeUploaded = 0L;
            while (fis.available() > 0 && partId < blocks && !this.terminate) {
                for (int g = 0; g < PartialFile.computeGroupFactor(this.fpm.getBlockSize()) - messageGroup.size() && partId < blocks && !this.terminate; ++g) {
                    int read = fis.read(block);
                    if (read <= 0) continue;
                    if (read < block.length) {
                        byte[] reduced = new byte[read];
                        for (int x = 0; x < read; ++x) {
                            reduced[x] = block[x];
                        }
                        block = reduced;
                    }
                    FilePartMessage filepartmess = new FilePartMessage(block, hash, new Long(partId), frm);
                    filepartmess.encrypt(esm.getCipherEnc());
                    MessageWrapper wm1 = this.n.sendMessage(filepartmess, this.fpm.getSource(), false, false);
                    sizeUploaded += (long)block.length;
                    ++partId;
                    messageGroup.add(wm1);
                    while (messageGroup.size() >= 2 && !this.n.areInFailedMessages(messageGroup) && !this.terminate) {
                        int lastSize = messageGroup.size();
                        partsUploaded += (long)messageGroup.size();
                        messageGroup = this.n.removeDeliveredMessagesFromList(messageGroup);
                        int currentSize = messageGroup.size();
                        partsUploaded -= (long)messageGroup.size();
                        if (lastSize > currentSize) {
                            this.watchDog.setReceivedPart();
                        }
                        this.percentage = (int)((double)partsUploaded * 1.0 / (double)blocks * 100.0);
                        this.n.propertyChangeSupport.firePropertyChange("filePullUpdate", null, this);
                        Thread.sleep(1000L);
                    }
                    if (!this.n.areInFailedMessages(messageGroup)) continue;
                    this.n.failedMessages.removeAll(messageGroup);
                    this.n.inServiceFilePullRequests.remove(this.fpm);
                    this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
                    _logger.info((Object)(this.n.getShortId() + ": Error in file transfer " + this.fpm.getFileName() + ". Cannot serve pull request from id " + this.fpm.getSource()));
                    fis.close();
                    this.watchDog.terminate();
                    return;
                }
            }
            while (messageGroup.size() > 0 && !this.n.areInFailedMessages(messageGroup) && !this.terminate) {
                int lastSize = messageGroup.size();
                partsUploaded += (long)messageGroup.size();
                messageGroup = this.n.removeDeliveredMessagesFromList(messageGroup);
                int currentSize = messageGroup.size();
                partsUploaded -= (long)messageGroup.size();
                if (lastSize > currentSize) {
                    this.watchDog.setReceivedPart();
                }
                this.percentage = (int)((double)partsUploaded * 1.0 / (double)blocks * 100.0);
                this.n.propertyChangeSupport.firePropertyChange("filePullUpdate", null, this);
                Thread.sleep(1000L);
            }
            if (this.n.areInFailedMessages(messageGroup)) {
                this.n.failedMessages.removeAll(messageGroup);
                this.n.inServiceFilePullRequests.remove(this.fpm);
                this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
                _logger.info((Object)(this.n.getShortId() + ": Error in file transfer " + this.fpm.getFileName() + ". Cannot serve pull request from id " + this.fpm.getSource()));
                fis.close();
                this.watchDog.terminate();
                return;
            }
            fis.close();
            this.n.inServiceFilePullRequests.remove(this.fpm);
            FileTransferEndControlMessage cm = new FileTransferEndControlMessage(new Integer(0), hash, "", frm);
            cm.encrypt(esm.getCipherEnc());
            MessageWrapper wm2 = this.n.sendMessage(cm, this.fpm.getSource(), false, false);
            while (this.n.myMessages.contains(wm2) && !this.terminate) {
                Thread.sleep(1000L);
            }
            if (this.n.failedMessages.contains(wm2)) {
                this.n.failedMessages.remove(wm2);
                this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
                _logger.info((Object)(this.n.getShortId() + ": Error in file transfer " + this.fpm.getFileName() + ". Cannot serve pull request from id " + this.fpm.getSource()));
                this.watchDog.terminate();
                return;
            }
            this.watchDog.setReceivedPart();
            NeighbourAnt.totalUploaded += (double)sizeUploaded;
            this.n.propertyChangeSupport.firePropertyChange("filePullEnd", null, this.getFilePullMessage());
            _logger.info((Object)(this.n.getShortId() + ": File sent " + this.fpm.getFileName() + " - " + this.fpm.getLocalFileName() + ". Pull request from id " + this.fpm.getSource() + " served."));
            this.watchDog.terminate();
        }
        catch (Exception e) {
            try {
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.n.inServiceFilePullRequests.remove(this.fpm);
            this.n.propertyChangeSupport.firePropertyChange("filePullError", null, this.getFilePullMessage());
            this.watchDog.terminate();
            _logger.error((Object)(this.n.getShortId() + ": Error In Processing FilePullMessage: id = " + this.fpm.getAck_Id() + " Source: " + this.fpm.getSource() + " Dest: " + this.fpm.getDest()), (Throwable)e);
        }
    }

    public void terminate() {
        this.terminate = true;
        this.watchDog.terminate();
        try {
            EndpointSecurityManager esm = this.n.getInputSecureConnectionManager(this.fpm.getSource());
            if (esm == null) {
                SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                MessageWrapper wm = this.n.sendMessage(fterrcm, this.fpm.getSource(), false, false);
                _logger.debug((Object)(this.n.getShortId() + ": No secure connection with " + this.fpm.getSource()));
                while (this.n.myMessages.contains(wm) && !this.terminate) {
                    Thread.sleep(1000L);
                }
                if (this.n.failedMessages.contains(wm)) {
                    this.n.failedMessages.remove(wm);
                    _logger.debug((Object)(this.n.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                }
                this.watchDog.terminate();
                _logger.error((Object)("No secure connection avaiable with endpoint " + this.fpm.getSource()));
                return;
            }
            FileTransferErrorControlMessage cm = new FileTransferErrorControlMessage(new Integer(1), this.fpm.getHash(), "", this.fpm);
            cm.encrypt(esm.getCipherEnc());
            MessageWrapper wm2 = this.n.sendMessage(cm, this.fpm.getSource(), false, false);
            while (this.n.myMessages.contains(wm2)) {
                Thread.sleep(1000L);
            }
            if (this.n.failedMessages.contains(wm2)) {
                this.n.failedMessages.remove(wm2);
                _logger.info((Object)(this.n.getShortId() + ": Error file transfer interruption " + this.fpm.getFileName() + ". Cannot notificate interruption of msg id " + this.fpm.getSource()));
                return;
            }
            _logger.warn((Object)(this.n.getShortId() + ": File pull interrupted: id = " + this.fpm.getAck_Id() + " Source: " + this.fpm.getSource() + " Dest: " + this.fpm.getDest()));
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception while trying to notify file transfer interruption", (Throwable)ex);
        }
    }

    public double getSpeedValue() {
        double elapsed = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        double speed = (double)this.percentage / 100.0 * (double)(this.fpm.getBlocks() * this.fpm.getBlockSize().longValue()) / (elapsed * Math.pow(2.0, 10.0));
        return speed > 0.0 ? speed : 0.0;
    }

    public String speedToString() {
        double speed = this.getSpeedValue();
        return ("" + speed).substring(0, ("" + speed).indexOf(".") + 2) + "KiB/s ";
    }

    public String toString() {
        String rv = this.percentage + "%";
        while (rv.length() < 7) {
            rv = rv + " ";
        }
        rv = rv + this.speedToString();
        while (rv.length() < 15) {
            rv = rv + " ";
        }
        rv = rv + "     " + JI.i("Hash") + ": " + this.fpm.getLocalFileName();
        while (rv.length() < 80) {
            rv = rv + " ";
        }
        rv = this.n.acceptTCPDirectConnections() && !this.fpm.getSourceAddress().equals("") ? rv + JI.i("Requirer") + ": " + this.fpm.getSourceAddress() : rv + JI.i("Requirer") + ": " + this.fpm.getSource().substring(0, 10);
        rv = rv + "    " + JI.i("Name") + ": " + this.fpm.getFileName();
        return rv;
    }
}

