/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.DirectNeighbour;
import ants.p2p.Message;
import ants.p2p.MessageWrapper;
import ants.p2p.Neighbour;
import ants.p2p.NeighbourAnt;
import ants.p2p.NetModificationAlert;
import ants.p2p.Router;
import ants.p2p.RoutingTableElement;
import ants.p2p.SenderThread;
import ants.p2p.exceptions.NullNeighbourException;
import ants.p2p.http.HttpInterruptTransferMessage;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.messages.ControlMessage;
import ants.p2p.messages.FileInfosPullErrorControlMessage;
import ants.p2p.messages.FileInfosPullMessage;
import ants.p2p.messages.FileInfosPushMessage;
import ants.p2p.messages.FilePartMessage;
import ants.p2p.messages.FilePullMessage;
import ants.p2p.messages.FilePushMessage;
import ants.p2p.messages.FileSizePullErrorControlMessage;
import ants.p2p.messages.FileSizePullMessage;
import ants.p2p.messages.FileSizePushMessage;
import ants.p2p.messages.FileTransferEndControlMessage;
import ants.p2p.messages.FileTransferErrorControlMessage;
import ants.p2p.messages.PrivateChatMessage;
import ants.p2p.messages.SecureConnectionErrorControlMessage;
import ants.p2p.messages.SecurityRequestMessage;
import ants.p2p.messages.SecurityResponseMessage;
import ants.p2p.messages.security.MessageSigner;
import ants.p2p.query.HttpServerInfo;
import ants.p2p.query.QueryFileListItem;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryInetAddressItem;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryRandomItem;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.query.QueryStringItem;
import ants.p2p.query.QuerySupernodeItem;
import ants.p2p.query.QuerySupernodeTuple;
import ants.p2p.query.ServerInfo;
import ants.p2p.security.sockets.SecureP2PClientSocket;
import ants.p2p.security.sockets.SecureServer;
import ants.p2p.utils.encoding.Base16;
import ants.p2p.utils.indexer.DigestManager;
import ants.p2p.utils.net.UPnPManager;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class Ant
extends Thread {
    private static final String protocolVersion = "1.0.0";
    private static final String applicationName = "ANtsP2P";
    private static final String applicationVersion = "beta1.6.0";
    private static final String netName = "ANtsNet";
    private static Logger _logger = Logger.getLogger((String)Ant.class.getName());
    int serverPort = 443;
    public static String ConnectionType = "56K";
    public static int myMessageSizeMax = 10000;
    public static int inTransitMessageSizeMax = 10000;
    public static long routeInactiveTimeout = 600000L;
    public static int maxNeighbours = 15;
    List neighbours = new ArrayList();
    Hashtable netModifications = new Hashtable();
    public List myMessages = new ArrayList();
    public List failedMessages = new ArrayList();
    public Hashtable routingTable = new Hashtable();
    public List inTransitMessages = new ArrayList();
    protected SecureServer ss;
    public static long messageTimeout = 180000L;
    public static int maxRetransmissions = 3;
    public static int maxRetransmissionsForceDirection = 2;
    public static int maxFailedMessageToTrace = 100;
    public static int beingRoutedMessages = 0;
    public static int maxMessagesToRouteToghether = 50;
    public static int netModificationsTimeout = 300000;
    public static int probeCheckInterval = 360000;
    public static double underRateConnections = 0.6666666666666666;
    boolean terminate = false;
    protected boolean acceptTCPDirectConnections = false;
    String localInetAddress = null;
    public PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    String id = null;
    public int localNattedPort = 0;
    public String localNattedInetAddress = null;
    public static boolean proxied = false;
    boolean upnp;

    public Ant(String id, int maxNeighbours, int serverPort, boolean acceptDC, String localInetAddress, boolean UPnP2) {
        this.id = id;
        this.upnp = UPnP2;
        this.acceptTCPDirectConnections = acceptDC;
        this.localInetAddress = localInetAddress;
        this.serverPort = serverPort;
        if (maxNeighbours >= 1) {
            this.setMaxNeighbours(maxNeighbours);
        }
        this.setPriority(6);
        this.start();
    }

    public static void setProxied(InetAddress proxyAddress, int proxyPort) {
        System.setProperty("http.proxySet", "true");
        System.setProperty("http.proxyPort", proxyPort + "");
        System.setProperty("http.proxyHost", proxyAddress.getHostAddress());
        System.setProperty("https.proxyHost", proxyAddress.getHostAddress());
        System.setProperty("https.proxyPort", proxyPort + "");
        proxied = true;
    }

    public static void setDirectConnection() {
        System.setProperty("http.proxySet", "false");
        proxied = false;
    }

    public boolean acceptTCPDirectConnections() {
        return this.acceptTCPDirectConnections;
    }

    public String getLocalInetAddress() {
        if (this.acceptTCPDirectConnections) {
            try {
                if (!Ant.isInternetPublicAddress(InetAddress.getByName(this.localInetAddress))) {
                    return "";
                }
                return this.localInetAddress + ":" + this.serverPort;
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public void setLocalInetAddress(String localInetAddress) {
        if (localInetAddress.startsWith("/")) {
            localInetAddress = localInetAddress.substring(1);
        }
        this.localInetAddress = localInetAddress;
    }

    public String getLanAddress() {
        try {
            int x;
            InetAddress[] addresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (x = 0; x < addresses.length; ++x) {
                if (Ant.isInternetPublicAddress(addresses[x]) || addresses[x].isLoopbackAddress()) continue;
                String address = addresses[x].getHostAddress();
                if (address.startsWith("/")) {
                    address = address.substring(1);
                }
                return address;
            }
            for (x = 0; x < addresses.length; ++x) {
                if (addresses[x].isLoopbackAddress()) continue;
                String address = addresses[x].getHostAddress();
                if (address.startsWith("/")) {
                    address = address.substring(1);
                }
                return address;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Invalid InetAddress: ", (Throwable)e);
        }
        return null;
    }

    public static boolean isInternetPublicAddress(InetAddress address) {
        try {
            byte head = address.getAddress()[0];
            byte body = address.getAddress()[1];
            byte tail = address.getAddress()[2];
            if (head >= 89 && head <= 127) {
                return false;
            }
            if (head >= 173 && head <= 187) {
                return false;
            }
            if (head >= 224 && head <= 239) {
                return false;
            }
            if (head >= 240 && head <= 255) {
                return false;
            }
            switch (head) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    break;
                }
                case 10: {
                    break;
                }
                case 23: {
                    break;
                }
                case 27: {
                    break;
                }
                case 31: {
                    break;
                }
                case 36: {
                    break;
                }
                case 37: {
                    break;
                }
                case 39: {
                    break;
                }
                case 41: {
                    break;
                }
                case 42: {
                    break;
                }
                case 46: {
                    break;
                }
                case 49: {
                    break;
                }
                case 50: {
                    break;
                }
                case 58: {
                    break;
                }
                case 59: {
                    break;
                }
                case 60: {
                    break;
                }
                case 71: {
                    break;
                }
                case 72: {
                    break;
                }
                case 73: {
                    break;
                }
                case 74: {
                    break;
                }
                case 75: {
                    break;
                }
                case 76: {
                    break;
                }
                case 77: {
                    break;
                }
                case 78: {
                    break;
                }
                case 79: {
                    break;
                }
                case -128: {
                    if (body == 0) break;
                }
                case -87: {
                    if (body == -2) break;
                }
                case -84: {
                    if (body >= 16 && body <= 31) break;
                }
                case -67: {
                    break;
                }
                case -66: {
                    break;
                }
                case -65: {
                    if (body == -1) break;
                }
                case -64: {
                    if (body == 0 || body == 68 && tail == -71 || body == -88) break;
                }
                case -59: {
                    break;
                }
                case -58: {
                    if (body >= 18 && body <= 19) break;
                }
                case -33: {
                    break;
                }
                default: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getVersion() {
        return applicationVersion;
    }

    public static String getProtocolVersion() {
        return protocolVersion;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static String getNetName() {
        return netName;
    }

    public String getIdent() {
        return this.id;
    }

    public String getShortId() {
        return this.id.substring(0, 10);
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public List getFailedMessages() {
        return this.failedMessages;
    }

    public void setMaxNeighbours(int mn) {
        maxNeighbours = mn;
    }

    public int getMaxNeighbours() {
        return maxNeighbours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNeighbour(NeighbourAnt n) {
        List list = this.neighbours;
        synchronized (list) {
            try {
                n.terminate();
                if (this.neighbours.remove(n)) {
                    this.generateNetModificationAlert(n);
                }
            }
            catch (Exception e) {
                _logger.error((Object)(this.getShortId() + ""), (Throwable)e);
            }
        }
    }

    public void generateNetModificationAlert(NeighbourAnt disconnectedNeighbour) {
        try {
            ArrayList<String> unreachableNeighbours = new ArrayList<String>();
            Enumeration routingElements = this.routingTable.keys();
            while (routingElements.hasMoreElements()) {
                RoutingTableElement rte;
                String nodeID = (String)routingElements.nextElement();
                if (nodeID.equals(this.getIdent()) || (rte = (RoutingTableElement)this.routingTable.get(nodeID)) == null || !rte.removeRoute(disconnectedNeighbour.getIdent()) || rte.getRoutes().size() != 0) continue;
                unreachableNeighbours.add(nodeID);
                this.routingTable.remove(nodeID);
                if (rte != null && rte.getIP() != null) {
                    String unreachableIP = rte.getIP();
                    unreachableNeighbours.addAll(this.removeRoutes(unreachableIP, disconnectedNeighbour.getIdent()));
                }
                this.propertyChangeSupport.firePropertyChange("routeLost", disconnectedNeighbour.getIdent(), nodeID);
                _logger.info((Object)("[1]UNREACHABLE: " + nodeID.substring(0, 10)));
            }
            if (unreachableNeighbours.size() != 0) {
                NetModificationAlert alert = new NetModificationAlert(unreachableNeighbours);
                this.netModifications.put(alert.getAck_Id(), new Long(System.currentTimeMillis()));
                for (int x = 0; x < this.neighbours.size(); ++x) {
                    ((NeighbourAnt)this.neighbours.get(x)).route(alert);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error in processing netModification upon peer disconnection", (Throwable)e);
        }
    }

    public void generateNetModificationAlert(Message m, String neighbourId) {
        try {
            if (m.getDest().equals(this.getIdent())) {
                return;
            }
            RoutingTableElement rte = (RoutingTableElement)this.routingTable.get(m.getDest());
            if (rte != null && rte.removeRoute(neighbourId) && rte.getRoutes().size() == 0) {
                _logger.info((Object)("[2]UNREACHABLE: " + m.getDest().substring(0, 10)));
                this.routingTable.remove(neighbourId);
                ArrayList<String> unreachableNeighbours = new ArrayList<String>();
                unreachableNeighbours.add(m.getDest());
                if (rte != null && rte.getIP() != null) {
                    String unreachableIP = rte.getIP();
                    unreachableNeighbours.addAll(this.removeRoutes(unreachableIP, neighbourId));
                }
                this.propertyChangeSupport.firePropertyChange("routeLost", neighbourId, m.getDest());
                if (unreachableNeighbours.size() != 0) {
                    NetModificationAlert alert = new NetModificationAlert(unreachableNeighbours);
                    this.netModifications.put(alert.getAck_Id(), new Long(System.currentTimeMillis()));
                    for (int x = 0; x < this.neighbours.size(); ++x) {
                        ((NeighbourAnt)this.neighbours.get(x)).route(alert);
                    }
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error in generating netModification Alert upon message deletion", (Throwable)e);
        }
    }

    public void generateNetModificationAlert(ArrayList unreachableNeighbours, String requirer) {
        block10: {
            try {
                if (unreachableNeighbours.size() == 0) break block10;
                for (int x = unreachableNeighbours.size() - 1; x >= 0; --x) {
                    if (unreachableNeighbours.get(x).equals(this.getIdent())) {
                        unreachableNeighbours.remove(x);
                        continue;
                    }
                    RoutingTableElement rte = (RoutingTableElement)this.routingTable.remove(unreachableNeighbours.get(x));
                    if (rte != null && rte.getIP() != null) {
                        String unreachableIP = rte.getIP();
                        unreachableNeighbours.addAll(this.removeRoutes(unreachableIP, requirer));
                    }
                    this.propertyChangeSupport.firePropertyChange("routeLost", null, unreachableNeighbours.get(x));
                    _logger.info((Object)("[3]UNREACHABLE: " + (unreachableNeighbours.get(x).toString().length() > 10 ? unreachableNeighbours.get(x).toString().subSequence(0, 10) : unreachableNeighbours.get(x).toString())));
                }
                NetModificationAlert alert = new NetModificationAlert(unreachableNeighbours);
                this.netModifications.put(alert.getAck_Id(), new Long(System.currentTimeMillis()));
                if (this.acceptTCPDirectConnections) {
                    try {
                        DirectNeighbour n = new DirectNeighbour(requirer, this);
                        if (n != null) {
                            n.send(alert);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                for (int x = 0; x < this.neighbours.size(); ++x) {
                    ((NeighbourAnt)this.neighbours.get(x)).route(alert);
                }
            }
            catch (Exception e) {
                _logger.error((Object)"Error in generating netModification Alert upon message deletion", (Throwable)e);
            }
        }
    }

    private ArrayList removeRoutes(String ip, String sourceId) {
        Enumeration routingElements = this.routingTable.keys();
        ArrayList<String> unreachableNeighbours = new ArrayList<String>();
        while (routingElements.hasMoreElements()) {
            RoutingTableElement rte;
            String nodeID = (String)routingElements.nextElement();
            if (nodeID.equals(this.getIdent()) || (rte = (RoutingTableElement)this.routingTable.get(nodeID)) == null || !rte.removeRoute(ip) || rte.getRoutes().size() != 0) continue;
            unreachableNeighbours.add(nodeID);
            this.routingTable.remove(nodeID);
            String unreachableIP = rte.getIP();
            unreachableNeighbours.addAll(this.removeRoutes(unreachableIP, sourceId));
            this.propertyChangeSupport.firePropertyChange("routeLost", sourceId, nodeID);
        }
        return unreachableNeighbours;
    }

    protected synchronized void processNetModificationAlert(NetModificationAlert alert, Neighbour source) {
        try {
            if (this.netModifications.get(alert.getAck_Id()) != null) {
                return;
            }
            this.netModifications.put(alert.getAck_Id(), new Long(System.currentTimeMillis()));
            ArrayList<String> unreachableNeighbours = new ArrayList<String>();
            Enumeration routingElements = this.routingTable.keys();
            while (routingElements.hasMoreElements()) {
                String nodeID = (String)routingElements.nextElement();
                if (nodeID.equals(this.getIdent())) continue;
                RoutingTableElement rte = (RoutingTableElement)this.routingTable.get(nodeID);
                if (!alert.getUnreachablePeers().contains(nodeID) || rte == null || !rte.removeRoute(source.getIdent()) || rte.getRoutes().size() != 0) continue;
                unreachableNeighbours.add(nodeID);
                _logger.info((Object)("[4]UNREACHABLE: " + nodeID.substring(0, 10)));
                this.routingTable.remove(nodeID);
                if (rte != null && rte.getIP() != null) {
                    String unreachableIP = rte.getIP();
                    unreachableNeighbours.addAll(this.removeRoutes(unreachableIP, source.getIdent()));
                }
                this.propertyChangeSupport.firePropertyChange("routeLost", source.getIdent(), nodeID);
            }
            if (unreachableNeighbours.size() != 0) {
                alert.setUnreachablePeers(unreachableNeighbours);
                for (int x = 0; x < this.neighbours.size(); ++x) {
                    if (((NeighbourAnt)this.neighbours.get(x)).equals(source)) continue;
                    ((NeighbourAnt)this.neighbours.get(x)).route(alert);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error in processing netModification Alert", (Throwable)e);
        }
    }

    public NeighbourAnt getNeighbour(String id) {
        for (int x = 0; x < this.neighbours.size(); ++x) {
            if (!((NeighbourAnt)this.neighbours.get(x)).getIdent().equals(id) && !((NeighbourAnt)this.neighbours.get(x)).getRemoteId().equals(id)) continue;
            return (NeighbourAnt)this.neighbours.get(x);
        }
        return null;
    }

    public static int getRateThresold() {
        int rateThresold = Integer.MAX_VALUE;
        if (ConnectionType.equals("56K")) {
            rateThresold = Integer.MAX_VALUE;
        } else if (ConnectionType.equals("ISDN")) {
            rateThresold = Integer.MAX_VALUE;
        } else if (ConnectionType.equals("DSL")) {
            rateThresold = 3000;
        } else if (ConnectionType.equals("CABLE")) {
            rateThresold = 1500;
        } else if (ConnectionType.equals("LAN T3")) {
            rateThresold = 750;
        } else if (ConnectionType.equals("LAN T2")) {
            rateThresold = 375;
        } else if (ConnectionType.equals("LAN T1")) {
            rateThresold = 186;
        } else if (ConnectionType.equals("LAN or Fiber Net")) {
            rateThresold = 186;
        }
        return rateThresold;
    }

    public int getUnderRatedNeighbours() {
        int rateThresold = this.getRateThresold();
        int underRatedNeighbours = 0;
        for (int x = 0; x < this.getNeighbours().size(); ++x) {
            if (((NeighbourAnt)this.getNeighbours().get(x)).getTimeElapsed() < (long)rateThresold) continue;
            ++underRatedNeighbours;
        }
        return underRatedNeighbours;
    }

    public boolean equals(Object o) {
        if (o instanceof Ant) {
            return ((Ant)o).getIdent().equals(this.getIdent());
        }
        return o == this;
    }

    public int getNeighboursNumber() {
        return this.neighbours.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNeighbour(NeighbourAnt n) throws Exception {
        List list = this.neighbours;
        synchronized (list) {
            if (this.neighbours.size() >= maxNeighbours || this.neighbours.contains(n) || this.isDisconnected()) {
                if (this.neighbours.size() >= maxNeighbours) {
                    throw new Exception(this.getShortId() + ": Max neighbourg number reached");
                }
                if (this.neighbours.contains(n)) {
                    throw new Exception(this.getShortId() + ": Neighbourg already connected");
                }
                throw new Exception(this.getShortId() + ": Strange thing in neighbour add process.");
            }
            this.neighbours.add(n);
        }
        _logger.debug((Object)(this.getIdent() + ": Added Neighbour by request IP(local): " + n.getIdent() + " IP(remote): " + n.getRemoteId()));
        this.propertyChangeSupport.firePropertyChange("newNeighbour", null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addP2PNeighbour(String remoteAddress, int port, boolean isRequirer, InetAddress localhost) throws Exception {
        if (this.isDisconnected()) {
            return;
        }
        InetAddress remote = InetAddress.getByName(remoteAddress);
        if ((remote.isLoopbackAddress() || remote.isAnyLocalAddress() || remote.isLinkLocalAddress() || remote.isSiteLocalAddress()) && port == this.getServerPort()) {
            return;
        }
        if (localhost.getHostAddress().equals(remote.getHostAddress()) && port == this.getServerPort()) {
            return;
        }
        for (int x = 0; x < this.neighbours.size(); ++x) {
            NeighbourAnt na = (NeighbourAnt)this.neighbours.get(x);
            if (!na.getIdent().equals(remoteAddress + "  " + port) && !na.getRemoteId().equals(remoteAddress + "  " + port) && (!na.s.getInetAddress().isLoopbackAddress() && !na.s.getInetAddress().isAnyLocalAddress() && !na.s.getInetAddress().isLinkLocalAddress() && !na.s.getInetAddress().isSiteLocalAddress() || na.remoteServerPort != port && na.port != port)) continue;
            return;
        }
        SecureP2PClientSocket scs = new SecureP2PClientSocket(remoteAddress, port, this.getServerPort(), proxied);
        if (scs.isNewVersionDetected()) {
            this.getPropertyChangeSupport().firePropertyChange("newANtsVersionDetected", null, scs.getNewerVersion());
        }
        if (!scs.isClosed()) {
            _logger.info((Object)(scs.getInetAddress().getHostAddress() + ": Local time elapsed: " + scs.getTimeElapsed() + "[Thresold: " + this.getRateThresold() + "]"));
            NeighbourAnt n = new NeighbourAnt(this, remoteAddress, port, scs.getLocalServerPort(), scs.getCipherEnc(), scs.getCipherDec(), scs.getSocket(), isRequirer, scs.getTimeElapsed());
            List list = this.neighbours;
            synchronized (list) {
                if (this.neighbours.size() >= maxNeighbours || this.neighbours.contains(n)) {
                    n.terminate();
                    n.setFailure();
                    n.start();
                    if (this.neighbours.size() >= maxNeighbours) {
                        throw new Exception(this.getShortId() + ": Max neighbourg number reached");
                    }
                    if (this.neighbours.contains(n)) {
                        throw new Exception(this.getShortId() + ": Neighbourg already connected");
                    }
                    throw new Exception(this.getShortId() + ": Strange thing in neighbour add process.");
                }
                this.neighbours.add(n);
                n.start();
            }
            _logger.debug((Object)(this.getIdent() + ": Added Neighbourg from address IP(local): " + n.getIdent() + " IP(remote): " + n.getRemoteId()));
            this.propertyChangeSupport.firePropertyChange("newNeighbour", null, n);
        } else {
            _logger.info((Object)(this.getShortId() + ": Connection rejected..."));
        }
    }

    public List getNeighbours() {
        return this.neighbours;
    }

    public MessageWrapper getMessage(String id) {
        for (int x = 0; x < this.myMessages.size(); ++x) {
            if (!((MessageWrapper)this.myMessages.get(x)).getMessage().getAck_Id().equals(id)) continue;
            return (MessageWrapper)this.myMessages.get(x);
        }
        return null;
    }

    public void traceHints(Message m, String requirer) {
        if (!m.getSource().equals(this.getIdent()) && m instanceof QueryMessage && m.getType() == 0 && ((QueryMessage)m).getProcessed()) {
            QueryMessage qm = (QueryMessage)m;
            for (int x = 0; qm.getTuples() != null && x < qm.getTuples().size(); ++x) {
                RoutingTableElement rte;
                if (qm.getTuples().get(x) instanceof QueryRemoteFileTuple) {
                    QueryRemoteFileTuple qrft = (QueryRemoteFileTuple)qm.getTuples().get(x);
                    if (this.getIdent().equals(qrft.getOwnerID())) continue;
                    if (this.routingTable.get(qrft.getOwnerID()) != null) {
                        rte = (RoutingTableElement)this.routingTable.get(qrft.getOwnerID());
                        if (!this.acceptTCPDirectConnections || m.getSourceAddress().equals("")) {
                            rte.addHintRoute(requirer, qrft.getLastTimeSeen());
                            continue;
                        }
                        rte.setIP(qrft.getOwnerIP());
                        continue;
                    }
                    rte = new RoutingTableElement();
                    if (!this.acceptTCPDirectConnections || m.getSourceAddress().equals("")) {
                        rte.addHintRoute(requirer, qrft.getLastTimeSeen());
                    } else {
                        rte.setIP(qrft.getOwnerIP());
                    }
                    this.routingTable.put(qrft.getOwnerID(), rte);
                    continue;
                }
                if (!(qm.getTuples().get(x) instanceof HttpServerInfo)) continue;
                HttpServerInfo si = (HttpServerInfo)qm.getTuples().get(x);
                if (this.getIdent().equals(si.getOwnerId())) continue;
                if (this.routingTable.get(si.getOwnerId()) != null) {
                    rte = (RoutingTableElement)this.routingTable.get(si.getOwnerId());
                    if (!this.acceptTCPDirectConnections || si.getOwnerIp().equals("")) {
                        rte.addHintRoute(requirer, si.getSeenOn());
                        continue;
                    }
                    rte.setIP(si.getOwnerIp());
                    continue;
                }
                rte = new RoutingTableElement();
                if (!this.acceptTCPDirectConnections || si.getOwnerIp().equals("")) {
                    rte.addHintRoute(requirer, si.getSeenOn());
                } else {
                    rte.setIP(si.getOwnerIp());
                }
                this.routingTable.put(si.getOwnerId(), rte);
            }
        }
    }

    public void traceDeliveredMessage(MessageWrapper wm) {
        RoutingTableElement rte;
        if (!wm.getMessage().getSource().equals(this.getIdent()) && !wm.getMessage().getSource().equals("")) {
            if (this.routingTable.get(wm.getMessage().getSource()) != null) {
                rte = (RoutingTableElement)this.routingTable.get(wm.getMessage().getSource());
                if (!this.acceptTCPDirectConnections || wm.getMessage().getSourceAddress().equals("")) {
                    rte.addTracedRoute(wm.getRequirer());
                } else {
                    rte.setIP(wm.getMessage().getSourceAddress());
                }
            } else {
                rte = new RoutingTableElement();
                if (!this.acceptTCPDirectConnections || wm.getMessage().getSourceAddress().equals("")) {
                    rte.addTracedRoute(wm.getRequirer());
                } else {
                    rte.setIP(wm.getMessage().getSourceAddress());
                }
                this.routingTable.put(wm.getMessage().getSource(), rte);
            }
        }
        if (!wm.getMessage().getDest().equals(this.getIdent()) && !wm.getMessage().getDest().equals("")) {
            if (this.routingTable.get(wm.getMessage().getDest()) != null) {
                rte = (RoutingTableElement)this.routingTable.get(wm.getMessage().getDest());
                rte.addTracedRoute(wm.getRoutedTo());
            } else {
                rte = new RoutingTableElement();
                rte.addTracedRoute(wm.getRoutedTo());
                this.routingTable.put(wm.getMessage().getDest(), rte);
            }
            if (wm.getMessage() instanceof QueryMessage && wm.getMessage().getType() == 2) {
                QueryMessage qm = (QueryMessage)wm.getMessage();
                for (int x = 0; qm.getTuples() != null && x < qm.getTuples().size(); ++x) {
                    RoutingTableElement rte2;
                    if (qm.getTuples().get(x) instanceof QueryRemoteFileTuple) {
                        QueryRemoteFileTuple qrft = (QueryRemoteFileTuple)qm.getTuples().get(x);
                        if (this.getIdent().equals(qrft.getOwnerID())) continue;
                        if (this.routingTable.get(qrft.getOwnerID()) != null) {
                            rte2 = (RoutingTableElement)this.routingTable.get(qrft.getOwnerID());
                            if (!this.acceptTCPDirectConnections || qrft.getOwnerIP().equals("")) {
                                rte2.addHintRoute(wm.getRoutedTo(), qrft.getLastTimeSeen());
                                continue;
                            }
                            rte2.setIP(qrft.getOwnerIP());
                            continue;
                        }
                        rte2 = new RoutingTableElement();
                        if (!this.acceptTCPDirectConnections || qrft.getOwnerIP().equals("")) {
                            rte2.addHintRoute(wm.getRoutedTo(), qrft.getLastTimeSeen());
                        } else {
                            rte2.setIP(qrft.getOwnerIP());
                        }
                        this.routingTable.put(qrft.getOwnerID(), rte2);
                        continue;
                    }
                    if (qm.getTuples().get(x) instanceof QuerySupernodeTuple) {
                        QuerySupernodeTuple qst = (QuerySupernodeTuple)qm.getTuples().get(x);
                        if (this.getIdent().equals(qst.getOwnerID())) continue;
                        if (this.routingTable.get(qst.getOwnerID()) != null) {
                            rte2 = (RoutingTableElement)this.routingTable.get(qst.getOwnerID());
                            if (!this.acceptTCPDirectConnections || qst.getOwnerIP().equals("")) {
                                rte2.addHintRoute(wm.getRoutedTo(), qst.getSeenOn());
                                continue;
                            }
                            rte2.setIP(qst.getOwnerIP());
                            continue;
                        }
                        rte2 = new RoutingTableElement();
                        if (!this.acceptTCPDirectConnections || qst.getOwnerIP().equals("")) {
                            rte2.addHintRoute(wm.getRoutedTo(), qst.getSeenOn());
                        } else {
                            rte2.setIP(qst.getOwnerIP());
                        }
                        this.routingTable.put(qst.getOwnerID(), rte2);
                        continue;
                    }
                    if (!(qm.getTuples().get(x) instanceof HttpServerInfo)) continue;
                    HttpServerInfo si = (HttpServerInfo)qm.getTuples().get(x);
                    if (this.getIdent().equals(si.getOwnerId())) continue;
                    if (this.routingTable.get(si.getOwnerId()) != null) {
                        rte2 = (RoutingTableElement)this.routingTable.get(si.getOwnerId());
                        if (!this.acceptTCPDirectConnections || si.getOwnerIp().equals("")) {
                            rte2.addHintRoute(wm.getRoutedTo(), si.getSeenOn());
                            continue;
                        }
                        rte2.setIP(si.getOwnerIp());
                        continue;
                    }
                    rte2 = new RoutingTableElement();
                    if (!this.acceptTCPDirectConnections || si.getOwnerIp().equals("")) {
                        rte2.addHintRoute(wm.getRoutedTo(), si.getSeenOn());
                    } else {
                        rte2.setIP(si.getOwnerIp());
                    }
                    this.routingTable.put(si.getOwnerId(), rte2);
                }
            }
        }
    }

    public void traceMessage(Message m, String requirer, String routedTo) {
        RoutingTableElement rte;
        MessageWrapper wm = new MessageWrapper(m, requirer);
        wm.setStoreFormat();
        wm.setRoutedTo(routedTo);
        if (this.routingTable.get(m.getSource()) != null) {
            rte = (RoutingTableElement)this.routingTable.get(m.getSource());
            if (!this.acceptTCPDirectConnections || m.getSourceAddress().equals("")) {
                rte.addTracedRoute(requirer);
            } else {
                rte.setIP(m.getSourceAddress());
            }
        } else {
            rte = new RoutingTableElement();
            if (!this.acceptTCPDirectConnections || m.getSourceAddress().equals("")) {
                rte.addTracedRoute(requirer);
            } else {
                rte.setIP(m.getSourceAddress());
            }
            this.routingTable.put(m.getSource(), rte);
        }
        this.traceHints(m, requirer);
        int index = this.inTransitMessages.indexOf(m);
        if (index >= 0) {
            this.inTransitMessages.remove(index);
        }
        if (this.inTransitMessages.size() < inTransitMessageSizeMax && !this.inTransitMessages.contains(m)) {
            this.inTransitMessages.add(wm);
        } else if (this.inTransitMessages.size() >= inTransitMessageSizeMax && !this.inTransitMessages.contains(m)) {
            this.inTransitMessages.add(wm);
            this.inTransitMessages.remove(0);
        }
    }

    public void traceMyMessage(MessageWrapper wm, String routedTo) {
        wm.setRoutedTo(routedTo);
        int index = this.myMessages.indexOf(wm);
        if (index < 0) {
            this.myMessages.add(wm);
        } else {
            this.myMessages.remove(wm);
            this.myMessages.add(wm);
        }
    }

    public static void decBeingRoutedMessages() {
        --beingRoutedMessages;
    }

    public static boolean verifyAndIncBeingRoutedMessages() {
        if (beingRoutedMessages < maxMessagesToRouteToghether) {
            ++beingRoutedMessages;
            return true;
        }
        return false;
    }

    public Router activateNewRouterProcess(Message m, String requirer) throws Exception {
        if (Ant.verifyAndIncBeingRoutedMessages()) {
            String dest;
            String source = m.getSource();
            if (source.length() > 10) {
                source = source.substring(0, 10);
            }
            if ((dest = m.getDest()).length() > 10) {
                dest = dest.substring(0, 10);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oss = new ObjectOutputStream(bos);
            oss.writeObject(m);
            oss.close();
            bos.close();
            _logger.info((Object)("Routing[" + m.getType() + "]: " + m.getClass().toString() + " from " + source + " to " + dest + " size " + (double)bos.toByteArray().length / 1024.0 + "KB"));
            Router r = new Router(this, m, requirer);
            if (m instanceof ControlMessage || m instanceof FileTransferEndControlMessage || m instanceof FileTransferErrorControlMessage || m instanceof FileSizePullErrorControlMessage || m instanceof FileInfosPullErrorControlMessage || m instanceof HttpTransferEndControlMessage || m instanceof HttpInterruptTransferMessage || m instanceof SecureConnectionErrorControlMessage || m instanceof NetModificationAlert) {
                r.setPriority(10);
            } else if (m instanceof SecurityRequestMessage || m instanceof SecurityResponseMessage || m instanceof FilePullMessage || m instanceof FilePushMessage || m instanceof FileInfosPullMessage || m instanceof FileInfosPushMessage || m instanceof HttpRequestMessage) {
                r.setPriority(10);
            } else if (m instanceof FileSizePullMessage || m instanceof FileSizePushMessage) {
                r.setPriority(8);
            } else if (m instanceof PrivateChatMessage) {
                r.setPriority(7);
            } else if (m instanceof QueryMessage) {
                QueryMessage qm = (QueryMessage)m;
                if (qm.getQuery() instanceof QueryStringItem || qm.getQuery() instanceof QueryHashItem) {
                    r.setPriority(10);
                } else if (qm.getQuery() instanceof QueryFileListItem || qm.getQuery() instanceof QuerySupernodeItem || qm.getQuery() instanceof QueryInetAddressItem || qm.getQuery() instanceof QueryRandomItem) {
                    r.setPriority(6);
                } else {
                    r.setPriority(10);
                }
            } else if (m instanceof HttpResponsePartMessage) {
                r.setPriority(6);
            } else if (m instanceof FilePartMessage) {
                r.setPriority(6);
            } else if (m instanceof Message) {
                r.setPriority(6);
            }
            if (Router.PARALLEL) {
                r.start();
            } else {
                r.run();
            }
            return r;
        }
        _logger.error((Object)"Too many messages being routed!");
        return null;
    }

    public SenderThread[] route(MessageWrapper wm, Message m, String requirer, Router r, boolean external, boolean retransmission) throws Exception {
        if (external) {
            return this.routeExternalMessage(m, requirer, r);
        }
        if (!external && retransmission) {
            return this.retransmitMessage(wm);
        }
        return this.routeMyMessage(wm);
    }

    private SenderThread[] routeExternalMessage(Message m, String requirer, Router r) throws Exception {
        try {
            if (!m.getSource().equals("") && m.getSource().equals(this.getIdent())) {
                try {
                    MessageSigner.getInstance().sign(m);
                }
                catch (Exception e) {
                    _logger.error((Object)"Failed signing broadcast message", (Throwable)e);
                }
            }
            if (Router.delay > 0) {
                Thread.sleep((long)Math.floor((double)Router.delay * Math.random()));
            }
            if (this.neighbours.size() == 0) {
                ArrayList<String> unreachableNeighbours = new ArrayList<String>();
                unreachableNeighbours.add(m.getDest());
                this.generateNetModificationAlert(unreachableNeighbours, requirer);
                throw new Exception(this.getShortId() + ": Destination node " + m.getDest().substring(0, 10) + " unreachable for message from node " + (m.getSource().length() > 0 ? m.getSource().substring(0, 10) : m.getSource()) + " with id " + m.getAck_Id() + " type = " + m.getType() + "\nReason: No Route Found " + "Node " + this.getShortId() + " has no neighbours");
            }
            if (this.myMessages.contains(m)) {
                if (m.getType() != 2) {
                    Neighbour selectedNeighbour;
                    int index = this.myMessages.indexOf(m);
                    MessageWrapper wm = (MessageWrapper)this.myMessages.get(index);
                    if (!wm.notToBeConsidered.contains(wm.getRoutedTo())) {
                        wm.notToBeConsidered.add(wm.getRoutedTo());
                        this.generateNetModificationAlert(wm.getMessage(), wm.getRoutedTo());
                    }
                    if ((selectedNeighbour = this.checkForRoute(wm, wm.notToBeConsidered)) != null) {
                        SenderThread[] st = new SenderThread[]{selectedNeighbour.route(m)};
                        return st;
                    }
                    if (wm.notToBeConsidered.size() == 0) {
                        ArrayList<String> unreachableNeighbours = new ArrayList<String>();
                        unreachableNeighbours.add(wm.getMessage().getDest());
                        this.generateNetModificationAlert(unreachableNeighbours, requirer);
                    }
                    throw new Exception(this.getShortId() + ": Destination node " + m.getDest().substring(0, 10) + " unreachable for message from node " + (m.getSource().length() > 0 ? m.getSource().substring(0, 10) : m.getSource()) + " with id " + m.getAck_Id() + " type = " + m.getType() + "\nReason: No Route Found " + "Node " + this.getShortId() + " excluded all its " + wm.notToBeConsidered.size() + " neghbours");
                }
                _logger.debug((Object)(this.getShortId() + ": Broadcast Message returned no more node avaiable to send. Killing..."));
                return null;
            }
            if (!m.getDest().equals(this.getIdent())) {
                if (!this.inTransitMessages.contains(m)) {
                    if (m.getType() == 1) {
                        for (int k = 0; k < this.inTransitMessages.size(); ++k) {
                            MessageWrapper inTransit = (MessageWrapper)this.inTransitMessages.get(k);
                            if (inTransit.getMessage().getType() != 0 && inTransit.getMessage().getType() != 2 || !inTransit.getMessage().getAck_Id().equals(m.getAck_Id())) continue;
                            Neighbour n = null;
                            if (inTransit.getMessage().getSourceAddress().equals("")) {
                                try {
                                    n = new DirectNeighbour(inTransit.getRequirer(), this);
                                }
                                catch (Exception e) {
                                    n = this.getNeighbour(inTransit.getRequirer());
                                }
                            } else {
                                try {
                                    n = new DirectNeighbour(inTransit.getMessage().getSourceAddress(), this);
                                }
                                catch (Exception e) {
                                    n = this.getNeighbour(inTransit.getRequirer());
                                }
                            }
                            if (n != null) {
                                inTransit.getMessage().invalidate();
                                if (inTransit.getMessage().getType() == 2) {
                                    Message broadTracer = inTransit.getMessage() instanceof QueryMessage ? new QueryMessage((QueryMessage)m) : new Message(m);
                                    broadTracer.fillMessageProperties(inTransit.getMessage().getSource(), inTransit.getMessage().getSourceAddress(), m.getSource(), 2, m.getAck_Id());
                                    MessageWrapper broadTracerWrapper = new MessageWrapper(broadTracer, inTransit.getRequirer());
                                    broadTracerWrapper.setRoutedTo(requirer);
                                    this.traceDeliveredMessage(broadTracerWrapper);
                                } else {
                                    this.inTransitMessages.remove(k);
                                    this.traceDeliveredMessage(inTransit);
                                }
                                _logger.debug((Object)(this.getShortId() + ": C Forwarding message with id = " + m.getAck_Id() + " type = " + m.getType() + " to id = " + n.getIdent()));
                                SenderThread[] st = new SenderThread[]{n.route(m)};
                                return st;
                            }
                            throw new NullNeighbourException(this.getShortId() + ": Ack forwarding error [" + inTransit.getRequirer() + "]  Dest " + m.getDest() + "   source " + m.getSource() + " with id " + m.getAck_Id() + " type = " + m.getType() + "\nReason: No Route Found Node " + this.getShortId());
                        }
                        throw new NullNeighbourException(this.getShortId() + ": Ack message error: dest " + m.getDest() + "   source " + m.getSource() + "   with id " + m.getAck_Id() + " type = " + m.getType() + "\nReason: No Route Found Node " + this.getShortId());
                    }
                    if (m.getType() == 2) {
                        this.traceMessage(m, requirer, "");
                        double mustDie = ((QueryMessage)m).getNextRandomDoubleAndRollback() * 100.0;
                        if (!(mustDie < (double)r.queryDieProbability)) {
                            this.processMessage(m, r);
                        }
                        ArrayList<SenderThread> threadsList = new ArrayList<SenderThread>();
                        int floodedMessages = 0;
                        ArrayList neighboursShuffled = (ArrayList)((ArrayList)this.getNeighbours()).clone();
                        Collections.shuffle(neighboursShuffled);
                        for (int x = 0; x < neighboursShuffled.size() && !(mustDie < (double)r.queryDieProbability); ++x) {
                            NeighbourAnt n;
                            double mustRoute = Math.random() * 100.0;
                            double d = floodedMessages > 0 ? 100.0 * Math.pow((double)r.routeProbability / 100.0, (double)floodedMessages + 1.0) : (double)r.routeProbability;
                            if (!(mustRoute < d)) continue;
                            ++floodedMessages;
                            QueryMessage copy = new QueryMessage((QueryMessage)m);
                            double modifySeed = Math.random() * 100.0;
                            if (modifySeed < (double)r.querySeedModificationProbability) {
                                copy.getNextRandomDouble();
                            }
                            if ((n = (NeighbourAnt)neighboursShuffled.get(x)) == null || n.getIdent().equals(requirer)) continue;
                            try {
                                SenderThread broadSender = n.route(copy);
                                threadsList.add(broadSender);
                                _logger.debug((Object)(this.getShortId() + ": Flooding message with id = " + m.getAck_Id() + " type = " + m.getType() + " to id = " + n.getIdent()));
                                continue;
                            }
                            catch (Exception e) {
                                _logger.error((Object)"Cannot flood to neighbour", (Throwable)e);
                            }
                        }
                        SenderThread[] st = new SenderThread[threadsList.size()];
                        for (int x = 0; x < threadsList.size(); ++x) {
                            st[x] = (SenderThread)threadsList.get(x);
                        }
                        return st;
                    }
                    Neighbour selectedNeighbour = this.checkForRoute(m, requirer, new ArrayList(), false);
                    if (selectedNeighbour != null) {
                        SenderThread[] st = new SenderThread[]{selectedNeighbour.route(m)};
                        return st;
                    }
                    ArrayList<String> unreachableNeighbours = new ArrayList<String>();
                    unreachableNeighbours.add(m.getDest());
                    this.generateNetModificationAlert(unreachableNeighbours, requirer);
                    throw new NullNeighbourException(this.getShortId() + ": Destination node " + m.getDest().substring(0, 10) + " unreachable for message from node " + (m.getSource().length() > 0 ? m.getSource().substring(0, 10) : m.getSource()) + " with id " + m.getAck_Id() + " type = " + m.getType() + "\nReason: No Route Found with no excluded neghbours");
                }
                int index = this.inTransitMessages.indexOf(m);
                MessageWrapper wm = (MessageWrapper)this.inTransitMessages.get(index);
                if (m.getType() != 2) {
                    if (!wm.notToBeConsidered.contains(wm.getRoutedTo())) {
                        wm.notToBeConsidered.add(wm.getRoutedTo());
                        this.generateNetModificationAlert(wm.getMessage(), wm.getRoutedTo());
                    }
                    _logger.debug((Object)(this.getShortId() + ": Message with id = " + m.getAck_Id() + " type = " + m.getType() + " returned. Not considering node " + wm.getRoutedTo()));
                    Neighbour selectedNeighbour = this.checkForRoute(m, requirer, wm.notToBeConsidered, true);
                    if (selectedNeighbour != null) {
                        SenderThread[] st = new SenderThread[]{selectedNeighbour.route(m)};
                        return st;
                    }
                    if (wm.notToBeConsidered.size() == 0) {
                        ArrayList<String> unreachableNeighbours = new ArrayList<String>();
                        unreachableNeighbours.add(m.getDest());
                        this.generateNetModificationAlert(unreachableNeighbours, requirer);
                    }
                    throw new NullNeighbourException(this.getShortId() + ": Destination node " + m.getDest().substring(0, 10) + " unreachable for message from node " + (m.getSource().length() > 0 ? m.getSource().substring(0, 10) : m.getSource()) + " with id " + m.getAck_Id() + " type = " + m.getType() + "\nReason: No Route Found Node " + this.getShortId() + " excluded all its " + wm.notToBeConsidered.size() + " neghbours     " + m);
                }
                this.traceMessage(m, requirer, "");
                _logger.debug((Object)(this.getShortId() + ": D Flooded message with id = " + m.getAck_Id() + " type = " + m.getType() + " returned. Killing!"));
                return null;
            }
            if (m.getDest().equals(this.getIdent())) {
                if (m.getType() == 0 && !m.getSource().equals("")) {
                    _logger.debug((Object)(this.getShortId() + ": Received Message sending Ack for message with id = " + m.getAck_Id() + " type = " + m.getType()));
                    MessageWrapper toBeStored = new MessageWrapper(m, requirer);
                    this.traceHints(m, requirer);
                    this.traceDeliveredMessage(toBeStored);
                    Message ackMessage = new Message();
                    ackMessage.fillMessageProperties(this.getIdent(), "", m.getSource(), 1, m.getAck_Id());
                    MessageWrapper wm = new MessageWrapper(ackMessage, requirer);
                    if (!wm.getMessage().getSource().equals("") && wm.getMessage().getSource().equals(this.getIdent())) {
                        try {
                            MessageSigner.getInstance().sign(wm.getMessage());
                        }
                        catch (Exception e) {
                            _logger.error((Object)"Failed signing message", (Throwable)e);
                        }
                    }
                    SenderThread[] st = null;
                    Neighbour n = null;
                    if (m.getSourceAddress().equals("")) {
                        try {
                            n = new DirectNeighbour(requirer, this);
                        }
                        catch (Exception e) {
                            n = this.getNeighbour(requirer);
                        }
                    } else {
                        try {
                            n = new DirectNeighbour(m.getSourceAddress(), this);
                        }
                        catch (Exception e) {
                            n = this.getNeighbour(requirer);
                        }
                    }
                    if (n == null) {
                        ArrayList<String> unreachableNeighbours = new ArrayList<String>();
                        unreachableNeighbours.add(wm.getMessage().getDest());
                        this.generateNetModificationAlert(unreachableNeighbours, this.getIdent());
                        throw new NullNeighbourException(this.getShortId() + ": Destination node " + wm.getMessage().getDest().substring(0, 10) + " unreachable for message from node " + (wm.getMessage().getSource().length() > 0 ? wm.getMessage().getSource().substring(0, 10) : wm.getMessage().getSource()) + " with id " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType() + "\nReason: No Route Found Node " + this.getShortId() + " excluded all its " + wm.notToBeConsidered.size() + " neghbours");
                    }
                    st = new SenderThread[]{n.route(new Message(wm))};
                    _logger.debug((Object)(this.getShortId() + ": D1 Forwarding message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType() + " to id = " + requirer));
                    this.processMessage(m, r);
                    return st;
                }
                if ((m.getType() == 0 || m.getType() == 1) && m.getSource().equals("")) {
                    _logger.debug((Object)(this.getShortId() + ": Received Message with masked source id = " + m.getAck_Id() + " type = " + m.getType()));
                    this.processMessage(m, r);
                    return null;
                }
                if (m.getType() == 1) {
                    if (this.getMessage(m.getAck_Id()) != null) {
                        MessageWrapper movingMessage = null;
                        movingMessage = this.getMessage(m.getAck_Id());
                        if (movingMessage != null) {
                            if (movingMessage.getMessage().getType() == 2) {
                                Message broadTracer = m instanceof QueryMessage ? new QueryMessage((QueryMessage)m) : new Message(m);
                                broadTracer.fillMessageProperties(m.getDest(), movingMessage.getMessage().getSourceAddress(), m.getSource(), 2, m.getAck_Id());
                                broadTracer.invalidate();
                                MessageWrapper broadTracerWrapper = new MessageWrapper(broadTracer, this.getIdent());
                                broadTracerWrapper.setRoutedTo(((Router)Thread.currentThread()).getRequirer());
                                this.traceDeliveredMessage(broadTracerWrapper);
                            } else {
                                movingMessage.getMessage().invalidate();
                                this.myMessages.remove(movingMessage);
                                this.traceDeliveredMessage(movingMessage);
                            }
                        }
                        _logger.debug((Object)(this.getShortId() + ": Message succesfully routed id = " + m.getAck_Id() + " type = " + m.getType()));
                        this.processMessage(m, r);
                        return null;
                    }
                    _logger.debug((Object)(this.getShortId() + ": (Retransmission) Message succesfully routed id = " + m.getAck_Id() + " type = " + m.getType()));
                    this.processMessage(m, r);
                    return null;
                }
                throw new Exception(this.getShortId() + ": There is something strange(2) for message with id = " + m.getAck_Id() + " type = " + m.getType());
            }
            throw new Exception(this.getShortId() + ": There is something strange(3) for message with id = " + m.getAck_Id() + " type = " + m.getType());
        }
        catch (Exception e) {
            _logger.error((Object)(this.getShortId() + " routing error[" + requirer + "]: "), (Throwable)e);
            return null;
        }
    }

    private SenderThread[] routeMyMessage(MessageWrapper wm) throws Exception {
        if (!wm.getMessage().getSource().equals("") && wm.getMessage().getSource().equals(this.getIdent())) {
            try {
                MessageSigner.getInstance().sign(wm.getMessage());
            }
            catch (Exception e) {
                _logger.error((Object)"Failed signing broadcast message", (Throwable)e);
            }
        }
        if (wm.getMessage().getType() != 2) {
            Neighbour n = this.checkForRoute(wm, wm.notToBeConsidered);
            if (n != null) {
                SenderThread[] st = new SenderThread[]{n.route(wm.getMessage())};
                return st;
            }
            if (wm.notToBeConsidered.size() == 0) {
                ArrayList<String> unreachableNeighbours = new ArrayList<String>();
                unreachableNeighbours.add(wm.getMessage().getDest());
                this.generateNetModificationAlert(unreachableNeighbours, this.getIdent());
            }
            throw new Exception(this.getShortId() + ": Destination unreachable for message with id = " + wm.getMessage().getAck_Id().substring(0, 10) + " type = " + wm.getMessage().getType());
        }
        ArrayList<SenderThread> threadsList = new ArrayList<SenderThread>();
        int floodedMessages = 0;
        int routeProbability = 25 + (int)(System.currentTimeMillis() % 50L);
        int queryDieProbability = 5 + (int)(System.currentTimeMillis() % 10L);
        int querySeedModificationProbability = 50 + (int)(System.currentTimeMillis() % 25L);
        double mustDie = ((QueryMessage)wm.getMessage()).getNextRandomDoubleAndRollback() * 100.0;
        ArrayList neighboursShuffled = (ArrayList)((ArrayList)this.getNeighbours()).clone();
        Collections.shuffle(neighboursShuffled);
        for (int x = 0; x < neighboursShuffled.size() && !(mustDie < (double)queryDieProbability); ++x) {
            NeighbourAnt n = (NeighbourAnt)neighboursShuffled.get(x);
            double mustRoute = Math.random() * 100.0;
            double d = floodedMessages > 0 ? 100.0 * Math.pow((double)routeProbability / 100.0, (double)floodedMessages + 1.0) : (double)routeProbability;
            if (!(mustRoute < d)) continue;
            try {
                QueryMessage copy = new QueryMessage((QueryMessage)wm.getMessage());
                double modifySeed = Math.random() * 100.0;
                if (modifySeed < (double)querySeedModificationProbability) {
                    copy.getNextRandomDouble();
                }
                SenderThread broadSender = n.route(copy);
                threadsList.add(broadSender);
                _logger.debug((Object)(this.getShortId() + ": Flooding message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType() + " to id = " + n.getIdent()));
                continue;
            }
            catch (Exception e) {
                _logger.error((Object)"Cannot flood to neighbour", (Throwable)e);
            }
        }
        this.traceMyMessage(wm, "");
        SenderThread[] st = new SenderThread[threadsList.size()];
        for (int x = 0; x < threadsList.size(); ++x) {
            st[x] = (SenderThread)threadsList.get(x);
        }
        return st;
    }

    private int changeThreadPriority(Message m) {
        int oldPriority = Thread.currentThread().getPriority();
        if (m instanceof ControlMessage || m instanceof FileTransferEndControlMessage || m instanceof FileTransferErrorControlMessage || m instanceof FileSizePullErrorControlMessage || m instanceof FileInfosPullErrorControlMessage || m instanceof HttpTransferEndControlMessage || m instanceof HttpInterruptTransferMessage || m instanceof SecureConnectionErrorControlMessage || m instanceof NetModificationAlert) {
            Thread.currentThread().setPriority(10);
        } else if (m instanceof SecurityRequestMessage || m instanceof SecurityResponseMessage || m instanceof FilePullMessage || m instanceof FilePushMessage || m instanceof FileInfosPullMessage || m instanceof FileInfosPushMessage || m instanceof HttpRequestMessage) {
            Thread.currentThread().setPriority(10);
        } else if (m instanceof FileSizePullMessage || m instanceof FileSizePushMessage) {
            Thread.currentThread().setPriority(8);
        } else if (m instanceof PrivateChatMessage) {
            Thread.currentThread().setPriority(7);
        } else if (m instanceof QueryMessage) {
            QueryMessage qm = (QueryMessage)m;
            if (qm.getQuery() instanceof QueryStringItem || qm.getQuery() instanceof QueryHashItem) {
                Thread.currentThread().setPriority(10);
            } else if (qm.getQuery() instanceof QueryFileListItem || qm.getQuery() instanceof QuerySupernodeItem || qm.getQuery() instanceof QueryInetAddressItem || qm.getQuery() instanceof QueryRandomItem) {
                Thread.currentThread().setPriority(6);
            } else {
                Thread.currentThread().setPriority(10);
            }
        } else if (m instanceof HttpResponsePartMessage) {
            Thread.currentThread().setPriority(6);
        } else if (m instanceof FilePartMessage) {
            Thread.currentThread().setPriority(6);
        } else if (m instanceof Message) {
            Thread.currentThread().setPriority(6);
        }
        return oldPriority;
    }

    public MessageWrapper sendMessage(Message message, String dest, boolean disableAutoRetransmit, boolean maskSource) throws InterruptedException {
        String messageID;
        int oldPriority = this.changeThreadPriority(message);
        try {
            Thread.sleep(2L);
            messageID = this.getIdent() + "@" + new DigestManager().getDigest(System.currentTimeMillis() + "");
            Thread.sleep(2L);
        }
        catch (Exception e) {
            messageID = Math.floor(Math.random() * Math.pow(10.0, 32.0)) + "";
        }
        if (!maskSource) {
            message.fillMessageProperties(this.getIdent(), this.getLocalInetAddress(), dest, 0, messageID);
        } else {
            message.fillMessageProperties("", "", dest, 0, messageID);
        }
        _logger.debug((Object)("There are " + this.failedMessages.size() + " messages failed!"));
        _logger.debug((Object)("There are " + this.myMessages.size() + " messages pending!"));
        _logger.debug((Object)(this.getShortId() + ": Sending Message from id = " + this.getShortId() + " to id = " + dest + " message id = " + messageID));
        MessageWrapper wm = new MessageWrapper(message, this.getIdent());
        if (disableAutoRetransmit) {
            wm.disableAutoRetransmit();
        }
        try {
            SenderThread[] st = this.route(wm, null, null, null, false, false);
            if (st != null) {
                final SenderThread[] stFinal = st;
                Thread waiter = new Thread(){

                    public void run() {
                        for (int x = 0; x < stFinal.length; ++x) {
                            try {
                                stFinal[x].join(Router.routeTimeout);
                            }
                            catch (Exception e) {
                                _logger.error((Object)"Cannot join send process", (Throwable)e);
                            }
                            if (!stFinal[x].isAlive()) continue;
                            stFinal[x].interruptSending();
                        }
                    }
                };
                waiter.start();
            }
            Thread.currentThread().setPriority(oldPriority);
            return wm;
        }
        catch (Exception e) {
            _logger.error((Object)(this.getShortId() + ""), (Throwable)e);
            Thread.currentThread().setPriority(oldPriority);
            return null;
        }
    }

    public MessageWrapper sendBroadcastMessage(Message message) {
        String messageID;
        int oldPriority = this.changeThreadPriority(message);
        try {
            Thread.sleep(2L);
            messageID = this.getIdent() + "@" + new DigestManager().getDigest(System.currentTimeMillis() + "");
            Thread.sleep(2L);
        }
        catch (Exception e) {
            messageID = Math.floor(Math.random() * Math.pow(10.0, 32.0)) + "";
        }
        SecureRandom sr = new SecureRandom();
        byte[] randomDest = new byte[10];
        sr.nextBytes(randomDest);
        String dest = Base16.toHexString(randomDest);
        message.fillMessageProperties(this.getIdent(), this.getLocalInetAddress(), dest, 2, messageID);
        MessageWrapper wm = new MessageWrapper(message, this.getIdent());
        wm.disableAutoRetransmit();
        try {
            SenderThread[] st = this.route(wm, null, null, null, false, false);
            if (st != null) {
                final SenderThread[] stFinal = st;
                Thread waiter = new Thread(){

                    public void run() {
                        for (int x = 0; x < stFinal.length; ++x) {
                            try {
                                stFinal[x].join(Router.routeTimeout);
                            }
                            catch (Exception e) {
                                _logger.error((Object)"Cannot join send process", (Throwable)e);
                            }
                            if (!stFinal[x].isAlive()) continue;
                            stFinal[x].interruptSending();
                        }
                    }
                };
                waiter.start();
            }
            Thread.currentThread().setPriority(oldPriority);
            return wm;
        }
        catch (Exception e) {
            _logger.error((Object)(this.getShortId() + ""), (Throwable)e);
            Thread.currentThread().setPriority(oldPriority);
            return wm;
        }
    }

    private SenderThread[] retransmitMessage(MessageWrapper wm) {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            _logger.error((Object)(this.getShortId() + ""), (Throwable)e);
        }
        try {
            Neighbour n;
            if (!wm.getMessage().getSource().equals("") && wm.getMessage().getSource().equals(this.getIdent())) {
                try {
                    MessageSigner.getInstance().sign(wm.getMessage());
                }
                catch (Exception e) {
                    _logger.error((Object)"Failed signing broadcast message", (Throwable)e);
                }
            }
            if (wm.getRetrasmissions() >= maxRetransmissions) {
                throw new Exception("Retransmissions exceeeded");
            }
            _logger.debug((Object)(this.getShortId() + ": Retransmitting Message from id = " + this.getShortId() + " to id = " + wm.getMessage().getDest() + " message id = " + wm.getMessage().getAck_Id()));
            wm.getMessage().resetDelivered();
            if (!wm.notToBeConsidered.contains(wm.getRoutedTo())) {
                wm.notToBeConsidered.add(wm.getRoutedTo());
                this.generateNetModificationAlert(wm.getMessage(), wm.getRoutedTo());
            }
            if ((n = this.checkForRoute(wm, wm.notToBeConsidered)) != null) {
                SenderThread[] st = new SenderThread[]{n.route(wm.getMessage())};
                return st;
            }
            if (wm.notToBeConsidered.size() == 0) {
                ArrayList<String> unreachableNeighbours = new ArrayList<String>();
                unreachableNeighbours.add(wm.getMessage().getDest());
                this.generateNetModificationAlert(unreachableNeighbours, this.getIdent());
            }
            throw new Exception(this.getShortId() + ": Destination (retransmission) unreachable for message with id = " + wm.getMessage().getAck_Id().substring(0, 10) + " type = " + wm.getMessage().getType());
        }
        catch (Exception e) {
            _logger.error((Object)(this.getShortId() + ""), (Throwable)e);
            return null;
        }
    }

    public Neighbour checkForRoute(MessageWrapper wm, List notToBeConsidered) throws Exception {
        DirectNeighbour selectedNeighbour = null;
        String neighbourId = null;
        RoutingTableElement rte = (RoutingTableElement)this.routingTable.get(wm.getMessage().getDest());
        if (rte != null && rte.getIP() != null) {
            try {
                selectedNeighbour = new DirectNeighbour(rte.getIP(), this);
                neighbourId = selectedNeighbour.getIdent();
            }
            catch (Exception e) {
                rte.firewalled = true;
            }
        }
        if (selectedNeighbour == null) {
            for (int x = 0; rte != null && x < rte.getRoutes().size(); ++x) {
                Neighbour n;
                String routingTo = (String)rte.getRoutes().get(x);
                try {
                    n = new DirectNeighbour(routingTo, this);
                }
                catch (Exception e) {
                    n = this.getNeighbour(routingTo);
                }
                if (n == null || notToBeConsidered.contains(routingTo) || selectedNeighbour != null && selectedNeighbour.getQueuedMessages() <= n.getQueuedMessages()) continue;
                selectedNeighbour = n;
                neighbourId = routingTo;
            }
        }
        if (selectedNeighbour != null && neighbourId != null) {
            rte.setLastTimeUsed();
            if (wm.getMessage().getType() != 1) {
                this.traceMyMessage(wm, neighbourId);
            }
            _logger.debug((Object)(this.getShortId() + ": Routing message with id = " + wm.getMessage().getAck_Id() + " type = " + wm.getMessage().getType() + " to id = " + neighbourId));
        }
        return selectedNeighbour;
    }

    public boolean existRouteTo(String dest) {
        RoutingTableElement rte = (RoutingTableElement)this.routingTable.get(dest);
        return rte != null && (rte.getIP() != null || rte.getRoutes().size() > 0);
    }

    public Neighbour checkForRoute(Message m, String requirer, List notToBeConsidered, boolean alreadySeen) throws Exception {
        DirectNeighbour selectedNeighbour = null;
        String neighbourId = null;
        RoutingTableElement rte = (RoutingTableElement)this.routingTable.get(m.getDest());
        if (rte != null && rte.getIP() != null) {
            try {
                selectedNeighbour = new DirectNeighbour(rte.getIP(), this);
                neighbourId = selectedNeighbour.getIdent();
            }
            catch (Exception e) {
                rte.firewalled = true;
            }
        }
        if (selectedNeighbour == null) {
            for (int x = 0; rte != null && x < rte.getRoutes().size(); ++x) {
                Neighbour n;
                String routingTo = (String)rte.getRoutes().get(x);
                try {
                    n = new DirectNeighbour(routingTo, this);
                }
                catch (Exception e) {
                    n = this.getNeighbour(routingTo);
                }
                if (n == null || notToBeConsidered.contains(routingTo) || routingTo.equals(requirer) || selectedNeighbour != null && selectedNeighbour.getQueuedMessages() <= n.getQueuedMessages()) continue;
                selectedNeighbour = n;
                neighbourId = routingTo;
            }
        }
        if (selectedNeighbour != null && neighbourId != null) {
            rte.setLastTimeUsed();
            if (alreadySeen) {
                int index = this.inTransitMessages.indexOf(m);
                MessageWrapper wm = (MessageWrapper)this.inTransitMessages.get(index);
                wm.setRoutedTo(neighbourId);
            } else {
                this.traceMessage(m, requirer, neighbourId);
            }
            _logger.debug((Object)(this.getShortId() + ": Routing message with id = " + m.getAck_Id() + " type = " + m.getType() + " to id = " + neighbourId));
        }
        return selectedNeighbour;
    }

    public void uPnPMapping() {
        try {
            UPnPManager upnpManager = UPnPManager.instance();
            int result = 0;
            if (upnpManager.isNATPresent()) {
                result = upnpManager.mapPort(upnpManager.getLocalAddress().getHostAddress(), this.serverPort);
            }
            if (result > 0) {
                this.localNattedInetAddress = upnpManager.getLocalAddress().getHostAddress();
                this.localInetAddress = upnpManager.getNATAddress().getHostAddress();
                this.localNattedPort = this.serverPort;
                this.serverPort = result;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.ss = new SecureServer(this, this.serverPort);
            if (this.ss.getServerSocket() == null) {
                return;
            }
            if (this.upnp) {
                UPnPManager.instance().startDevice();
            }
            ServerInfo si = new ServerInfo("", this.getLanAddress(), new Integer(this.getServerPort()), "");
            _logger.info((Object)("Updating UPnP LAN address: " + si));
            UPnPManager.instance().setCurrentLanAddress(si);
            while (!this.terminate) {
                try {
                    int x;
                    System.gc();
                    _logger.info((Object)"Running ANts main loop...");
                    for (int z = 0; z < 3; ++z) {
                        int sleepTime = 1000;
                        for (int indx = 0; indx < 60; ++indx) {
                            Ant.sleep(sleepTime);
                        }
                        try {
                            block12: for (int x2 = this.neighbours.size() - 1; x2 >= 0; --x2) {
                                for (int y = x2 - 1; y >= 0; --y) {
                                    if (!this.neighbours.get(x2).equals(this.neighbours.get(y))) continue;
                                    this.removeNeighbour((NeighbourAnt)this.neighbours.get(x2));
                                    _logger.info((Object)"Removing duplicated neighbour...");
                                    continue block12;
                                }
                            }
                            boolean[] activeUploadNeighbour = new boolean[this.neighbours.size()];
                            boolean[] activeDownloadNeighbour = new boolean[this.neighbours.size()];
                            for (x = 0; x < this.neighbours.size(); ++x) {
                                NeighbourAnt toBeRemoved = (NeighbourAnt)this.neighbours.get(x);
                                _logger.info((Object)(toBeRemoved + " Alive: " + toBeRemoved.isAlive() + " Connected:" + toBeRemoved.isConnected()));
                                if (!toBeRemoved.isAlive() || !toBeRemoved.isConnected()) {
                                    this.removeNeighbour(toBeRemoved);
                                    this.propertyChangeSupport.firePropertyChange("removedNeighbour", null, toBeRemoved);
                                    _logger.info((Object)"Removing stuck neighbour...");
                                    continue;
                                }
                                if (toBeRemoved.getLastProbedAt() < System.currentTimeMillis() - (long)probeCheckInterval) {
                                    toBeRemoved.terminate();
                                    this.propertyChangeSupport.firePropertyChange("removedNeighbour", null, toBeRemoved);
                                    _logger.info((Object)"Removing stuck neighbour...");
                                    continue;
                                }
                                NeighbourAnt current = (NeighbourAnt)this.neighbours.get(x);
                                activeDownloadNeighbour[x] = System.currentTimeMillis() - current.getLastActiveDownloadTime() <= messageTimeout * (long)maxRetransmissions;
                                activeUploadNeighbour[x] = System.currentTimeMillis() - current.getLastActiveUploadTime() <= messageTimeout * (long)maxRetransmissions;
                            }
                            continue;
                        }
                        catch (Exception e) {
                            _logger.error((Object)(this.getShortId() + ": Error in removing stuck neighbour"), (Throwable)e);
                        }
                    }
                    while (this.failedMessages.size() > maxFailedMessageToTrace) {
                        this.failedMessages.remove(0);
                    }
                    Enumeration netMods = this.netModifications.keys();
                    while (netMods.hasMoreElements()) {
                        String mod = (String)netMods.nextElement();
                        if (System.currentTimeMillis() - (Long)this.netModifications.get(mod) <= (long)netModificationsTimeout) continue;
                        this.netModifications.remove(mod);
                    }
                    Enumeration routingTableElementKeys = this.routingTable.keys();
                    ArrayList<String> un = new ArrayList<String>();
                    while (routingTableElementKeys.hasMoreElements()) {
                        String routingTableElementKey = (String)routingTableElementKeys.nextElement();
                        if (System.currentTimeMillis() - ((RoutingTableElement)this.routingTable.get(routingTableElementKey)).getLastTimeUsed() <= routeInactiveTimeout) continue;
                        this.routingTable.remove(routingTableElementKey);
                        un.add(routingTableElementKey);
                    }
                    this.generateNetModificationAlert(un, this.getIdent());
                    if (this.myMessages.size() == 0) continue;
                    _logger.debug((Object)(this.getShortId() + ": Processing " + this.myMessages.size() + " messages for eventual retransmission..."));
                    _logger.debug((Object)("There are " + this.failedMessages.size() + " messages failed!"));
                    ArrayList<MessageWrapper> toBeRemoved = new ArrayList<MessageWrapper>();
                    for (x = 0; x < this.myMessages.size(); ++x) {
                        MessageWrapper wm = (MessageWrapper)this.myMessages.get(x);
                        if (wm.getLifetime() <= messageTimeout) continue;
                        if (wm.getRetrasmissions() + 1 < maxRetransmissions) {
                            wm.retrasmitted(this);
                            SenderThread[] st = this.route(wm, null, null, null, false, true);
                            if (st != null) {
                                final SenderThread[] stFinal = st;
                                Thread waiter = new Thread(){

                                    public void run() {
                                        for (int x = 0; x < stFinal.length; ++x) {
                                            try {
                                                stFinal[x].join(Router.routeTimeout);
                                            }
                                            catch (Exception e) {
                                                _logger.error((Object)"Cannot join send process", (Throwable)e);
                                            }
                                            if (!stFinal[x].isAlive()) continue;
                                            stFinal[x].interruptSending();
                                        }
                                    }
                                };
                                waiter.start();
                            }
                            _logger.debug((Object)("Retransmited Message: " + wm.getMessage().getAck_Id() + wm.getMessage().getType()));
                            continue;
                        }
                        if (wm.getMessage().getType() == 2) {
                            _logger.info((Object)(this.getShortId() + ": Broadcast message timed out " + wm.getMessage().getDest()));
                        } else if (wm.getMessage().getType() == 0 && wm.getMessage().getSource().equals("")) {
                            _logger.info((Object)(this.getShortId() + ": Masked message timed out " + wm.getMessage().getDest()));
                        } else {
                            _logger.info((Object)(this.getShortId() + ": Destination unreachable " + wm.getMessage().getDest().substring(0, 10)));
                            this.failedMessages.add(wm);
                        }
                        toBeRemoved.add(wm);
                    }
                    Ant ant = this;
                    synchronized (ant) {
                        for (int x3 = toBeRemoved.size() - 1; x3 >= 0; --x3) {
                            MessageWrapper wm = (MessageWrapper)toBeRemoved.get(x3);
                            if (!this.myMessages.remove(wm)) continue;
                            _logger.info((Object)("Removed Message from myMessages: " + wm.getMessage().getAck_Id().substring(0, 10) + wm.getMessage().getType()));
                        }
                    }
                }
                catch (Exception cycleException) {
                    _logger.error((Object)("ANt(ID_" + this.getShortId() + ") main cycle error!"), (Throwable)cycleException);
                }
            }
            _logger.error((Object)"ANts MAIN ENGINE TERMINATED********************************************************");
        }
        catch (Exception e) {
            this.terminate = true;
            _logger.info((Object)(this.getShortId() + " - Failure in setting up Ant server port"), (Throwable)e);
            _logger.error((Object)"ANts MAIN ENGINE TERMINATED********************************************************");
        }
    }

    private void checkNeighboursActivity(boolean[] activeDownload, boolean[] activeUpload) {
        int toBeRemoved;
        int activeNumber = 0;
        int activeUp = 0;
        int activeDown = 0;
        int maxActiveOneWay = (int)Math.floor((double)maxNeighbours * 2.0 / 3.0);
        for (int x = 0; x < activeDownload.length; ++x) {
            if (activeDownload[x]) {
                ++activeDown;
            }
            if (activeUpload[x]) {
                ++activeUp;
            }
            if (!activeUpload[x] && !activeDownload[x]) continue;
            ++activeNumber;
        }
        if ((double)(this.neighbours.size() - activeNumber) > (double)maxNeighbours * 2.0 / 3.0) {
            toBeRemoved = -1;
            long currentPing = 0L;
            for (int x = 0; x < this.neighbours.size(); ++x) {
                NeighbourAnt current = (NeighbourAnt)this.neighbours.get(x);
                if (activeDownload[x] || activeUpload[x] || current.getTimeElapsed() <= currentPing) continue;
                currentPing = current.getTimeElapsed();
                toBeRemoved = x;
            }
            if (toBeRemoved >= 0) {
                _logger.info((Object)("Neighbour " + this.neighbours.get(toBeRemoved) + " is not active up/down, removing..."));
                this.removeNeighbour((NeighbourAnt)this.neighbours.get(toBeRemoved));
            }
        } else if ((double)activeNumber > (double)maxNeighbours * 2.0 / 3.0) {
            if (activeUp == this.neighbours.size() && activeUp - activeDown > maxActiveOneWay) {
                toBeRemoved = -1;
                long currentPing = 0L;
                for (int x = 0; x < this.neighbours.size(); ++x) {
                    NeighbourAnt current = (NeighbourAnt)this.neighbours.get(x);
                    if (activeDownload[x] || !activeUpload[x] || current.getTimeElapsed() <= currentPing) continue;
                    currentPing = current.getTimeElapsed();
                    toBeRemoved = x;
                }
                if (toBeRemoved >= 0) {
                    _logger.info((Object)("Neighbour " + this.neighbours.get(toBeRemoved) + " is not active down, removing..."));
                    this.removeNeighbour((NeighbourAnt)this.neighbours.get(toBeRemoved));
                }
            } else if (activeDown == this.neighbours.size() && activeDown - activeUp > maxActiveOneWay) {
                toBeRemoved = -1;
                long currentPing = 0L;
                for (int x = 0; x < this.neighbours.size(); ++x) {
                    NeighbourAnt current = (NeighbourAnt)this.neighbours.get(x);
                    if (!activeDownload[x] || activeUpload[x] || current.getTimeElapsed() <= currentPing) continue;
                    currentPing = current.getTimeElapsed();
                    toBeRemoved = x;
                }
                if (toBeRemoved >= 0) {
                    _logger.info((Object)("Neighbour " + this.neighbours.get(toBeRemoved) + " is not active up, removing..."));
                    this.removeNeighbour((NeighbourAnt)this.neighbours.get(toBeRemoved));
                }
            }
        }
    }

    protected void processMessage(Message m, Router r) throws Exception {
        _logger.debug((Object)(this.getShortId() + ": Received Message = " + m.getAck_Id() + " type = " + m.getType() + " from a peer running version: " + m.getVersion()));
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void disconnect() {
        try {
            for (int x = 0; x < this.neighbours.size(); ++x) {
                NeighbourAnt na = (NeighbourAnt)this.neighbours.get(x);
                na.terminate();
            }
            if (this.ss.getServerSocket() != null) {
                this.ss.getServerSocket().close();
            }
            UPnPManager.instance().clearMappingsOnShutdown();
            if (UPnPManager.instance().mappingsExist()) {
                this.localInetAddress = this.localNattedInetAddress;
                this.serverPort = this.localNattedPort;
            }
            UPnPManager.instance().stopDevice();
            this.terminate = true;
        }
        catch (Exception e) {
            _logger.error((Object)(this.getShortId() + ""), (Throwable)e);
        }
    }

    public boolean isDisconnected() {
        return this.terminate;
    }
}

