/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class TigerDigestTest
implements Test {
    static final String[] digests;
    static final String hash64k = "FDF4F5B35139F48E710E421BE5AF411DE1A8AAC333F26204";
    static final String[] messages;

    static {
        messages = new String[]{"", "abc", "Tiger", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvw", "ABCDEFGHIJKLMNOPQRSTUVWXYZ=abcdefghijklmnopqrstuvwxyz+0123456789", "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, proceedings of Fast Software Encryption 3, Cambridge, 1996.", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-"};
        digests = new String[]{"3293AC630C13F0245F92BBB1766E16167A4E58492DDE73F3", "2AAB1484E8C158F2BFB8C5FF41B57A525129131C957B5F93", "DD00230799F5009FEC6DEBC838BB6A27DF2B9D6F110C7937", "F71C8583902AFB879EDFE610F82C0D4786A3A534504486B5", "38F41D9D9A710A10C3727AC0DEEAA270727D9F926EC10139", "48CEEB6308B87D46E95D656112CDF18D97915F9765658957", "631ABDD103EB9A3D245B6DFD4D77B257FC7439501D1568DD", "C54034E5B43EB8005848A7E0AE6AAC76E4FF590AE715FD25", "C54034E5B43EB8005848A7E0AE6AAC76E4FF590AE715FD25"};
    }

    public static boolean arraysEqual(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return "Tiger";
    }

    public static void main(String[] args) {
        TigerDigestTest test = new TigerDigestTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        byte[] m;
        TigerDigest digest = new TigerDigest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        boolean failCount = false;
        int i = 0;
        while (i < messages.length) {
            m = messages[i].getBytes();
            digest.update(m, 0, m.length);
            digest.doFinal(resBuf, 0);
            if (!TigerDigestTest.arraysEqual(resBuf, Hex.decode(digests[i]))) {
                return new SimpleTestResult(false, this.getName() + ": Vector " + i + " failed got " + new String(Hex.encode(resBuf)));
            }
            ++i;
        }
        m = messages[messages.length - 1].getBytes();
        digest.update(m, 0, m.length / 2);
        TigerDigest d = new TigerDigest(digest);
        digest.update(m, m.length / 2, m.length - m.length / 2);
        digest.doFinal(resBuf, 0);
        if (!TigerDigestTest.arraysEqual(resBuf, Hex.decode(digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "Tiger failing clone test" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode(resBuf)));
        }
        d.update(m, m.length / 2, m.length - m.length / 2);
        d.doFinal(resBuf, 0);
        if (!TigerDigestTest.arraysEqual(resBuf, Hex.decode(digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "Tiger failing clone test - part 2" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode(resBuf)));
        }
        int i2 = 0;
        while (i2 < 65536) {
            digest.update((byte)(i2 & 0xFF));
            ++i2;
        }
        digest.doFinal(resBuf, 0);
        if (!TigerDigestTest.arraysEqual(resBuf, Hex.decode(hash64k))) {
            return new SimpleTestResult(false, this.getName() + ": Million a's failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }
}

